/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.wgu.osmt.api.model.ApiAlignment;
import edu.wgu.osmt.api.model.ApiJobCode;
import edu.wgu.osmt.api.model.ApiNamedReference;
import edu.wgu.osmt.api.model.ApiSkill;
import edu.wgu.osmt.api.model.ApiUuidReference;
import edu.wgu.osmt.config.AppConfig;
import edu.wgu.osmt.db.JobCodeLevel;
import edu.wgu.osmt.db.PublishStatus;
import edu.wgu.osmt.jobcode.JobCode;
import edu.wgu.osmt.keyword.Keyword;
import edu.wgu.osmt.richskill.RichSkillDescriptor;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.ALWAYS)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\n\b\u0017\u0018\u0000 D2\u00020\u0001:\u0001DB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00108G\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000eR\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000eR\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000eR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000eR\u0016\u0010\u001e\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u00108G\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0012R\u0011\u0010#\u001a\u00020\u00148G\u00a2\u0006\u0006\u001a\u0004\b$\u0010 R\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00190\u000b8G\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u000eR\u0011\u0010)\u001a\u00020\u00148G\u00a2\u0006\u0006\u001a\u0004\b*\u0010 R\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b8G\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u000eR\u0017\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u000b8G\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u000eR\u0013\u00100\u001a\u0004\u0018\u00010\u00108G\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0012R\u0016\u0010\u0002\u001a\u00020\u00038\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0011\u00104\u001a\u00020\u00148G\u00a2\u0006\u0006\u001a\u0004\b5\u0010 R\u0011\u00106\u001a\u00020\u00148G\u00a2\u0006\u0006\u001a\u0004\b7\u0010 R\u0017\u00108\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8G\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u000eR\u0011\u0010:\u001a\u00020;8G\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0016\u0010>\u001a\u00020\u00148\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010 R\u0011\u0010@\u001a\u00020\u00108G\u00a2\u0006\u0006\u001a\u0004\bA\u0010\u0012R\u0011\u0010B\u001a\u00020\u00148G\u00a2\u0006\u0006\u001a\u0004\bC\u0010 \u00a8\u0006E"}, d2={"Ledu/wgu/osmt/api/model/ApiSkill;", "", "rsd", "Ledu/wgu/osmt/richskill/RichSkillDescriptor;", "cs", "", "Ledu/wgu/osmt/collection/Collection;", "appConfig", "Ledu/wgu/osmt/config/AppConfig;", "(Ledu/wgu/osmt/richskill/RichSkillDescriptor;Ljava/util/Set;Ledu/wgu/osmt/config/AppConfig;)V", "alignments", "", "Ledu/wgu/osmt/api/model/ApiAlignment;", "getAlignments", "()Ljava/util/List;", "archiveDate", "Ljava/time/ZonedDateTime;", "getArchiveDate", "()Ljava/time/ZonedDateTime;", "authors", "", "getAuthors", "categories", "getCategories", "certifications", "Ledu/wgu/osmt/api/model/ApiNamedReference;", "getCertifications", "collections", "Ledu/wgu/osmt/api/model/ApiUuidReference;", "getCollections", "context", "getContext", "()Ljava/lang/String;", "creationDate", "getCreationDate", "creator", "getCreator", "getCs", "()Ljava/util/Set;", "employers", "getEmployers", "id", "getId", "keywords", "getKeywords", "occupations", "Ledu/wgu/osmt/api/model/ApiJobCode;", "getOccupations", "publishDate", "getPublishDate", "getRsd", "()Ledu/wgu/osmt/richskill/RichSkillDescriptor;", "skillName", "getSkillName", "skillStatement", "getSkillStatement", "standards", "getStandards", "status", "Ledu/wgu/osmt/db/PublishStatus;", "getStatus", "()Ledu/wgu/osmt/db/PublishStatus;", "type", "getType", "updateDate", "getUpdateDate", "uuid", "getUuid", "Companion", "osmt-api"})
public class ApiSkill {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JsonIgnore
    @NotNull
    private final RichSkillDescriptor rsd;
    @JsonIgnore
    @NotNull
    private final Set<edu.wgu.osmt.collection.Collection> cs;
    @NotNull
    private final AppConfig appConfig;
    @JsonProperty(value="@context")
    @NotNull
    private final String context;
    @JsonProperty
    @NotNull
    private final String type;

    public ApiSkill(@NotNull RichSkillDescriptor rsd, @NotNull Set<edu.wgu.osmt.collection.Collection> cs, @NotNull AppConfig appConfig) {
        Intrinsics.checkNotNullParameter((Object)rsd, (String)"rsd");
        Intrinsics.checkNotNullParameter(cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        this.rsd = rsd;
        this.cs = cs;
        this.appConfig = appConfig;
        this.context = this.appConfig.getRsdContextUrl();
        this.type = "RichSkillDescriptor";
    }

    @NotNull
    public RichSkillDescriptor getRsd() {
        return this.rsd;
    }

    @NotNull
    public Set<edu.wgu.osmt.collection.Collection> getCs() {
        return this.cs;
    }

    @NotNull
    public final String getContext() {
        return this.context;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @JsonProperty
    @NotNull
    public final String getCreator() {
        return this.appConfig.getDefaultCreatorUri();
    }

    /*
     * WARNING - void declaration
     */
    @JsonProperty
    @NotNull
    public List<String> getAuthors() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.getRsd().getAuthors();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Keyword it = (Keyword)element$iv$iv;
            boolean bl2 = false;
            if (it.getValue() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JsonProperty
    @NotNull
    public final PublishStatus getStatus() {
        return this.getRsd().publishStatus();
    }

    @JsonProperty
    @NotNull
    public final ZonedDateTime getCreationDate() {
        ZonedDateTime zonedDateTime = this.getRsd().getCreationDate().atZone(ZoneId.of("UTC"));
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"rsd.creationDate.atZone(ZoneId.of(\"UTC\"))");
        return zonedDateTime;
    }

    @JsonProperty
    @NotNull
    public final ZonedDateTime getUpdateDate() {
        ZonedDateTime zonedDateTime = this.getRsd().getUpdateDate().atZone(ZoneId.of("UTC"));
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"rsd.updateDate.atZone(ZoneId.of(\"UTC\"))");
        return zonedDateTime;
    }

    @JsonProperty
    @Nullable
    public final ZonedDateTime getPublishDate() {
        LocalDateTime localDateTime = this.getRsd().getPublishDate();
        return localDateTime != null ? localDateTime.atZone(ZoneId.of("UTC")) : null;
    }

    @JsonProperty
    @Nullable
    public final ZonedDateTime getArchiveDate() {
        LocalDateTime localDateTime = this.getRsd().getArchiveDate();
        return localDateTime != null ? localDateTime.atZone(ZoneId.of("UTC")) : null;
    }

    @JsonProperty
    @NotNull
    public final String getSkillName() {
        return this.getRsd().getName();
    }

    @JsonProperty
    @NotNull
    public final String getSkillStatement() {
        return this.getRsd().getStatement();
    }

    /*
     * WARNING - void declaration
     */
    @JsonProperty
    @NotNull
    public final List<String> getKeywords() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.getRsd().getSearchingKeywords();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Keyword it = (Keyword)element$iv$iv;
            boolean bl2 = false;
            if (it.getValue() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JsonProperty
    @NotNull
    public List<String> getCategories() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.getRsd().getCategories();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Keyword it = (Keyword)element$iv$iv;
            boolean bl2 = false;
            if (it.getValue() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JsonProperty
    @NotNull
    public final String getId() {
        return this.getRsd().canonicalUrl(this.appConfig.getBaseUrl());
    }

    @JsonProperty
    @NotNull
    public final String getUuid() {
        return this.getRsd().getUuid().toString();
    }

    /*
     * WARNING - void declaration
     */
    @JsonProperty
    @NotNull
    public final List<ApiNamedReference> getCertifications() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getRsd().getCertifications();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Keyword keyword = (Keyword)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ApiNamedReference.factory.fromKeyword((Keyword)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JsonProperty
    @NotNull
    public final List<ApiAlignment> getStandards() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getRsd().getStandards();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Keyword keyword = (Keyword)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ApiAlignment.factory.fromKeyword((Keyword)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JsonProperty
    @NotNull
    public final List<ApiAlignment> getAlignments() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getRsd().getAlignments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Keyword keyword = (Keyword)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ApiAlignment.factory.fromKeyword((Keyword)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JsonProperty
    @NotNull
    public final List<ApiJobCode> getOccupations() {
        void $this$mapTo$iv$iv;
        JobCode it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getRsd().getJobCodes();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (JobCode)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it.getCode());
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ApiJobCode apiJobCode;
            ApiJobCode apiJobCode2;
            ApiJobCode apiJobCode3;
            ApiJobCode apiJobCode4;
            ApiJobCode apiJobCode5;
            String it2;
            void jobCode;
            it = (JobCode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object[] objectArray = new ApiJobCode[4];
            String string = jobCode.getMajor();
            int n = 0;
            Object[] objectArray2 = objectArray;
            boolean bl3 = false;
            if (jobCode.getMajorCode() != null) {
                boolean bl4 = false;
                apiJobCode5 = new ApiJobCode(it2, null, jobCode.getMajor(), null, JobCodeLevel.Major, null, 42, null);
            } else {
                apiJobCode5 = null;
            }
            objectArray2[n] = apiJobCode4 = apiJobCode5;
            String it3 = jobCode.getMinor();
            n = 1;
            objectArray2 = objectArray;
            boolean bl5 = false;
            if (jobCode.getMinorCode() != null) {
                boolean bl6 = false;
                apiJobCode3 = new ApiJobCode(it2, null, jobCode.getMinor(), null, JobCodeLevel.Minor, null, 42, null);
            } else {
                apiJobCode3 = null;
            }
            objectArray2[n] = apiJobCode4 = apiJobCode3;
            Object[] objectArray3 = objectArray;
            int n2 = 2;
            if (jobCode.getBroad() != null) {
                ApiJobCode apiJobCode6;
                n = n2;
                objectArray2 = objectArray3;
                boolean bl7 = false;
                if (jobCode.getBroadCode() != null) {
                    String it4;
                    boolean bl8 = false;
                    apiJobCode6 = new ApiJobCode(it4, null, jobCode.getBroad(), null, JobCodeLevel.Broad, null, 42, null);
                } else {
                    apiJobCode6 = null;
                }
                apiJobCode4 = apiJobCode6;
                objectArray3 = objectArray2;
                n2 = n;
                apiJobCode2 = apiJobCode4;
            } else {
                apiJobCode2 = null;
            }
            objectArray3[n2] = apiJobCode2;
            Object[] objectArray4 = objectArray;
            int n3 = 3;
            if (jobCode.getDetailed() != null) {
                ApiJobCode apiJobCode7;
                n = n3;
                objectArray2 = objectArray4;
                boolean bl9 = false;
                if (jobCode.getDetailedCode() != null) {
                    String it5;
                    boolean bl10 = false;
                    apiJobCode7 = new ApiJobCode(it5, null, jobCode.getDetailed(), null, JobCodeLevel.Detailed, null, 42, null);
                } else {
                    apiJobCode7 = null;
                }
                apiJobCode4 = apiJobCode7;
                objectArray4 = objectArray2;
                n3 = n;
                apiJobCode = apiJobCode4;
            } else {
                apiJobCode = null;
            }
            objectArray4[n3] = apiJobCode;
            List parents = CollectionsKt.distinct((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
            collection.add(ApiJobCode.factory.fromJobCode$default((ApiJobCode.factory)ApiJobCode.factory, (JobCode)jobCode, null, (List)parents, (int)2, null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JsonProperty
    @NotNull
    public final List<ApiNamedReference> getEmployers() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getRsd().getEmployers();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Keyword keyword = (Keyword)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ApiNamedReference.factory.fromKeyword((Keyword)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JsonProperty
    @NotNull
    public final List<ApiUuidReference> getCollections() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getCs();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            edu.wgu.osmt.collection.Collection collection = (edu.wgu.osmt.collection.Collection)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(ApiUuidReference.factory.fromCollection((edu.wgu.osmt.collection.Collection)it));
        }
        return (List)destination$iv$iv;
    }
}

