/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.io.csv;

import com.github.sonus21.rqueue.annotation.RqueueListener;
import edu.wgu.osmt.collection.CollectionDao;
import edu.wgu.osmt.db.PublishStatus;
import edu.wgu.osmt.io.common.TabularTask;
import edu.wgu.osmt.io.csv.RichSkillCsvExportV2;
import edu.wgu.osmt.richskill.RichSkillAndCollections;
import edu.wgu.osmt.richskill.RichSkillDescriptorDao;
import edu.wgu.osmt.task.CsvTaskV2;
import edu.wgu.osmt.task.Task;
import edu.wgu.osmt.task.TaskStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.SizedIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Profile(value={"apiserver"})
@Transactional
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0017J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Ledu/wgu/osmt/io/csv/CsvTaskProcessorV2;", "Ledu/wgu/osmt/io/common/TabularTask;", "Ledu/wgu/osmt/task/CsvTaskV2;", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "tabularSkillsInCollectionProcessor", "", "task", "tabularSkillsInFullLibraryProcessor", "osmt-api"})
public class CsvTaskProcessorV2
extends TabularTask<CsvTaskV2> {
    @NotNull
    private final Logger logger;

    public CsvTaskProcessorV2() {
        Logger logger = LoggerFactory.getLogger(CsvTaskProcessorV2.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(CsvTaskProcessorV2::class.java)");
        this.logger = logger;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    @RqueueListener(value={"collection-skills-csv-process-v2"}, deadLetterQueue="dead-letters", deadLetterQueueListenerEnabled="true", concurrency="1")
    public void tabularSkillsInCollectionProcessor(@NotNull CsvTaskV2 task) {
        String string;
        SizedIterable sizedIterable;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.getLogger().info("Started processing task id: " + task.getUuid());
        CollectionDao collectionDao = this.getCollectionRepository().findByUUID(task.getCollectionUuid());
        if (collectionDao != null && (sizedIterable = collectionDao.getSkills()) != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = (Iterable)sizedIterable;
            boolean $i$f$filter22 = false;
            void var7_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RichSkillDescriptorDao it = (RichSkillDescriptorDao)element$iv$iv;
                boolean bl = false;
                if (!(PublishStatus.Archived != it.publishStatus())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $i$f$filter22 = (List)destination$iv$iv;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RichSkillDescriptorDao bl = (RichSkillDescriptorDao)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(RichSkillAndCollections.Companion.fromDao((RichSkillDescriptorDao)it));
            }
            List it = (List)destination$iv$iv2;
            boolean bl = false;
            string = new RichSkillCsvExportV2(this.getAppConfig()).toCsv(it);
        } else {
            string = null;
        }
        String csv = string;
        this.getTaskMessageService().publishResult((Task)CsvTaskV2.copy$default((CsvTaskV2)task, null, null, null, csv, (TaskStatus)TaskStatus.Ready, (int)7, null));
        this.getLogger().info("Task " + task.getUuid() + " completed");
    }

    /*
     * WARNING - void declaration
     */
    @RqueueListener(value={"full-library-skills-csv-process-v2"}, deadLetterQueue="dead-letters", deadLetterQueueListenerEnabled="true", concurrency="1")
    public void tabularSkillsInFullLibraryProcessor(@NotNull CsvTaskV2 task) {
        String string;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.getLogger().info("Started processing task for Full Library .csv export");
        SizedIterable sizedIterable = this.getRichSkillRepository().findAll();
        if (sizedIterable != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = (Iterable)sizedIterable;
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RichSkillDescriptorDao richSkillDescriptorDao = (RichSkillDescriptorDao)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(RichSkillAndCollections.Companion.fromDao((RichSkillDescriptorDao)it));
            }
            List it = (List)destination$iv$iv;
            boolean bl = false;
            string = new RichSkillCsvExportV2(this.getAppConfig()).toCsv(it);
        } else {
            string = null;
        }
        String csv = string;
        this.getTaskMessageService().publishResult((Task)CsvTaskV2.copy$default((CsvTaskV2)task, null, null, null, csv, (TaskStatus)TaskStatus.Ready, (int)7, null));
        this.getLogger().info("Full Library export task .csv completed");
    }
}

