/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.security;

import edu.wgu.osmt.config.AppConfig;
import edu.wgu.osmt.security.RedirectToFrontend;
import edu.wgu.osmt.security.ReturnUnauthorized;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
@EnableWebSecurity
@Profile(value={"oauth2-okta | OTHER-OAUTH-PROFILE"})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0017J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017R\u001e\u0010\u0003\u001a\u00020\u00048\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Ledu/wgu/osmt/security/SecurityConfig;", "", "()V", "appConfig", "Ledu/wgu/osmt/config/AppConfig;", "getAppConfig", "()Ledu/wgu/osmt/config/AppConfig;", "setAppConfig", "(Ledu/wgu/osmt/config/AppConfig;)V", "redirectToFrontend", "Ledu/wgu/osmt/security/RedirectToFrontend;", "getRedirectToFrontend", "()Ledu/wgu/osmt/security/RedirectToFrontend;", "setRedirectToFrontend", "(Ledu/wgu/osmt/security/RedirectToFrontend;)V", "returnUnauthorized", "Ledu/wgu/osmt/security/ReturnUnauthorized;", "getReturnUnauthorized", "()Ledu/wgu/osmt/security/ReturnUnauthorized;", "setReturnUnauthorized", "(Ledu/wgu/osmt/security/ReturnUnauthorized;)V", "configureForNoRoles", "", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "configureForRoles", "corsConfigurationSource", "Lorg/springframework/web/cors/CorsConfigurationSource;", "securityFilterChain", "Lorg/springframework/security/web/SecurityFilterChain;", "osmt-api"})
public class SecurityConfig {
    @Autowired
    public AppConfig appConfig;
    @Autowired
    public RedirectToFrontend redirectToFrontend;
    @Autowired
    public ReturnUnauthorized returnUnauthorized;

    @NotNull
    public AppConfig getAppConfig() {
        AppConfig appConfig = this.appConfig;
        if (appConfig != null) {
            return appConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"appConfig");
        return null;
    }

    public void setAppConfig(@NotNull AppConfig appConfig) {
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"<set-?>");
        this.appConfig = appConfig;
    }

    @NotNull
    public RedirectToFrontend getRedirectToFrontend() {
        RedirectToFrontend redirectToFrontend = this.redirectToFrontend;
        if (redirectToFrontend != null) {
            return redirectToFrontend;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"redirectToFrontend");
        return null;
    }

    public void setRedirectToFrontend(@NotNull RedirectToFrontend redirectToFrontend) {
        Intrinsics.checkNotNullParameter((Object)redirectToFrontend, (String)"<set-?>");
        this.redirectToFrontend = redirectToFrontend;
    }

    @NotNull
    public ReturnUnauthorized getReturnUnauthorized() {
        ReturnUnauthorized returnUnauthorized = this.returnUnauthorized;
        if (returnUnauthorized != null) {
            return returnUnauthorized;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"returnUnauthorized");
        return null;
    }

    public void setReturnUnauthorized(@NotNull ReturnUnauthorized returnUnauthorized) {
        Intrinsics.checkNotNullParameter((Object)returnUnauthorized, (String)"<set-?>");
        this.returnUnauthorized = returnUnauthorized;
    }

    @Bean
    @NotNull
    public SecurityFilterChain securityFilterChain(@NotNull HttpSecurity http) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        ((HttpSecurity)((OAuth2LoginConfigurer)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.cors().and()).csrf().disable()).httpBasic().disable()).authorizeHttpRequests(SecurityConfig::securityFilterChain$lambda$0).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.getReturnUnauthorized()).and()).oauth2Login().successHandler((AuthenticationSuccessHandler)this.getRedirectToFrontend())).and()).oauth2ResourceServer().jwt();
        if (this.getAppConfig().getEnableRoles()) {
            this.configureForRoles(http);
        } else {
            this.configureForNoRoles(http);
        }
        Object object = http.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"http.build()");
        return (SecurityFilterChain)object;
    }

    public void configureForRoles(@NotNull HttpSecurity http) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        String ADMIN = this.getAppConfig().getRoleAdmin();
        String CURATOR = this.getAppConfig().getRoleCurator();
        String VIEW = this.getAppConfig().getRoleView();
        String READ = this.getAppConfig().getScopeRead();
        if (this.getAppConfig().getAllowPublicLists()) {
            http.authorizeHttpRequests(SecurityConfig::configureForRoles$lambda$1);
        } else {
            http.authorizeHttpRequests(arg_0 -> SecurityConfig.configureForRoles$lambda$2(ADMIN, CURATOR, VIEW, READ, arg_0));
        }
        http.authorizeHttpRequests(arg_0 -> SecurityConfig.configureForRoles$lambda$3(ADMIN, CURATOR, VIEW, READ, arg_0));
    }

    public void configureForNoRoles(@NotNull HttpSecurity http) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        http.authorizeHttpRequests(SecurityConfig::configureForNoRoles$lambda$4);
    }

    @Bean
    @Nullable
    public CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        Object[] objectArray = new String[]{","};
        configuration.setAllowedOrigins(StringsKt.split$default((CharSequence)this.getAppConfig().getCorsAllowedOrigins(), (String[])objectArray, (boolean)false, (int)0, (int)6, null));
        objectArray = new String[]{"HEAD", "GET", "POST", "PUT", "DELETE", "PATCH"};
        configuration.setAllowedMethods(CollectionsKt.listOf((Object[])objectArray));
        configuration.setAllowCredentials(Boolean.valueOf(true));
        objectArray = new String[]{"Authorization", "Cache-Control", "Content-Type"};
        configuration.setAllowedHeaders(CollectionsKt.listOf((Object[])objectArray));
        configuration.setExposedHeaders(CollectionsKt.listOf((Object)"X-Total-Count"));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return (CorsConfigurationSource)source;
    }

    private static final void securityFilterChain$lambda$0(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry auth) {
        String[] stringArray = new String[]{"/api/v3/skills/{uuid}/log", "/api/v2/skills/{uuid}/log", "/api/skills/{uuid}/log"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(HttpMethod.GET, stringArray)).authenticated();
        stringArray = new String[]{"/api/v3/collections/{uuid}/log", "/api/v2/collections/{uuid}/log", "/api/collections/{uuid}/log"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry2 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry.requestMatchers(HttpMethod.GET, stringArray)).authenticated();
        stringArray = new String[]{"/api/v3/results/skills/{uuid}", "/api/v2/results/skills/{uuid}", "/api/results/skills/{uuid}"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry3 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry2.requestMatchers(HttpMethod.GET, stringArray)).authenticated();
        stringArray = new String[]{"/api/v3/results/batch/{uuid}", "/api/v2/results/batch/{uuid}", "/api/results/batch/{uuid}"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry4 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry3.requestMatchers(HttpMethod.GET, stringArray)).authenticated();
        stringArray = new String[]{"/api/v3/search/jobcodes", "/api/v2/search/jobcodes", "/api/search/jobcodes"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry5 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry4.requestMatchers(HttpMethod.GET, stringArray)).authenticated();
        stringArray = new String[]{"/api/v3/search/keywords", "/api/v2/search/keywords", "/api/search/keywords"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry6 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry5.requestMatchers(HttpMethod.GET, stringArray)).authenticated();
        stringArray = new String[]{"/api/v3/search/skills", "/api/v2/search/skills", "/api/search/skills"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry7 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry6.requestMatchers(HttpMethod.POST, stringArray)).permitAll();
        stringArray = new String[]{"/api/v3/search/collections", "/api/v2/search/collections", "/api/search/collections"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry8 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry7.requestMatchers(HttpMethod.POST, stringArray)).permitAll();
        stringArray = new String[]{"/api/v3/skills/{uuid}", "/api/v2/skills/{uuid}", "/api/skills/{uuid}"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry9 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry8.requestMatchers(HttpMethod.GET, stringArray)).permitAll();
        stringArray = new String[]{"/api/v3/collections/{uuid}", "/api/v2/collections/{uuid}", "/api/collections/{uuid}"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry10 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry9.requestMatchers(HttpMethod.GET, stringArray)).permitAll();
        stringArray = new String[]{"/api/v3/collections/{uuid}/skills", "/api/v2/collections/{uuid}/skills", "/api/collections/{uuid}/skills"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry11 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry10.requestMatchers(HttpMethod.POST, stringArray)).permitAll();
        stringArray = new String[]{"/api/v3/collections/{uuid}/csv", "/api/v2/collections/{uuid}/csv", "/api/collections/{uuid}/csv"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry12 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry11.requestMatchers(HttpMethod.GET, stringArray)).permitAll();
        stringArray = new String[]{"/api/v3/results/text/{uuid}", "/api/v2/results/text/{uuid}", "/api/results/text/{uuid}"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry13 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry12.requestMatchers(HttpMethod.GET, stringArray)).permitAll();
        stringArray = new String[]{"/api/v3/collections/{uuid}/xlsx", "/api/v2/collections/{uuid}/xlsx", "/api/collections/{uuid}/xlsx"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry14 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry13.requestMatchers(HttpMethod.GET, stringArray)).permitAll();
        stringArray = new String[]{"/api/v3/results/media/{uuid}", "/api/v2/results/media/{uuid}", "/api/results/media/{uuid}"};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry14.requestMatchers(HttpMethod.GET, stringArray)).permitAll();
    }

    private static final void configureForRoles$lambda$1(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry auth) {
        String[] stringArray = new String[]{"/api/v3/skills", "/api/v2/skills", "/api/skills"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(HttpMethod.GET, stringArray)).permitAll();
        stringArray = new String[]{"/api/v3/collections", "/api/v2/collections", "/api/collections"};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry.requestMatchers(HttpMethod.GET, stringArray)).permitAll();
    }

    private static final void configureForRoles$lambda$2(String $ADMIN, String $CURATOR, String $VIEW, String $READ, AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry auth) {
        Intrinsics.checkNotNullParameter((Object)$ADMIN, (String)"$ADMIN");
        Intrinsics.checkNotNullParameter((Object)$CURATOR, (String)"$CURATOR");
        Intrinsics.checkNotNullParameter((Object)$VIEW, (String)"$VIEW");
        Intrinsics.checkNotNullParameter((Object)$READ, (String)"$READ");
        String[] stringArray = new String[]{"/api/v3/skills", "/api/v2/skills", "/api/skills"};
        AuthorizeHttpRequestsConfigurer.AuthorizedUrl authorizedUrl = (AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(HttpMethod.GET, stringArray);
        stringArray = new String[]{$ADMIN, $CURATOR, $VIEW, $READ};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = authorizedUrl.hasAnyAuthority(stringArray);
        stringArray = new String[]{"/api/v3/collections", "/api/v2/collections", "/api/collections"};
        AuthorizeHttpRequestsConfigurer.AuthorizedUrl authorizedUrl2 = (AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry.requestMatchers(HttpMethod.GET, stringArray);
        stringArray = new String[]{$ADMIN, $CURATOR, $VIEW, $READ};
        authorizedUrl2.hasAnyAuthority(stringArray);
    }

    private static final void configureForRoles$lambda$3(String $ADMIN, String $CURATOR, String $VIEW, String $READ, AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry auth) {
        Intrinsics.checkNotNullParameter((Object)$ADMIN, (String)"$ADMIN");
        Intrinsics.checkNotNullParameter((Object)$CURATOR, (String)"$CURATOR");
        Intrinsics.checkNotNullParameter((Object)$VIEW, (String)"$VIEW");
        Intrinsics.checkNotNullParameter((Object)$READ, (String)"$READ");
        String[] stringArray = new String[]{"/api/v3/skills/{uuid}/update", "/api/v2/skills/{uuid}/update", "/api/skills/{uuid}/update"};
        AuthorizeHttpRequestsConfigurer.AuthorizedUrl authorizedUrl = (AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(HttpMethod.POST, stringArray);
        stringArray = new String[]{$ADMIN, $CURATOR};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = authorizedUrl.hasAnyAuthority(stringArray);
        stringArray = new String[]{"/api/v3/skills", "/api/v2/skills", "/api/skills"};
        AuthorizeHttpRequestsConfigurer.AuthorizedUrl authorizedUrl2 = (AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry.requestMatchers(HttpMethod.POST, stringArray);
        stringArray = new String[]{$ADMIN, $CURATOR};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry2 = authorizedUrl2.hasAnyAuthority(stringArray);
        stringArray = new String[]{"/api/v3/skills/publish", "/api/v2/skills/publish", "/api/skills/publish"};
        AuthorizeHttpRequestsConfigurer.AuthorizedUrl authorizedUrl3 = (AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry2.requestMatchers(HttpMethod.POST, stringArray);
        stringArray = new String[]{$ADMIN};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry3 = authorizedUrl3.hasAnyAuthority(stringArray);
        stringArray = new String[]{"/api/v3/collections", "/api/v2/collections", "/api/collections"};
        AuthorizeHttpRequestsConfigurer.AuthorizedUrl authorizedUrl4 = (AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry3.requestMatchers(HttpMethod.POST, stringArray);
        stringArray = new String[]{$ADMIN, $CURATOR};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry4 = authorizedUrl4.hasAnyAuthority(stringArray);
        stringArray = new String[]{"/api/v3/collections/publish", "/api/v2/collections/publish", "/api/collections/publish"};
        AuthorizeHttpRequestsConfigurer.AuthorizedUrl authorizedUrl5 = (AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry4.requestMatchers(HttpMethod.POST, stringArray);
        stringArray = new String[]{$ADMIN};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry5 = authorizedUrl5.hasAnyAuthority(stringArray);
        stringArray = new String[]{"/api/v3/collections/{uuid}/update", "/api/v2/collections/{uuid}/update", "/api/collections/{uuid}/update"};
        AuthorizeHttpRequestsConfigurer.AuthorizedUrl authorizedUrl6 = (AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry5.requestMatchers(HttpMethod.POST, stringArray);
        stringArray = new String[]{$ADMIN, $CURATOR};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry6 = authorizedUrl6.hasAnyAuthority(stringArray);
        stringArray = new String[]{"/api/v3/collections/{uuid}/updateSkills", "/api/v2/collections/{uuid}/updateSkills", "/api/collections/{uuid}/updateSkills"};
        AuthorizeHttpRequestsConfigurer.AuthorizedUrl authorizedUrl7 = (AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry6.requestMatchers(HttpMethod.POST, stringArray);
        stringArray = new String[]{$ADMIN, $CURATOR};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry7 = authorizedUrl7.hasAnyAuthority(stringArray);
        stringArray = new String[]{"/api/v3/collections/{uuid}/remove", "/api/v2/collections/{uuid}/remove", "/api/collections/{uuid}/remove"};
        AuthorizeHttpRequestsConfigurer.AuthorizedUrl authorizedUrl8 = (AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry7.requestMatchers(HttpMethod.DELETE, stringArray);
        stringArray = new String[]{$ADMIN};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry8 = authorizedUrl8.hasAnyAuthority(stringArray);
        stringArray = new String[]{"/api/v3/workspace", "/api/v2/workspace", "/api/workspace"};
        AuthorizeHttpRequestsConfigurer.AuthorizedUrl authorizedUrl9 = (AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry8.requestMatchers(HttpMethod.GET, stringArray);
        stringArray = new String[]{$ADMIN, $CURATOR};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry9 = authorizedUrl9.hasAnyAuthority(stringArray);
        stringArray = new String[]{"/api/**"};
        AuthorizeHttpRequestsConfigurer.AuthorizedUrl authorizedUrl10 = (AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry9.requestMatchers(stringArray);
        stringArray = new String[]{$ADMIN, $CURATOR, $VIEW, $READ};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry10 = authorizedUrl10.hasAnyAuthority(stringArray);
        stringArray = new String[]{"/**"};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry10.requestMatchers(stringArray)).permitAll();
    }

    private static final void configureForNoRoles$lambda$4(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry auth) {
        String[] stringArray = new String[]{"/api/v3/skills", "/api/v2/skills", "/api/skills"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(HttpMethod.GET, stringArray)).permitAll();
        stringArray = new String[]{"/api/v3/collections", "/api/v2/collections", "/api/collections"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry2 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry.requestMatchers(HttpMethod.GET, stringArray)).permitAll();
        stringArray = new String[]{"/api/v3/skills/{uuid}/update", "/api/v2/skills/{uuid}/update", "/api/skills/{uuid}/update"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry3 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry2.requestMatchers(HttpMethod.POST, stringArray)).authenticated();
        stringArray = new String[]{"/api/v3/skills", "/api/v2/skills", "/api/skills"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry4 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry3.requestMatchers(HttpMethod.POST, stringArray)).authenticated();
        stringArray = new String[]{"/api/v3/skills/publish", "/api/v2/skills/publish", "/api/skills/publish"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry5 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry4.requestMatchers(HttpMethod.POST, stringArray)).authenticated();
        stringArray = new String[]{"/api/v3/collections", "/api/v2/collections", "/api/collections"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry6 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry5.requestMatchers(HttpMethod.POST, stringArray)).authenticated();
        stringArray = new String[]{"/api/v3/collections/publish", "/api/v2/collections/publish", "/api/collections/publish"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry7 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry6.requestMatchers(HttpMethod.POST, stringArray)).authenticated();
        stringArray = new String[]{"/api/v3/collections/{uuid}/update", "/api/v2/collections/{uuid}/update", "/api/collections/{uuid}/update"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry8 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry7.requestMatchers(HttpMethod.POST, stringArray)).authenticated();
        stringArray = new String[]{"/api/v3/collections/{uuid}/updateSkills", "/api/v2/collections/{uuid}/updateSkills", "/api/collections/{uuid}/updateSkills"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry9 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry8.requestMatchers(HttpMethod.POST, stringArray)).authenticated();
        stringArray = new String[]{"/api/v3/collections/{uuid}/remove", "/api/v2/collections/{uuid}/remove", "/api/collections/{uuid}/remove"};
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry10 = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry9.requestMatchers(HttpMethod.DELETE, stringArray)).denyAll();
        stringArray = new String[]{"/**"};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry10.requestMatchers(stringArray)).permitAll();
    }
}

