/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.task;

import edu.wgu.osmt.task.Task;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.session.data.redis.config.ConfigureRedisAction;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;
import org.springframework.session.web.context.AbstractHttpSessionApplicationInitializer;

@Configuration
@EnableRedisHttpSession
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0017J\b\u0010\u000b\u001a\u00020\fH\u0017J\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\u000eH\u0017R\u001e\u0010\u0003\u001a\u00020\u00048\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Ledu/wgu/osmt/task/RedisConfig;", "Lorg/springframework/session/web/context/AbstractHttpSessionApplicationInitializer;", "()V", "redisUri", "", "getRedisUri", "()Ljava/lang/String;", "setRedisUri", "(Ljava/lang/String;)V", "configureRedisAction", "Lorg/springframework/session/data/redis/config/ConfigureRedisAction;", "redisConnectionFactory", "Lorg/springframework/data/redis/connection/lettuce/LettuceConnectionFactory;", "redisTaskTemplate", "Lorg/springframework/data/redis/core/RedisTemplate;", "Ledu/wgu/osmt/task/Task;", "osmt-api"})
public class RedisConfig
extends AbstractHttpSessionApplicationInitializer {
    @Value(value="${redis.uri}")
    public String redisUri;

    @NotNull
    public String getRedisUri() {
        String string = this.redisUri;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"redisUri");
        return null;
    }

    public void setRedisUri(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.redisUri = string;
    }

    @Bean
    @NotNull
    public ConfigureRedisAction configureRedisAction() {
        ConfigureRedisAction configureRedisAction = ConfigureRedisAction.NO_OP;
        Intrinsics.checkNotNullExpressionValue((Object)configureRedisAction, (String)"NO_OP");
        return configureRedisAction;
    }

    @Bean
    @NotNull
    public LettuceConnectionFactory redisConnectionFactory() {
        String[] stringArray = new String[]{":"};
        List list = StringsKt.split$default((CharSequence)this.getRedisUri(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String redisHost = (String)list.get(0);
        String redisPort = (String)list.get(1);
        RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration(redisHost, Integer.parseInt(redisPort));
        return new LettuceConnectionFactory(redisStandaloneConfiguration);
    }

    @Bean
    @NotNull
    public RedisTemplate<String, Task> redisTaskTemplate() {
        RedisTemplate template = new RedisTemplate();
        RedisSerializer stringSerializer = (RedisSerializer)new StringRedisSerializer();
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Task.class);
        template.setConnectionFactory((RedisConnectionFactory)this.redisConnectionFactory());
        template.setKeySerializer(stringSerializer);
        template.setHashKeySerializer(stringSerializer);
        template.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.setEnableTransactionSupport(false);
        template.afterPropertiesSet();
        return template;
    }
}

