/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.task;

import edu.wgu.osmt.api.model.ApiSkill;
import edu.wgu.osmt.api.model.ApiSkillV2;
import edu.wgu.osmt.config.AppConfig;
import edu.wgu.osmt.richskill.RichSkillDescriptorDao;
import edu.wgu.osmt.richskill.RichSkillRepository;
import edu.wgu.osmt.task.CreateSkillsTask;
import edu.wgu.osmt.task.CreateSkillsTaskV2;
import edu.wgu.osmt.task.Task;
import edu.wgu.osmt.task.TaskController;
import edu.wgu.osmt.task.TaskMessageService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Transactional
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0017J\u0016\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0017J\u0016\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0017J\u0016\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0017J\u0014\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0012J\u0016\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0017R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Ledu/wgu/osmt/task/TaskController;", "", "taskMessageService", "Ledu/wgu/osmt/task/TaskMessageService;", "richSkillRepository", "Ledu/wgu/osmt/richskill/RichSkillRepository;", "appConfig", "Ledu/wgu/osmt/config/AppConfig;", "(Ledu/wgu/osmt/task/TaskMessageService;Ledu/wgu/osmt/richskill/RichSkillRepository;Ledu/wgu/osmt/config/AppConfig;)V", "getAppConfig", "()Ledu/wgu/osmt/config/AppConfig;", "getRichSkillRepository", "()Ledu/wgu/osmt/richskill/RichSkillRepository;", "getTaskMessageService", "()Ledu/wgu/osmt/task/TaskMessageService;", "batchResult", "Lorg/springframework/http/HttpEntity;", "uuid", "", "mediaResult", "skillsResult", "skillsResultV2", "taskResult", "textResult", "osmt-api"})
public class TaskController {
    @NotNull
    private final TaskMessageService taskMessageService;
    @NotNull
    private final RichSkillRepository richSkillRepository;
    @NotNull
    private final AppConfig appConfig;

    @Autowired
    public TaskController(@NotNull TaskMessageService taskMessageService, @NotNull RichSkillRepository richSkillRepository, @NotNull AppConfig appConfig) {
        Intrinsics.checkNotNullParameter((Object)taskMessageService, (String)"taskMessageService");
        Intrinsics.checkNotNullParameter((Object)richSkillRepository, (String)"richSkillRepository");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        this.taskMessageService = taskMessageService;
        this.richSkillRepository = richSkillRepository;
        this.appConfig = appConfig;
    }

    @NotNull
    public TaskMessageService getTaskMessageService() {
        return this.taskMessageService;
    }

    @NotNull
    public RichSkillRepository getRichSkillRepository() {
        return this.richSkillRepository;
    }

    @NotNull
    public AppConfig getAppConfig() {
        return this.appConfig;
    }

    private HttpEntity<?> taskResult(String uuid) {
        HttpEntity httpEntity;
        Task task;
        Task task2 = task = (Task)this.getTaskMessageService().getOpsForHash().get((Object)"tasks", (Object)uuid);
        Object object = task2 != null ? task2.getStatus() : null;
        if ((object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) == 1) {
            httpEntity = Task.Companion.resultResponse(task);
        } else {
            ResponseEntity responseEntity = ResponseEntity.status((int)404).body((Object)("Task with id " + uuid + " not ready or not found"));
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"status(404).body(\"Task w\u2026 not ready or not found\")");
            httpEntity = (HttpEntity)responseEntity;
        }
        return httpEntity;
    }

    @GetMapping(path={"/api/v2/results/text/{uuid}", "/api/v3/results/text/{uuid}", "/api/results/text/{uuid}"})
    @ResponseBody
    @NotNull
    public HttpEntity<?> textResult(@PathVariable @NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return this.taskResult(uuid);
    }

    @GetMapping(value={"/api/v3/results/media/{uuid}"})
    @ResponseBody
    @NotNull
    public HttpEntity<?> mediaResult(@PathVariable @NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return this.taskResult(uuid);
    }

    @GetMapping(path={"/api/v2/results/batch/{uuid}", "/api/v3/results/batch/{uuid}", "/api/results/batch/{uuid}"})
    @ResponseBody
    @NotNull
    public HttpEntity<?> batchResult(@PathVariable @NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return this.taskResult(uuid);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/api/v3/results/skills/{uuid}"})
    @ResponseBody
    @NotNull
    public HttpEntity<?> skillsResult(@PathVariable @NotNull String uuid) {
        Task task;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Task task2 = task = (Task)this.getTaskMessageService().getOpsForHash().get((Object)"tasks", (Object)uuid);
        Object object = task2 != null ? task2.getStatus() : null;
        if ((object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) == 1) {
            List list;
            List skillDaos;
            Intrinsics.checkNotNull((Object)task, (String)"null cannot be cast to non-null type edu.wgu.osmt.task.CreateSkillsTask");
            CreateSkillsTask createSkillsTask = (CreateSkillsTask)task;
            RichSkillRepository richSkillRepository = this.getRichSkillRepository();
            List list2 = createSkillsTask.getResult();
            Intrinsics.checkNotNull((Object)list2);
            List list3 = skillDaos = richSkillRepository.findManyByUUIDs(list2);
            if (list3 != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list3;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    RichSkillDescriptorDao richSkillDescriptorDao = (RichSkillDescriptorDao)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(ApiSkill.Companion.fromDao((RichSkillDescriptorDao)it, this.getAppConfig()));
                }
                list = (List)destination$iv$iv;
            } else {
                list = null;
            }
            List apiSkills = list;
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.add("Content-Type", ((CreateSkillsTask)task).getContentType());
            ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body(apiSkills);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok().headers(responseHeaders).body(apiSkills)");
            return (HttpEntity)responseEntity;
        }
        ResponseEntity responseEntity = ResponseEntity.status((int)404).body((Object)("Task with id " + uuid + " not ready or not found"));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"status(404).body(\"Task w\u2026 not ready or not found\")");
        return (HttpEntity)responseEntity;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(path={"/api/v2/results/skills/{uuid}", "/api/results/skills/{uuid}"})
    @ResponseBody
    @NotNull
    public HttpEntity<?> skillsResultV2(@PathVariable @NotNull String uuid) {
        Task task;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Task task2 = task = (Task)this.getTaskMessageService().getOpsForHash().get((Object)"tasks", (Object)uuid);
        Object object = task2 != null ? task2.getStatus() : null;
        if ((object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) == 1) {
            List list;
            List skillDaos;
            Intrinsics.checkNotNull((Object)task, (String)"null cannot be cast to non-null type edu.wgu.osmt.task.CreateSkillsTaskV2");
            CreateSkillsTaskV2 createSkillsTaskV2 = (CreateSkillsTaskV2)task;
            RichSkillRepository richSkillRepository = this.getRichSkillRepository();
            List list2 = createSkillsTaskV2.getResult();
            Intrinsics.checkNotNull((Object)list2);
            List list3 = skillDaos = richSkillRepository.findManyByUUIDs(list2);
            if (list3 != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list3;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    RichSkillDescriptorDao richSkillDescriptorDao = (RichSkillDescriptorDao)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(ApiSkillV2.Companion.fromDao((RichSkillDescriptorDao)it, this.getAppConfig()));
                }
                list = (List)destination$iv$iv;
            } else {
                list = null;
            }
            List apiSkills = list;
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.add("Content-Type", ((CreateSkillsTaskV2)task).getContentType());
            ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body(apiSkills);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok().headers(responseHeaders).body(apiSkills)");
            return (HttpEntity)responseEntity;
        }
        ResponseEntity responseEntity = ResponseEntity.status((int)404).body((Object)("Task with id " + uuid + " not ready or not found"));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"status(404).body(\"Task w\u2026 not ready or not found\")");
        return (HttpEntity)responseEntity;
    }
}

