/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.searchhub.client.apis;

import com.fasterxml.jackson.core.type.TypeReference;
import edu.wgu.osmt.searchhub.client.apis.LibrariesApi;
import edu.wgu.osmt.searchhub.client.infrastructure.ApiClient;
import edu.wgu.osmt.searchhub.client.infrastructure.ApiResponse;
import edu.wgu.osmt.searchhub.client.infrastructure.ClientError;
import edu.wgu.osmt.searchhub.client.infrastructure.ClientException;
import edu.wgu.osmt.searchhub.client.infrastructure.Informational;
import edu.wgu.osmt.searchhub.client.infrastructure.Redirection;
import edu.wgu.osmt.searchhub.client.infrastructure.RequestConfig;
import edu.wgu.osmt.searchhub.client.infrastructure.RequestMethod;
import edu.wgu.osmt.searchhub.client.infrastructure.ResponseExtensionsKt;
import edu.wgu.osmt.searchhub.client.infrastructure.ResponseType;
import edu.wgu.osmt.searchhub.client.infrastructure.Serializer;
import edu.wgu.osmt.searchhub.client.infrastructure.ServerError;
import edu.wgu.osmt.searchhub.client.infrastructure.ServerException;
import edu.wgu.osmt.searchhub.client.infrastructure.Success;
import edu.wgu.osmt.searchhub.client.models.Library;
import edu.wgu.osmt.searchhub.client.models.LibrarySummary;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J%\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ%\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000fJ-\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00060\u00112\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\r2\u0006\u0010\u0015\u001a\u00020\u0014J\u0016\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00112\u0006\u0010\u0015\u001a\u00020\u0014\u00a8\u0006\u0019"}, d2={"Ledu/wgu/osmt/searchhub/client/apis/LibrariesApi;", "Ledu/wgu/osmt/searchhub/client/infrastructure/ApiClient;", "basePath", "", "(Ljava/lang/String;)V", "getLibraries", "", "Ledu/wgu/osmt/searchhub/client/models/LibrarySummary;", "size", "", "from", "(Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/util/List;", "getLibrariesRequestConfig", "Ledu/wgu/osmt/searchhub/client/infrastructure/RequestConfig;", "", "(Ljava/lang/Integer;Ljava/lang/Integer;)Ledu/wgu/osmt/searchhub/client/infrastructure/RequestConfig;", "getLibrariesWithHttpInfo", "Ledu/wgu/osmt/searchhub/client/infrastructure/ApiResponse;", "(Ljava/lang/Integer;Ljava/lang/Integer;)Ledu/wgu/osmt/searchhub/client/infrastructure/ApiResponse;", "registerLibraries", "Ledu/wgu/osmt/searchhub/client/models/Library;", "library", "registerLibrariesRequestConfig", "registerLibrariesWithHttpInfo", "Companion", "osmt-searchhub-client"})
public final class LibrariesApi
extends ApiClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<String> defaultBasePath$delegate = LazyKt.lazy((Function0)Companion.defaultBasePath.2.INSTANCE);

    public LibrariesApi(@NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        super(basePath);
    }

    public /* synthetic */ LibrariesApi(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = Companion.getDefaultBasePath();
        }
        this(string);
    }

    @NotNull
    public final List<LibrarySummary> getLibraries(@Nullable Integer size, @Nullable Integer from) throws IllegalStateException, IOException, UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiResponse<List<LibrarySummary>> localVarResponse = this.getLibrariesWithHttpInfo(size, from);
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type edu.wgu.osmt.searchhub.client.infrastructure.Success<*>");
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.collections.List<edu.wgu.osmt.searchhub.client.models.LibrarySummary>");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type edu.wgu.osmt.searchhub.client.infrastructure.ClientError<*>");
                ClientError localVarError = (ClientError)localVarResponse;
                int n = localVarError.getStatusCode();
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ClientException("Client error : " + n + " " + string, localVarError.getStatusCode(), localVarResponse);
            }
            case 5: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type edu.wgu.osmt.searchhub.client.infrastructure.ServerError<*>");
                ServerError localVarError = (ServerError)localVarResponse;
                int n = localVarError.getStatusCode();
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ServerException("Server error : " + n + " " + string, localVarError.getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (List)t;
    }

    @NotNull
    public final ApiResponse<List<LibrarySummary>> getLibrariesWithHttpInfo(@Nullable Integer size, @Nullable Integer from) throws IllegalStateException, IOException {
        ApiResponse apiResponse;
        String string;
        Request.Builder builder;
        Map<String, String> headers$iv;
        Unit element$iv$iv;
        RequestConfig<Unit> localVariableConfig = this.getLibrariesRequestConfig(size, from);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        HttpUrl httpUrl = HttpUrl.Companion.parse(this_$iv.getBaseUrl());
        if (httpUrl == null) {
            throw new IllegalStateException("baseUrl is invalid.");
        }
        HttpUrl httpUrl$iv = httpUrl;
        ApiClient.access$updateAuthParams(this_$iv, localVariableConfig);
        Object object = new char[]{'/'};
        Object $this$request_u24lambda_u247$iv = object = (Object)httpUrl$iv.newBuilder().addPathSegments(StringsKt.trimStart((String)localVariableConfig.getPath(), (char[])object));
        boolean $i$a$-apply-ApiClient$request$url$1$iv22 = false;
        Request.Builder $this$forEach$iv$iv = localVariableConfig.getQuery();
        boolean $i$f$forEach = false;
        Object object2 = $this$forEach$iv$iv.entrySet().iterator();
        while (object2.hasNext()) {
            Unit query$iv = element$iv$iv = object2.next();
            boolean bl6 = false;
            Iterable $this$forEach$iv$iv2 = query$iv.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv2 : $this$forEach$iv$iv2) {
                String queryValue$iv = (String)element$iv$iv2;
                boolean bl2 = false;
                $this$request_u24lambda_u247$iv.addQueryParameter(query$iv.getKey(), queryValue$iv);
            }
        }
        HttpUrl url$iv = object.build();
        object = localVariableConfig.getHeaders().get("Content-Type");
        if (object == null || object.length() == 0) {
            localVariableConfig.getHeaders().put("Content-Type", "application/json");
        }
        if ((object = (CharSequence)localVariableConfig.getHeaders().get("Accept")) == null || object.length() == 0) {
            localVariableConfig.getHeaders().put("Accept", "application/json");
        }
        if (($this$request_u24lambda_u247$iv = (Object)(headers$iv = localVariableConfig.getHeaders()).get("Content-Type")) == null || $this$request_u24lambda_u247$iv.length() == 0) {
            throw new IllegalStateException("Missing Content-Type header. This is required.");
        }
        $this$request_u24lambda_u247$iv = headers$iv.get("Accept");
        if ($this$request_u24lambda_u247$iv == null || $this$request_u24lambda_u247$iv.length() == 0) {
            throw new IllegalStateException("Missing Accept header. This is required.");
        }
        String string2 = headers$iv.get("Content-Type");
        Intrinsics.checkNotNull((Object)string2, (String)"null cannot be cast to non-null type kotlin.String");
        String $i$a$-apply-ApiClient$request$url$1$iv22 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string3 = $i$a$-apply-ApiClient$request$url$1$iv22.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        String contentType$iv = string3;
        switch (ApiClient.WhenMappings.$EnumSwitchMapping$0[localVariableConfig.getMethod().ordinal()]) {
            case 1: {
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                ApiClient this_$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                RequestBody requestBody;
                Unit content$iv$iv;
                object2 = this_$iv;
                element$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach3 = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv$iv$iv;
                        entry = element$iv$iv$iv = iterator.next();
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(stringArray);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach4 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string4 = Serializer.getJacksonObjectMapper().writeValueAsString((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"jacksonObjectMapper.writeValueAsString(content)");
                        requestBody = RequestBody.Companion.create(string4, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.delete(requestBody);
                break;
            }
            case 2: {
                builder = new Request.Builder().url(url$iv);
                break;
            }
            case 3: {
                builder = new Request.Builder().url(url$iv).head();
                break;
            }
            case 4: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach5 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach6 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string5 = Serializer.getJacksonObjectMapper().writeValueAsString((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"jacksonObjectMapper.writeValueAsString(content)");
                        requestBody = RequestBody.Companion.create(string5, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.patch(requestBody);
                break;
            }
            case 5: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach7 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach8 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string6 = Serializer.getJacksonObjectMapper().writeValueAsString((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"jacksonObjectMapper.writeValueAsString(content)");
                        requestBody = RequestBody.Companion.create(string6, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.put(requestBody);
                break;
            }
            case 6: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach9 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(stringArray);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach10 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string7 = Serializer.getJacksonObjectMapper().writeValueAsString((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"jacksonObjectMapper.writeValueAsString(content)");
                        requestBody = RequestBody.Companion.create(string7, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.post(requestBody);
                break;
            }
            case 7: {
                builder = new Request.Builder().url(url$iv).method("OPTIONS", null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Request.Builder $this$request_u24lambda_u249$iv = $this$forEach$iv$iv = builder;
        boolean bl8 = false;
        Map<String, String> $this$forEach$iv$iv3 = headers$iv;
        boolean $i$f$forEach112 = false;
        Iterator<Map.Entry<String, String>> bl6 = $this$forEach$iv$iv3.entrySet().iterator();
        while (bl6.hasNext()) {
            Map.Entry<String, String> element$iv$iv3;
            Map.Entry<String, String> header$iv = element$iv$iv3 = bl6.next();
            boolean bl7 = false;
            $this$request_u24lambda_u249$iv.addHeader(header$iv.getKey(), header$iv.getValue());
        }
        Request request$iv = $this$forEach$iv$iv.build();
        Response response$iv = ApiClient.Companion.getClient().newCall(request$iv).execute();
        String string8 = Response.header$default((Response)response$iv, (String)"Content-Type", null, (int)2, null);
        if (string8 != null && (string8 = StringsKt.substringBefore$default((String)string8, (String)";", null, (int)2, null)) != null) {
            String $i$f$forEach112 = string8;
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
            String string9 = $i$f$forEach112.toLowerCase(locale2);
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String).toLowerCase(locale)");
        } else {
            string = null;
        }
        String accept$iv = string;
        if (response$iv.isRedirect()) {
            apiResponse = new Redirection(response$iv.code(), response$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv)) {
            apiResponse = new Informational(response$iv.message(), response$iv.code(), response$iv.headers().toMultimap());
        } else if (response$iv.isSuccessful()) {
            Object object3;
            ApiClient bl8 = this_$iv;
            ResponseBody body$iv$iv = response$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv == null) {
                object3 = null;
            } else {
                String bodyContent$iv$iv = body$iv$iv.string();
                if (((CharSequence)bodyContent$iv$iv).length() == 0) {
                    object3 = null;
                } else if (Intrinsics.areEqual(List.class, File.class)) {
                    File f$iv$iv = Files.createTempFile("tmp.edu.wgu.osmt.searchhub.client", null, new FileAttribute[0]).toFile();
                    f$iv$iv.deleteOnExit();
                    BufferedWriter out$iv$iv = new BufferedWriter(new FileWriter(f$iv$iv));
                    out$iv$iv.write(bodyContent$iv$iv);
                    out$iv$iv.close();
                    object3 = (List)((Object)f$iv$iv);
                } else if (accept$iv == null || StringsKt.startsWith$default((String)accept$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)accept$iv, (String)"json", (boolean)false, (int)2, null)) {
                    object3 = Serializer.getJacksonObjectMapper().readValue(bodyContent$iv$iv, (TypeReference)new TypeReference<List<? extends LibrarySummary>>(){});
                } else {
                    throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
                }
            }
            apiResponse = new Success<Object>(object3, response$iv.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response$iv.headers().toMultimap()));
        } else if (ResponseExtensionsKt.isClientError(response$iv)) {
            ResponseBody responseBody2 = response$iv.body();
            apiResponse = new ClientError(response$iv.message(), responseBody2 != null ? responseBody2.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody3 = response$iv.body();
            apiResponse = new ServerError(response$iv.message(), responseBody3 != null ? responseBody3.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        }
        return apiResponse;
    }

    @NotNull
    public final RequestConfig<Unit> getLibrariesRequestConfig(@Nullable Integer size, @Nullable Integer from) {
        Map map;
        Object localVariableBody = null;
        Map $this$getLibrariesRequestConfig_u24lambda_u240 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        if (size != null) {
            $this$getLibrariesRequestConfig_u24lambda_u240.put("size", CollectionsKt.listOf((Object)size.toString()));
        }
        if (from != null) {
            $this$getLibrariesRequestConfig_u24lambda_u240.put("from", CollectionsKt.listOf((Object)from.toString()));
        }
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        localVariableHeaders.put("Accept", "application/json");
        RequestMethod requestMethod = RequestMethod.GET;
        return new RequestConfig<Object>(requestMethod, "/api/libraries", localVariableHeaders, localVariableQuery, localVariableBody);
    }

    @NotNull
    public final Library registerLibraries(@NotNull Library library) throws IllegalStateException, IOException, UnsupportedOperationException, ClientException, ServerException {
        Object t;
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        ApiResponse<Library> localVarResponse = this.registerLibrariesWithHttpInfo(library);
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type edu.wgu.osmt.searchhub.client.infrastructure.Success<*>");
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type edu.wgu.osmt.searchhub.client.models.Library");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type edu.wgu.osmt.searchhub.client.infrastructure.ClientError<*>");
                ClientError localVarError = (ClientError)localVarResponse;
                int n = localVarError.getStatusCode();
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ClientException("Client error : " + n + " " + string, localVarError.getStatusCode(), localVarResponse);
            }
            case 5: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type edu.wgu.osmt.searchhub.client.infrastructure.ServerError<*>");
                ServerError localVarError = (ServerError)localVarResponse;
                int n = localVarError.getStatusCode();
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ServerException("Server error : " + n + " " + string, localVarError.getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (Library)t;
    }

    @NotNull
    public final ApiResponse<Library> registerLibrariesWithHttpInfo(@NotNull Library library) throws IllegalStateException, IOException {
        ApiResponse apiResponse;
        String string;
        Request.Builder builder;
        Map<String, String> headers$iv;
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        RequestConfig<Library> localVariableConfig = this.registerLibrariesRequestConfig(library);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        HttpUrl httpUrl = HttpUrl.Companion.parse(this_$iv.getBaseUrl());
        if (httpUrl == null) {
            throw new IllegalStateException("baseUrl is invalid.");
        }
        HttpUrl httpUrl$iv = httpUrl;
        ApiClient.access$updateAuthParams(this_$iv, localVariableConfig);
        Object object = new char[]{'/'};
        Object $this$request_u24lambda_u247$iv = object = (Object)httpUrl$iv.newBuilder().addPathSegments(StringsKt.trimStart((String)localVariableConfig.getPath(), (char[])object));
        boolean $i$a$-apply-ApiClient$request$url$1$iv232 = false;
        Request.Builder $this$forEach$iv$iv = localVariableConfig.getQuery();
        boolean $i$f$forEach = false;
        Object apiClient = $this$forEach$iv$iv.entrySet().iterator();
        while (apiClient.hasNext()) {
            Map.Entry<String, List<String>> entry;
            Map.Entry<String, List<String>> query$iv = entry = apiClient.next();
            boolean bl6 = false;
            Iterable $this$forEach$iv$iv2 = query$iv.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv2 : $this$forEach$iv$iv2) {
                String queryValue$iv = (String)element$iv$iv2;
                boolean bl2 = false;
                $this$request_u24lambda_u247$iv.addQueryParameter(query$iv.getKey(), queryValue$iv);
            }
        }
        HttpUrl url$iv = object.build();
        object = localVariableConfig.getHeaders().get("Content-Type");
        if (object == null || object.length() == 0) {
            localVariableConfig.getHeaders().put("Content-Type", "application/json");
        }
        if ((object = (CharSequence)localVariableConfig.getHeaders().get("Accept")) == null || object.length() == 0) {
            localVariableConfig.getHeaders().put("Accept", "application/json");
        }
        if (($this$request_u24lambda_u247$iv = (Object)(headers$iv = localVariableConfig.getHeaders()).get("Content-Type")) == null || $this$request_u24lambda_u247$iv.length() == 0) {
            throw new IllegalStateException("Missing Content-Type header. This is required.");
        }
        $this$request_u24lambda_u247$iv = headers$iv.get("Accept");
        if ($this$request_u24lambda_u247$iv == null || $this$request_u24lambda_u247$iv.length() == 0) {
            throw new IllegalStateException("Missing Accept header. This is required.");
        }
        String string2 = headers$iv.get("Content-Type");
        Intrinsics.checkNotNull((Object)string2, (String)"null cannot be cast to non-null type kotlin.String");
        String $i$a$-apply-ApiClient$request$url$1$iv232 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string3 = $i$a$-apply-ApiClient$request$url$1$iv232.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        String contentType$iv = string3;
        switch (ApiClient.WhenMappings.$EnumSwitchMapping$0[localVariableConfig.getMethod().ordinal()]) {
            case 1: {
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                ApiClient this_$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                RequestBody requestBody;
                apiClient = this_$iv;
                Library library2 = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (library2 instanceof File) {
                    requestBody = RequestBody.Companion.create((File)((Object)library2), MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    boolean bl5 = false;
                    Intrinsics.checkNotNull((Object)library2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)library2);
                    boolean $i$f$forEach3 = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv$iv$iv;
                        entry = element$iv$iv$iv = iterator.next();
                        boolean bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(stringArray);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)library2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)library2);
                    boolean $i$f$forEach4 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        boolean bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (library2 == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string4 = Serializer.getJacksonObjectMapper().writeValueAsString((Object)library2);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"jacksonObjectMapper.writeValueAsString(content)");
                        requestBody = RequestBody.Companion.create(string4, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.delete(requestBody);
                break;
            }
            case 2: {
                builder = new Request.Builder().url(url$iv);
                break;
            }
            case 3: {
                builder = new Request.Builder().url(url$iv).head();
                break;
            }
            case 4: {
                boolean bl;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                RequestBody requestBody;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Library library3 = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (library3 instanceof File) {
                    requestBody = RequestBody.Companion.create((File)((Object)library3), MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl4 = false;
                    Intrinsics.checkNotNull((Object)library3, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)library3);
                    boolean $i$f$forEach5 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl3 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl2 = false;
                    Intrinsics.checkNotNull((Object)library3, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)library3);
                    boolean $i$f$forEach6 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (library3 == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string5 = Serializer.getJacksonObjectMapper().writeValueAsString((Object)library3);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"jacksonObjectMapper.writeValueAsString(content)");
                        requestBody = RequestBody.Companion.create(string5, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.patch(requestBody);
                break;
            }
            case 5: {
                RequestBody requestBody;
                boolean bl;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Library library4 = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (library4 instanceof File) {
                    requestBody = RequestBody.Companion.create((File)((Object)library4), MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl4 = false;
                    Intrinsics.checkNotNull((Object)library4, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)library4);
                    boolean $i$f$forEach7 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl3 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl2 = false;
                    Intrinsics.checkNotNull((Object)library4, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)library4);
                    boolean $i$f$forEach8 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (library4 == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string6 = Serializer.getJacksonObjectMapper().writeValueAsString((Object)library4);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"jacksonObjectMapper.writeValueAsString(content)");
                        requestBody = RequestBody.Companion.create(string6, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.put(requestBody);
                break;
            }
            case 6: {
                RequestBody requestBody;
                boolean bl;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Library library5 = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (library5 instanceof File) {
                    requestBody = RequestBody.Companion.create((File)((Object)library5), MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl4 = false;
                    Intrinsics.checkNotNull((Object)library5, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)library5);
                    boolean $i$f$forEach9 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl3 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(stringArray);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl2 = false;
                    Intrinsics.checkNotNull((Object)library5, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)library5);
                    boolean $i$f$forEach10 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (library5 == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string7 = Serializer.getJacksonObjectMapper().writeValueAsString((Object)library5);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"jacksonObjectMapper.writeValueAsString(content)");
                        requestBody = RequestBody.Companion.create(string7, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.post(requestBody);
                break;
            }
            case 7: {
                builder = new Request.Builder().url(url$iv).method("OPTIONS", null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Request.Builder $this$request_u24lambda_u249$iv = $this$forEach$iv$iv = builder;
        boolean bl82 = false;
        Map<String, String> map = headers$iv;
        boolean $i$f$forEach1122 = false;
        Iterator<Map.Entry<String, String>> bl6 = map.entrySet().iterator();
        while (bl6.hasNext()) {
            Map.Entry<String, String> element$iv$iv;
            Map.Entry<String, String> header$iv = element$iv$iv = bl6.next();
            boolean bl7 = false;
            $this$request_u24lambda_u249$iv.addHeader(header$iv.getKey(), header$iv.getValue());
        }
        Request request$iv = $this$forEach$iv$iv.build();
        Response response$iv = ApiClient.Companion.getClient().newCall(request$iv).execute();
        String string8 = Response.header$default((Response)response$iv, (String)"Content-Type", null, (int)2, null);
        if (string8 != null && (string8 = StringsKt.substringBefore$default((String)string8, (String)";", null, (int)2, null)) != null) {
            String $i$f$forEach1122 = string8;
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
            String string9 = $i$f$forEach1122.toLowerCase(locale2);
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String).toLowerCase(locale)");
        } else {
            string = null;
        }
        String accept$iv = string;
        if (response$iv.isRedirect()) {
            apiResponse = new Redirection(response$iv.code(), response$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv)) {
            apiResponse = new Informational(response$iv.message(), response$iv.code(), response$iv.headers().toMultimap());
        } else if (response$iv.isSuccessful()) {
            Object object2;
            ApiClient bl82 = this_$iv;
            ResponseBody responseBody2 = response$iv.body();
            boolean $i$f$responseBody = false;
            if (responseBody2 == null) {
                object2 = null;
            } else {
                String bodyContent$iv$iv = responseBody2.string();
                if (((CharSequence)bodyContent$iv$iv).length() == 0) {
                    object2 = null;
                } else if (Intrinsics.areEqual(Library.class, File.class)) {
                    File f$iv$iv = Files.createTempFile("tmp.edu.wgu.osmt.searchhub.client", null, new FileAttribute[0]).toFile();
                    f$iv$iv.deleteOnExit();
                    BufferedWriter out$iv$iv = new BufferedWriter(new FileWriter(f$iv$iv));
                    out$iv$iv.write(bodyContent$iv$iv);
                    out$iv$iv.close();
                    object2 = (Library)((Object)f$iv$iv);
                } else if (accept$iv == null || StringsKt.startsWith$default((String)accept$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)accept$iv, (String)"json", (boolean)false, (int)2, null)) {
                    object2 = Serializer.getJacksonObjectMapper().readValue(bodyContent$iv$iv, (TypeReference)new TypeReference<Library>(){});
                } else {
                    throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
                }
            }
            apiResponse = new Success<Object>(object2, response$iv.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response$iv.headers().toMultimap()));
        } else if (ResponseExtensionsKt.isClientError(response$iv)) {
            ResponseBody responseBody3 = response$iv.body();
            apiResponse = new ClientError(response$iv.message(), responseBody3 != null ? responseBody3.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody4 = response$iv.body();
            apiResponse = new ServerError(response$iv.message(), responseBody4 != null ? responseBody4.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        }
        return apiResponse;
    }

    @NotNull
    public final RequestConfig<Library> registerLibrariesRequestConfig(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Library localVariableBody = library;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        localVariableHeaders.put("Content-Type", "application/json");
        localVariableHeaders.put("Accept", "application/json");
        RequestMethod requestMethod = RequestMethod.POST;
        return new RequestConfig<Library>(requestMethod, "/api/libraries/register", localVariableHeaders, localVariableQuery, localVariableBody);
    }

    public LibrariesApi() {
        this(null, 1, null);
    }

    @NotNull
    public static final String getDefaultBasePath() {
        return Companion.getDefaultBasePath();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u00020\u00048FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Ledu/wgu/osmt/searchhub/client/apis/LibrariesApi$Companion;", "", "()V", "defaultBasePath", "", "getDefaultBasePath$annotations", "getDefaultBasePath", "()Ljava/lang/String;", "defaultBasePath$delegate", "Lkotlin/Lazy;", "osmt-searchhub-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDefaultBasePath() {
            Lazy lazy = defaultBasePath$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-defaultBasePath>(...)");
            return (String)object;
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultBasePath$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResponseType.values().length];
            try {
                nArray[ResponseType.Success.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.Informational.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.Redirection.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.ClientError.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.ServerError.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

