/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.api.io;

import at.favre.lib.bytes.Bytes;
import edu.wisc.library.ocfl.api.exception.FixityCheckException;
import edu.wisc.library.ocfl.api.exception.OcflJavaException;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.util.Enforce;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class FixityCheckChannel
implements ByteChannel {
    private boolean enabled = true;
    private final ByteChannel delegate;
    private final MessageDigest digest;
    private final String expectedDigestValue;

    public FixityCheckChannel(ByteChannel delegate, DigestAlgorithm digestAlgorithm, String expectedDigestValue) {
        this.delegate = Enforce.notNull(delegate, "delegate cannot be null");
        this.digest = Enforce.notNull(digestAlgorithm, "digestAlgorithm cannot be null").getMessageDigest();
        this.expectedDigestValue = Enforce.notBlank(expectedDigestValue, "expectedDigestValue cannot be blank");
    }

    public FixityCheckChannel(ByteChannel delegate, String digestAlgorithm, String expectedDigestValue) {
        this.delegate = Enforce.notNull(delegate, "delegate cannot be null");
        this.digest = FixityCheckChannel.messageDigest(Enforce.notBlank(digestAlgorithm, "digestAlgorithm cannot be blank"));
        this.expectedDigestValue = Enforce.notBlank(expectedDigestValue, "expectedDigestValue cannot be blank");
    }

    public void checkFixity() {
        String actualDigest;
        if (this.enabled && !this.expectedDigestValue.equalsIgnoreCase(actualDigest = Bytes.wrap((byte[])this.digest.digest()).encodeHex())) {
            throw new FixityCheckException(String.format("Expected %s digest: %s; Actual: %s", this.digest.getAlgorithm(), this.expectedDigestValue, actualDigest));
        }
    }

    public String getExpectedDigestValue() {
        return this.expectedDigestValue;
    }

    public FixityCheckChannel enableFixityCheck(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int r = this.delegate.read(dst);
        if (this.enabled && r > 0) {
            dst.flip();
            this.digest.update(dst);
        }
        return r;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (this.enabled) {
            this.digest.update(src);
            src.flip();
        }
        return this.delegate.write(src);
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    private static MessageDigest messageDigest(String digestAlgorithm) {
        try {
            return MessageDigest.getInstance(digestAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new OcflJavaException(e);
        }
    }
}

