/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core;

import edu.wisc.library.ocfl.api.OcflConstants;
import edu.wisc.library.ocfl.api.exception.CorruptObjectException;
import edu.wisc.library.ocfl.api.exception.OcflIOException;
import edu.wisc.library.ocfl.api.model.VersionNum;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.model.Inventory;
import edu.wisc.library.ocfl.core.model.RevisionNum;
import edu.wisc.library.ocfl.core.util.FileUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ObjectPaths {
    private ObjectPaths() {
    }

    public static Path objectNamastePath(Path objectRoot) {
        return objectRoot.resolve(OcflConstants.OBJECT_NAMASTE_1_0);
    }

    public static String objectNamastePath(String objectRoot) {
        return FileUtil.pathJoinFailEmpty(objectRoot, OcflConstants.OBJECT_NAMASTE_1_0);
    }

    public static Path inventoryPath(Path directory) {
        return directory.resolve("inventory.json");
    }

    public static String inventoryPath(String directory) {
        return FileUtil.pathJoinFailEmpty(directory, "inventory.json");
    }

    public static Path inventorySidecarPath(Path directory, Inventory inventory) {
        return directory.resolve("inventory.json." + inventory.getDigestAlgorithm().getOcflName());
    }

    public static String inventorySidecarPath(String directory, Inventory inventory) {
        return FileUtil.pathJoinFailEmpty(directory, "inventory.json." + inventory.getDigestAlgorithm().getOcflName());
    }

    public static Path findInventorySidecarPath(Path directory) {
        return ObjectPaths.findSidecarPathInternal(directory, "inventory.json.");
    }

    public static Path findMutableHeadRootInventorySidecarPath(Path directory) {
        return ObjectPaths.findSidecarPathInternal(directory, "root-inventory.json.");
    }

    public static Path logsPath(Path objectRoot) {
        return objectRoot.resolve("logs");
    }

    public static String logsPath(String objectRoot) {
        return FileUtil.pathJoinFailEmpty(objectRoot, "logs");
    }

    public static Path extensionsPath(Path objectRoot) {
        return objectRoot.resolve("extensions");
    }

    public static String extensionsPath(String objectRoot) {
        return FileUtil.pathJoinFailEmpty(objectRoot, "extensions");
    }

    public static Path mutableHeadInventoryPath(Path objectRootPath) {
        return ObjectPaths.inventoryPath(ObjectPaths.mutableHeadVersionPath(objectRootPath));
    }

    public static String mutableHeadInventoryPath(String objectRootPath) {
        return ObjectPaths.inventoryPath(ObjectPaths.mutableHeadVersionPath(objectRootPath));
    }

    public static String mutableHeadInventorySidecarPath(String objectRootPath, Inventory inventory) {
        return ObjectPaths.inventorySidecarPath(ObjectPaths.mutableHeadVersionPath(objectRootPath), inventory);
    }

    public static String mutableHeadVersionPath(String objectRootPath) {
        return FileUtil.pathJoinFailEmpty(objectRootPath, "extensions/0004-mutable-head/head");
    }

    public static Path mutableHeadVersionPath(Path objectRootPath) {
        return objectRootPath.resolve("extensions/0004-mutable-head/head");
    }

    public static String mutableHeadExtensionRoot(String objectRootPath) {
        return FileUtil.pathJoinFailEmpty(objectRootPath, "extensions/0004-mutable-head");
    }

    public static Path mutableHeadExtensionRoot(Path objectRootPath) {
        return objectRootPath.resolve("extensions/0004-mutable-head");
    }

    public static String mutableHeadRevisionsPath(String objectRootPath) {
        return FileUtil.pathJoinFailEmpty(objectRootPath, "extensions/0004-mutable-head/revisions");
    }

    public static Path mutableHeadRevisionsPath(Path objectRootPath) {
        return objectRootPath.resolve("extensions/0004-mutable-head/revisions");
    }

    public static ObjectRoot objectRoot(Inventory inventory, Path objectRootPath) {
        Enforce.notNull((Object)inventory, (String)"inventory cannot be null");
        Enforce.notNull((Object)objectRootPath, (String)"objectRootPath cannot be null");
        return new ObjectRoot(inventory, objectRootPath);
    }

    public static ObjectRoot objectRoot(Inventory inventory) {
        Enforce.notNull((Object)inventory, (String)"inventory cannot be null");
        return new ObjectRoot(inventory, null);
    }

    public static VersionRoot version(Inventory inventory, Path location) {
        Enforce.notNull((Object)inventory, (String)"inventory cannot be null");
        Enforce.notNull((Object)location, (String)"location cannot be null");
        return new VersionRoot(inventory, location);
    }

    private static Path findSidecarPathInternal(Path directory, String prefix) {
        Path path;
        block9: {
            Stream<Path> files = Files.list(directory);
            try {
                List sidecars = files.filter(file -> file.getFileName().toString().startsWith(prefix)).collect(Collectors.toList());
                if (sidecars.size() != 1) {
                    throw new CorruptObjectException(String.format("Expected there to be one inventory sidecar file in %s, but found %s.", directory, sidecars.size()));
                }
                path = (Path)sidecars.get(0);
                if (files == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OcflIOException(e);
                }
            }
            files.close();
        }
        return path;
    }

    public static class ContentRoot {
        private final Inventory inventory;
        private final Path path;

        private ContentRoot(Inventory inventory, Path path) {
            this.inventory = inventory;
            this.path = path == null ? Paths.get("", new String[0]) : path;
        }

        public String objectId() {
            return this.inventory.getId();
        }

        private Path path() {
            return this.path;
        }

        public Path revisionPath(RevisionNum revisionNum) {
            return this.path.resolve(revisionNum.toString());
        }

        public Path headRevisionPath() {
            if (this.inventory.getRevisionNum() == null) {
                return null;
            }
            return this.revisionPath(this.inventory.getRevisionNum());
        }
    }

    public static class VersionRoot
    implements HasInventory {
        private final Inventory inventory;
        private final Path path;
        private Path inventoryFile;
        private Path inventorySidecar;
        private Path contentPath;
        private ContentRoot contentRoot;

        private VersionRoot(Inventory inventory, Path path) {
            this.inventory = inventory;
            this.path = path == null ? Paths.get("", new String[0]) : path;
        }

        public String objectId() {
            return this.inventory.getId();
        }

        public Path path() {
            return this.path;
        }

        @Override
        public Path inventoryFile() {
            if (this.inventoryFile == null) {
                this.inventoryFile = ObjectPaths.inventoryPath(this.path);
            }
            return this.inventoryFile;
        }

        @Override
        public Path inventorySidecar() {
            if (this.inventorySidecar == null) {
                this.inventorySidecar = ObjectPaths.inventorySidecarPath(this.path, this.inventory);
            }
            return this.inventorySidecar;
        }

        public Path contentPath() {
            if (this.contentPath == null) {
                this.contentPath = this.path.resolve(this.inventory.resolveContentDirectory());
            }
            return this.contentPath;
        }

        public ContentRoot contentRoot() {
            if (this.contentRoot == null) {
                this.contentRoot = new ContentRoot(this.inventory, this.contentPath());
            }
            return this.contentRoot;
        }
    }

    public static class ObjectRoot
    implements HasInventory {
        private final Inventory inventory;
        private final Path path;
        private Path inventoryFile;
        private Path inventorySidecar;
        private Path headVersionPath;
        private Path mutableHeadExtPath;
        private Path mutableHeadPath;
        private Path mutableHeadRevisionsPath;
        private VersionRoot headVersion;
        private VersionRoot mutableHeadVersion;

        private ObjectRoot(Inventory inventory, Path path) {
            this.inventory = inventory;
            this.path = path == null ? Paths.get("", new String[0]) : path;
        }

        public Path path() {
            return this.path;
        }

        public String objectId() {
            return this.inventory.getId();
        }

        @Override
        public Path inventoryFile() {
            if (this.inventoryFile == null) {
                this.inventoryFile = ObjectPaths.inventoryPath(this.path);
            }
            return this.inventoryFile;
        }

        @Override
        public Path inventorySidecar() {
            if (this.inventorySidecar == null) {
                this.inventorySidecar = ObjectPaths.inventorySidecarPath(this.path, this.inventory);
            }
            return this.inventorySidecar;
        }

        public Path versionPath(VersionNum versionNum) {
            if (this.inventory.getHead().equals((Object)versionNum)) {
                return this.headVersionPath();
            }
            return this.path.resolve(versionNum.toString());
        }

        public Path headVersionPath() {
            if (this.headVersionPath == null) {
                this.headVersionPath = this.inventory.hasMutableHead() ? this.mutableHeadPath() : this.path.resolve(this.inventory.getHead().toString());
            }
            return this.headVersionPath;
        }

        public Path mutableHeadExtensionPath() {
            if (this.mutableHeadExtPath == null) {
                this.mutableHeadExtPath = this.path.resolve("extensions/0004-mutable-head");
            }
            return this.mutableHeadExtPath;
        }

        public Path mutableHeadPath() {
            if (this.mutableHeadPath == null) {
                this.mutableHeadPath = this.path.resolve("extensions/0004-mutable-head/head");
            }
            return this.mutableHeadPath;
        }

        public Path mutableHeadRevisionsPath() {
            if (this.mutableHeadRevisionsPath == null) {
                this.mutableHeadRevisionsPath = this.path.resolve("extensions/0004-mutable-head/revisions");
            }
            return this.mutableHeadRevisionsPath;
        }

        public VersionRoot version(VersionNum versionNum) {
            return new VersionRoot(this.inventory, this.versionPath(versionNum));
        }

        public VersionRoot headVersion() {
            if (this.headVersion == null) {
                this.headVersion = new VersionRoot(this.inventory, this.headVersionPath());
            }
            return this.headVersion;
        }

        public VersionRoot mutableHeadVersion() {
            if (this.mutableHeadVersion == null) {
                this.mutableHeadVersion = new VersionRoot(this.inventory, this.mutableHeadPath());
            }
            return this.mutableHeadVersion;
        }
    }

    public static interface HasInventory {
        public Path inventoryFile();

        public Path inventorySidecar();
    }
}

