/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.db;

import edu.wisc.library.ocfl.api.exception.OcflDbException;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.db.DbType;
import edu.wisc.library.ocfl.core.util.FileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableCreator {
    private static final Logger LOG = LoggerFactory.getLogger(TableCreator.class);
    private static final String LOCK_TABLE_FILE = "ocfl_object_lock.sql";
    private static final String OBJECT_DETAILS_TABLE_FILE = "ocfl_object_details.sql";
    private Map<DbType, String> dbScriptDir = Map.of(DbType.POSTGRES, "db/postgresql", DbType.H2, "db/h2");
    private DbType dbType;
    private DataSource dataSource;

    public TableCreator(DbType dbType, DataSource dataSource) {
        this.dbType = (DbType)((Object)Enforce.notNull((Object)((Object)dbType), (String)"dbType cannot be null"));
        this.dataSource = (DataSource)Enforce.notNull((Object)dataSource, (String)"dataSource cannot be null");
    }

    public void createObjectLockTable() {
        this.createTable(LOCK_TABLE_FILE);
    }

    public void createObjectDetailsTable() {
        this.createTable(OBJECT_DETAILS_TABLE_FILE);
    }

    private void createTable(String fileName) {
        block20: {
            try (Connection connection = this.dataSource.getConnection();){
                String filePath = this.getSqlFilePath(fileName);
                LOG.debug("Loading {}", (Object)filePath);
                if (filePath == null) break block20;
                try (InputStream stream = this.getClass().getResourceAsStream("/" + filePath);
                     PreparedStatement statement = connection.prepareStatement(this.streamToString(stream));){
                    statement.executeUpdate();
                }
            }
            catch (IOException | SQLException e) {
                throw new OcflDbException((Throwable)e);
            }
        }
    }

    private String getSqlFilePath(String fileName) {
        String scriptDir = this.dbScriptDir.get((Object)this.dbType);
        if (scriptDir == null) {
            LOG.warn("There are no scripts configured for {}", (Object)this.dbType);
            return null;
        }
        return FileUtil.pathJoinFailEmpty(scriptDir, fileName);
    }

    private String streamToString(InputStream stream) throws IOException {
        return new String(stream.readAllBytes(), StandardCharsets.UTF_8);
    }
}

