/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.extension;

import edu.wisc.library.ocfl.api.exception.OcflExtensionException;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.extension.OcflExtension;
import edu.wisc.library.ocfl.core.extension.storage.layout.FlatLayoutExtension;
import edu.wisc.library.ocfl.core.extension.storage.layout.HashedTruncatedNTupleExtension;
import edu.wisc.library.ocfl.core.extension.storage.layout.HashedTruncatedNTupleIdExtension;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OcflExtensionRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(OcflExtensionRegistry.class);
    private static final Map<String, Class<? extends OcflExtension>> REGISTRY = new HashMap<String, Class<FlatLayoutExtension>>(Map.of("0003-hashed-n-tuple-trees", HashedTruncatedNTupleExtension.class, "0005-hashed-n-tuple-id-layout", HashedTruncatedNTupleIdExtension.class, "0002-flat-direct-storage-layout", FlatLayoutExtension.class));

    private OcflExtensionRegistry() {
    }

    public static void register(String extensionId, Class<? extends OcflExtension> extensionClass) {
        Enforce.notBlank((String)extensionId, (String)"extensionId cannot be blank");
        Enforce.notNull(extensionClass, (String)"extensionClass cannot be null");
        REGISTRY.put(extensionId, extensionClass);
    }

    public static void remove(String extensionName) {
        REGISTRY.remove(extensionName);
    }

    public static <T extends OcflExtension> Optional<T> lookup(String extensionName) {
        Class<? extends OcflExtension> extensionClass = REGISTRY.get(extensionName);
        LOG.debug("Found OCFL extension {} implementation {}", (Object)extensionName, extensionClass);
        if (extensionClass == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(extensionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new OcflExtensionException(String.format("Failed to load extension %s class %s.", extensionName, extensionClass), (Throwable)e);
        }
    }
}

