/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.extension.storage.layout;

import edu.wisc.library.ocfl.api.exception.OcflExtensionException;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.extension.OcflExtensionConfig;
import edu.wisc.library.ocfl.core.extension.storage.layout.OcflStorageLayoutExtension;
import edu.wisc.library.ocfl.core.extension.storage.layout.config.HashedTruncatedNTupleConfig;
import edu.wisc.library.ocfl.core.util.DigestUtil;

public class HashedTruncatedNTupleExtension
implements OcflStorageLayoutExtension {
    public static final String EXTENSION_NAME = "0003-hashed-n-tuple-trees";
    private HashedTruncatedNTupleConfig config;

    @Override
    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    @Override
    public String getDescription() {
        return "OCFL object identifiers are hashed and encoded as hex strings. These digests are then divided into N n-tuple segments, which are used to create nested paths under the OCFL storage root.";
    }

    @Override
    public synchronized void init(OcflExtensionConfig config) {
        if (this.config == null) {
            Enforce.notNull((Object)config, (String)"configFile cannot be null");
            if (!(config instanceof HashedTruncatedNTupleConfig)) {
                throw new OcflExtensionException(String.format("This extension only supports %s configuration. Received: %s", this.getExtensionConfigClass(), config));
            }
            HashedTruncatedNTupleConfig castConfig = (HashedTruncatedNTupleConfig)config;
            HashedTruncatedNTupleExtension.validateConfig(castConfig);
            this.config = castConfig;
        }
    }

    @Override
    public Class<? extends OcflExtensionConfig> getExtensionConfigClass() {
        return HashedTruncatedNTupleConfig.class;
    }

    @Override
    public String mapObjectId(String objectId) {
        if (this.config == null) {
            throw new OcflExtensionException("This extension must be initialized before it can be used.");
        }
        String digest = DigestUtil.computeDigestHex(this.config.getDigestAlgorithm(), objectId, false);
        if (this.config.getTupleSize() == 0) {
            return digest;
        }
        return this.buildPath(digest);
    }

    private String buildPath(String digest) {
        StringBuilder pathBuilder = new StringBuilder();
        for (int i = 0; i < this.config.getNumberOfTuples(); ++i) {
            int start = i * this.config.getTupleSize();
            int end = start + this.config.getTupleSize();
            pathBuilder.append(digest, start, end).append("/");
        }
        if (this.config.isShortObjectRoot()) {
            int start = this.config.getNumberOfTuples() * this.config.getTupleSize();
            pathBuilder.append(digest, start, digest.length());
        } else {
            pathBuilder.append(digest);
        }
        return pathBuilder.toString();
    }

    private static void validateConfig(HashedTruncatedNTupleConfig config) {
        if (config != null) {
            String testDigest;
            if (!(config.getTupleSize() != 0 && config.getNumberOfTuples() != 0 || config.getTupleSize() == 0 && config.getNumberOfTuples() == 0)) {
                throw new OcflExtensionException(String.format("If tupleSize (=%s) or numberOfTuples (=%s) is set to 0, then both must be 0.", config.getTupleSize(), config.getNumberOfTuples()));
            }
            int totalTupleChars = config.getTupleSize() * config.getNumberOfTuples();
            if (totalTupleChars > (testDigest = DigestUtil.computeDigestHex(config.getDigestAlgorithm(), "test")).length()) {
                throw new OcflExtensionException(String.format("The config tupleSize=%s and numberOfTuples=%s requires a minimum of %s characters, but %s digests only have %s characters.", config.getTupleSize(), config.getNumberOfTuples(), totalTupleChars, config.getDigestAlgorithm().getOcflName(), testDigest.length()));
            }
            if (totalTupleChars == testDigest.length() && config.isShortObjectRoot()) {
                throw new OcflExtensionException(String.format("The config tupleSize=%s and numberOfTuples=%s requires a minimum of %s characters, which is equal to the number of characters in a %s digest. Therefore, shortObjectRoot cannot be set to true.", config.getTupleSize(), config.getNumberOfTuples(), totalTupleChars, config.getDigestAlgorithm().getOcflName()));
            }
        }
    }
}

