/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.extension.storage.layout.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.extension.OcflExtensionConfig;
import java.util.Objects;

public class HashedTruncatedNTupleIdConfig
implements OcflExtensionConfig {
    private DigestAlgorithm digestAlgorithm = DigestAlgorithm.sha256;
    private int tupleSize = 3;
    private int numberOfTuples = 3;

    @Override
    @JsonIgnore
    public String getExtensionName() {
        return "0005-hashed-n-tuple-id-layout";
    }

    @Override
    @JsonIgnore
    public boolean hasParameters() {
        return true;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public HashedTruncatedNTupleIdConfig setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = (DigestAlgorithm)Enforce.notNull((Object)digestAlgorithm, (String)"digestAlgorithm cannot be null");
        return this;
    }

    public int getTupleSize() {
        return this.tupleSize;
    }

    public HashedTruncatedNTupleIdConfig setTupleSize(int tupleSize) {
        this.tupleSize = (Integer)Enforce.expressionTrue((tupleSize >= 0 && tupleSize <= 32 ? 1 : 0) != 0, (Object)tupleSize, (String)"tupleSize must be between 0 and 32 inclusive");
        return this;
    }

    public int getNumberOfTuples() {
        return this.numberOfTuples;
    }

    public HashedTruncatedNTupleIdConfig setNumberOfTuples(int numberOfTuples) {
        this.numberOfTuples = (Integer)Enforce.expressionTrue((numberOfTuples >= 0 && numberOfTuples <= 32 ? 1 : 0) != 0, (Object)numberOfTuples, (String)"numberOfTuples must be between 0 and 32 inclusive");
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashedTruncatedNTupleIdConfig that = (HashedTruncatedNTupleIdConfig)o;
        return this.tupleSize == that.tupleSize && this.numberOfTuples == that.numberOfTuples && this.digestAlgorithm.equals((Object)that.digestAlgorithm);
    }

    public int hashCode() {
        return Objects.hash(this.digestAlgorithm, this.tupleSize, this.numberOfTuples);
    }

    public String toString() {
        return "HashedTruncatedNTupleConfig{digestAlgorithm=" + this.digestAlgorithm.getOcflName() + ", tupleSize=" + this.tupleSize + ", numberOfTuples=" + this.numberOfTuples + "}";
    }
}

