/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.storage.cloud;

import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.storage.OcflObjectRootDirIterator;
import edu.wisc.library.ocfl.core.storage.cloud.CloudClient;
import edu.wisc.library.ocfl.core.storage.cloud.ListResult;
import edu.wisc.library.ocfl.core.util.FileUtil;
import java.util.Iterator;

public class CloudOcflObjectRootDirIterator
extends OcflObjectRootDirIterator {
    private CloudClient cloudClient;

    public CloudOcflObjectRootDirIterator(String start, CloudClient cloudClient) {
        super(start);
        this.cloudClient = (CloudClient)Enforce.notNull((Object)cloudClient, (String)"cloudClient cannot be null");
    }

    @Override
    protected boolean isObjectRoot(String path) {
        ListResult listResult = this.cloudClient.list(FileUtil.pathJoinFailEmpty(path, "0=ocfl_object"));
        return !listResult.getObjects().isEmpty();
    }

    @Override
    protected OcflObjectRootDirIterator.Directory createDirectory(String path) {
        return new CloudDirectory(path);
    }

    private class CloudDirectory
    implements OcflObjectRootDirIterator.Directory {
        private Iterator<ListResult.DirectoryListing> childDirectories;

        CloudDirectory(String path) {
            ListResult listResult = CloudOcflObjectRootDirIterator.this.cloudClient.listDirectory(path);
            this.childDirectories = listResult.getDirectories().iterator();
        }

        @Override
        public String nextChildDirectory() {
            if (this.childDirectories.hasNext()) {
                return this.childDirectories.next().getPath();
            }
            return null;
        }

        @Override
        public void close() {
        }
    }
}

