/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.model;

import edu.wisc.library.ocfl.api.exception.OcflInputException;
import edu.wisc.library.ocfl.api.model.VersionInfo;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.model.PathBiMap;
import edu.wisc.library.ocfl.core.model.User;
import edu.wisc.library.ocfl.core.model.Version;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Set;

public class VersionBuilder {
    private OffsetDateTime created;
    private String message;
    private User user;
    private PathBiMap state;

    public VersionBuilder() {
        this.state = new PathBiMap();
    }

    public VersionBuilder(Version original) {
        Enforce.notNull((Object)original, (String)"version cannot be null");
        this.state = PathBiMap.fromFileIdMap(original.getState());
    }

    public VersionBuilder addFile(String id, String logicalPath) {
        Enforce.notBlank((String)id, (String)"id cannot be blank");
        Enforce.notBlank((String)logicalPath, (String)"logicalPath cannot be blank");
        this.state.put(id, logicalPath);
        return this;
    }

    public VersionBuilder created(OffsetDateTime created) {
        this.created = (OffsetDateTime)Enforce.notNull((Object)created, (String)"created cannot be null");
        return this;
    }

    public VersionBuilder message(String message) {
        this.message = message;
        return this;
    }

    public VersionBuilder user(User user) {
        this.user = user;
        return this;
    }

    public VersionBuilder versionInfo(VersionInfo versionInfo) {
        if (versionInfo != null) {
            this.message = versionInfo.getMessage();
            if (versionInfo.getUser().getName() != null) {
                this.user = new User(versionInfo.getUser().getName(), versionInfo.getUser().getAddress());
            }
        }
        return this;
    }

    public VersionBuilder state(Map<String, Set<String>> state) {
        this.state = PathBiMap.fromFileIdMap((Map)Enforce.notNull(state, (String)"state cannot be null"));
        return this;
    }

    public VersionBuilder state(PathBiMap state) {
        this.state = (PathBiMap)Enforce.notNull((Object)state, (String)"state cannot be null");
        return this;
    }

    public Version build() {
        return new Version(this.created, this.message, this.user, this.state.getFileIdToPaths());
    }

    public boolean containsFileId(String fileId) {
        return this.state.containsFileId(fileId);
    }

    public boolean containsLogicalPath(String logicalPath) {
        return this.state.containsPath(logicalPath);
    }

    public void validateNonConflictingPath(String logicalPath) {
        String pathAsDir = logicalPath + "/";
        this.state.getPathToFileId().keySet().forEach(existingPath -> {
            if (existingPath.startsWith(pathAsDir)) {
                throw this.conflictException(logicalPath, (String)existingPath);
            }
            String existingAsDir = existingPath + "/";
            if (logicalPath.startsWith(existingAsDir)) {
                throw this.conflictException(logicalPath, (String)existingPath);
            }
        });
    }

    public Set<String> getLogicalPaths(String fileId) {
        return this.state.getPaths(fileId);
    }

    public String getFileId(String logicalPath) {
        return this.state.getFileId(logicalPath);
    }

    public String removeLogicalPath(String logicalPath) {
        return this.state.removePath(logicalPath);
    }

    public Set<String> removeFileId(String fileId) {
        return this.state.removeFileId(fileId);
    }

    public Map<String, String> getInvertedState() {
        return this.state.getPathToFileId();
    }

    private OcflInputException conflictException(String logicalPath, String existingPath) {
        return new OcflInputException(String.format("The logical path %s conflicts with the existing path %s.", logicalPath, existingPath));
    }
}

