/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.path.constraint;

import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.path.constraint.FileNameConstraint;
import edu.wisc.library.ocfl.core.path.constraint.PathCharConstraint;
import edu.wisc.library.ocfl.core.path.constraint.PathConstraint;
import java.util.ArrayList;
import java.util.List;

public class PathConstraintProcessor {
    private final List<PathConstraint> pathConstraints;
    private final List<FileNameConstraint> fileNameConstraints;
    private final List<PathCharConstraint> charConstraints;

    public static Builder builder() {
        return new Builder();
    }

    public PathConstraintProcessor(List<PathConstraint> pathConstraints, List<FileNameConstraint> fileNameConstraints, List<PathCharConstraint> charConstraints) {
        this.pathConstraints = (List)Enforce.notNull(pathConstraints, (String)"pathConstraints cannot be null");
        this.fileNameConstraints = (List)Enforce.notNull(fileNameConstraints, (String)"fileNameConstraints cannot be null");
        this.charConstraints = (List)Enforce.notNull(charConstraints, (String)"charConstraints cannot be null");
    }

    public String apply(String path) {
        this.pathConstraints.forEach(constraint -> constraint.apply(path));
        if (!this.fileNameConstraints.isEmpty() || !this.charConstraints.isEmpty()) {
            String[] segments;
            for (String segment : segments = path.split("/")) {
                this.fileNameConstraints.forEach(constraint -> constraint.apply(segment, path));
                if (this.charConstraints.isEmpty()) continue;
                for (char c : segment.toCharArray()) {
                    this.charConstraints.forEach(constraint -> constraint.apply(c, path));
                }
            }
        }
        return path;
    }

    public PathConstraintProcessor prependPathConstraint(PathConstraint pathConstraint) {
        this.pathConstraints.add(0, (PathConstraint)Enforce.notNull((Object)pathConstraint, (String)"pathConstraint cannot be null"));
        return this;
    }

    public PathConstraintProcessor prependFileNameConstraint(FileNameConstraint fileNameConstraint) {
        this.fileNameConstraints.add(0, (FileNameConstraint)Enforce.notNull((Object)fileNameConstraint, (String)"fileNameConstraint cannot be null"));
        return this;
    }

    public PathConstraintProcessor prependCharConstraint(PathCharConstraint charConstraint) {
        this.charConstraints.add(0, (PathCharConstraint)Enforce.notNull((Object)charConstraint, (String)"charConstraint cannot be null"));
        return this;
    }

    public PathConstraintProcessor appendPathConstraint(PathConstraint pathConstraint) {
        this.pathConstraints.add((PathConstraint)Enforce.notNull((Object)pathConstraint, (String)"pathConstraint cannot be null"));
        return this;
    }

    public PathConstraintProcessor appendFileNameConstraint(FileNameConstraint fileNameConstraint) {
        this.fileNameConstraints.add((FileNameConstraint)Enforce.notNull((Object)fileNameConstraint, (String)"fileNameConstraint cannot be null"));
        return this;
    }

    public PathConstraintProcessor appendCharConstraint(PathCharConstraint charConstraint) {
        this.charConstraints.add((PathCharConstraint)Enforce.notNull((Object)charConstraint, (String)"charConstraint cannot be null"));
        return this;
    }

    public static class Builder {
        private List<PathConstraint> pathConstraints = new ArrayList<PathConstraint>();
        private List<FileNameConstraint> fileNameConstraints = new ArrayList<FileNameConstraint>();
        private List<PathCharConstraint> charConstraints = new ArrayList<PathCharConstraint>();

        public Builder pathConstraint(PathConstraint pathConstraint) {
            this.pathConstraints.add((PathConstraint)Enforce.notNull((Object)pathConstraint, (String)"pathConstraint cannot be null"));
            return this;
        }

        public Builder pathConstraints(List<PathConstraint> pathConstraints) {
            this.pathConstraints = (List)Enforce.notNull(pathConstraints, (String)"pathConstraints cannot be null");
            return this;
        }

        public Builder fileNameConstraint(FileNameConstraint fileNameConstraint) {
            this.fileNameConstraints.add((FileNameConstraint)Enforce.notNull((Object)fileNameConstraint, (String)"fileNameConstraint cannot be null"));
            return this;
        }

        public Builder fileNameConstraints(List<FileNameConstraint> fileNameConstraints) {
            this.fileNameConstraints = (List)Enforce.notNull(fileNameConstraints, (String)"fileNameConstraints cannot be null");
            return this;
        }

        public Builder charConstraint(PathCharConstraint charConstraint) {
            this.charConstraints.add((PathCharConstraint)Enforce.notNull((Object)charConstraint, (String)"charConstraint cannot be null"));
            return this;
        }

        public Builder charConstraints(List<PathCharConstraint> charConstraints) {
            this.charConstraints = (List)Enforce.notNull(charConstraints, (String)"charConstraints cannot be null");
            return this;
        }

        public PathConstraintProcessor build() {
            return new PathConstraintProcessor(this.pathConstraints, this.fileNameConstraints, this.charConstraints);
        }
    }
}

