/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.path.mapper;

import edu.wisc.library.ocfl.core.path.mapper.DirectLogicalPathMapper;
import edu.wisc.library.ocfl.core.path.mapper.LogicalPathMapper;
import edu.wisc.library.ocfl.core.path.mapper.PercentEncodingLogicalPathMapper;
import edu.wisc.library.ocfl.core.util.PercentEscaper;

public final class LogicalPathMappers {
    private static final char ASCII_CTRL_START = '\u0000';
    private static final char ASCII_CTRL_END = '\u001f';
    private static final char ASCII_CTRL_EXT_START = '\u007f';
    private static final char ASCII_CTRL_EXT_END = '\u00a0';
    private static final String ENCODE_WINDOWS = "<>:\"\\|?* ";
    private static final String ENCODE_LINUX = " ";
    private static final String ENCODE_CLOUD = "\\#[]*? ";
    private static final String ENCODE_ALL = "<>:\"\\|?* #[]";

    private LogicalPathMappers() {
    }

    public static LogicalPathMapper directMapper() {
        return new DirectLogicalPathMapper();
    }

    public static LogicalPathMapper percentEncodingWindowsMapper() {
        return new PercentEncodingLogicalPathMapper(PercentEscaper.builder().useUppercase(false).plusForSpace(false).addUnsafeCharRange('\u0000', '\u001f').addUnsafeCharRange('\u007f', '\u00a0').addUnsafeChars(ENCODE_WINDOWS).build());
    }

    public static LogicalPathMapper percentEncodingLinuxMapper() {
        return new PercentEncodingLogicalPathMapper(PercentEscaper.builder().useUppercase(false).plusForSpace(false).addUnsafeCharRange('\u0000', '\u001f').addUnsafeCharRange('\u007f', '\u00a0').addUnsafeChars(ENCODE_LINUX).build());
    }

    public static LogicalPathMapper percentEncodingCloudMapper() {
        return new PercentEncodingLogicalPathMapper(PercentEscaper.builder().useUppercase(false).plusForSpace(false).addUnsafeCharRange('\u0000', '\u001f').addUnsafeCharRange('\u007f', '\u00a0').addUnsafeChars(ENCODE_CLOUD).build());
    }

    public static LogicalPathMapper percentEncodingAllMapper() {
        return new PercentEncodingLogicalPathMapper(PercentEscaper.builder().useUppercase(false).plusForSpace(false).addUnsafeCharRange('\u0000', '\u001f').addUnsafeCharRange('\u007f', '\u00a0').addUnsafeChars(ENCODE_ALL).build());
    }

    public static LogicalPathMapper conservativePercentEncodingMapper() {
        return new PercentEncodingLogicalPathMapper(PercentEscaper.builderWithSafeAlphaNumeric().useUppercase(false).plusForSpace(false).addSafeChars("-_").build());
    }
}

