/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.storage.cloud;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.extension.ExtensionSupportEvaluator;
import edu.wisc.library.ocfl.core.extension.UnsupportedExtensionBehavior;
import edu.wisc.library.ocfl.core.storage.cloud.CloudClient;
import edu.wisc.library.ocfl.core.storage.cloud.CloudOcflStorage;
import edu.wisc.library.ocfl.core.storage.cloud.CloudOcflStorageInitializer;
import edu.wisc.library.ocfl.core.util.ObjectMappers;
import java.util.Collections;
import java.util.Set;

public class CloudOcflStorageBuilder {
    private ObjectMapper objectMapper = ObjectMappers.prettyPrintMapper();
    private CloudClient cloudClient;
    private CloudOcflStorageInitializer initializer;
    private UnsupportedExtensionBehavior unsupportedBehavior = UnsupportedExtensionBehavior.FAIL;
    private Set<String> ignoreUnsupportedExtensions = Collections.emptySet();

    public CloudOcflStorageBuilder cloudClient(CloudClient cloudClient) {
        this.cloudClient = cloudClient;
        return this;
    }

    public CloudOcflStorageBuilder unsupportedExtensionBehavior(UnsupportedExtensionBehavior unsupportedBehavior) {
        this.unsupportedBehavior = (UnsupportedExtensionBehavior)((Object)Enforce.notNull((Object)((Object)unsupportedBehavior), (String)"unsupportedExtensionBehavior cannot be null"));
        return this;
    }

    public CloudOcflStorageBuilder ignoreUnsupportedExtensions(Set<String> ignoreUnsupportedExtensions) {
        this.ignoreUnsupportedExtensions = (Set)Enforce.notNull(ignoreUnsupportedExtensions, (String)"ignoreUnsupportedExtensions cannot be null");
        return this;
    }

    public CloudOcflStorageBuilder objectMapper(ObjectMapper objectMapper) {
        this.objectMapper = (ObjectMapper)Enforce.notNull((Object)objectMapper, (String)"objectMapper cannot be null");
        return this;
    }

    public CloudOcflStorageBuilder initializer(CloudOcflStorageInitializer initializer) {
        this.initializer = initializer;
        return this;
    }

    public CloudOcflStorage build() {
        ExtensionSupportEvaluator supportEvaluator = new ExtensionSupportEvaluator(this.unsupportedBehavior, this.ignoreUnsupportedExtensions);
        CloudOcflStorageInitializer init = this.initializer;
        if (init == null) {
            init = new CloudOcflStorageInitializer(this.cloudClient, this.objectMapper, supportEvaluator);
        }
        return new CloudOcflStorage(this.cloudClient, init, supportEvaluator);
    }
}

