/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.storage.filesystem;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.extension.ExtensionSupportEvaluator;
import edu.wisc.library.ocfl.core.extension.UnsupportedExtensionBehavior;
import edu.wisc.library.ocfl.core.storage.filesystem.FileSystemOcflStorage;
import edu.wisc.library.ocfl.core.storage.filesystem.FileSystemOcflStorageInitializer;
import edu.wisc.library.ocfl.core.util.ObjectMappers;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;

public class FileSystemOcflStorageBuilder {
    private Path repositoryRoot;
    private boolean checkNewVersionFixity = false;
    private ObjectMapper objectMapper = ObjectMappers.prettyPrintMapper();
    private FileSystemOcflStorageInitializer initializer;
    private UnsupportedExtensionBehavior unsupportedBehavior = UnsupportedExtensionBehavior.FAIL;
    private Set<String> ignoreUnsupportedExtensions = Collections.emptySet();

    public FileSystemOcflStorageBuilder repositoryRoot(Path repositoryRoot) {
        this.repositoryRoot = (Path)Enforce.notNull((Object)repositoryRoot, (String)"repositoryRoot cannot be null");
        return this;
    }

    public FileSystemOcflStorageBuilder unsupportedExtensionBehavior(UnsupportedExtensionBehavior unsupportedBehavior) {
        this.unsupportedBehavior = (UnsupportedExtensionBehavior)((Object)Enforce.notNull((Object)((Object)unsupportedBehavior), (String)"unsupportedExtensionBehavior cannot be null"));
        return this;
    }

    public FileSystemOcflStorageBuilder ignoreUnsupportedExtensions(Set<String> ignoreUnsupportedExtensions) {
        this.ignoreUnsupportedExtensions = (Set)Enforce.notNull(ignoreUnsupportedExtensions, (String)"ignoreUnsupportedExtensions cannot be null");
        return this;
    }

    public FileSystemOcflStorageBuilder objectMapper(ObjectMapper objectMapper) {
        this.objectMapper = (ObjectMapper)Enforce.notNull((Object)objectMapper, (String)"objectMapper cannot be null");
        return this;
    }

    public FileSystemOcflStorageBuilder checkNewVersionFixity(boolean checkNewVersionFixity) {
        this.checkNewVersionFixity = checkNewVersionFixity;
        return this;
    }

    public FileSystemOcflStorageBuilder initializer(FileSystemOcflStorageInitializer initializer) {
        this.initializer = initializer;
        return this;
    }

    public FileSystemOcflStorage build() {
        ExtensionSupportEvaluator supportEvaluator = new ExtensionSupportEvaluator(this.unsupportedBehavior, this.ignoreUnsupportedExtensions);
        FileSystemOcflStorageInitializer init = this.initializer;
        if (init == null) {
            init = new FileSystemOcflStorageInitializer(this.objectMapper, supportEvaluator);
        }
        return new FileSystemOcflStorage(this.repositoryRoot, this.checkNewVersionFixity, init, supportEvaluator);
    }
}

