/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core;

import at.favre.lib.bytes.Bytes;
import edu.wisc.library.ocfl.api.OcflObjectUpdater;
import edu.wisc.library.ocfl.api.OcflOption;
import edu.wisc.library.ocfl.api.exception.FixityCheckException;
import edu.wisc.library.ocfl.api.exception.OcflInputException;
import edu.wisc.library.ocfl.api.io.FixityCheckInputStream;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.model.VersionNum;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.inventory.AddFileProcessor;
import edu.wisc.library.ocfl.core.inventory.InventoryUpdater;
import edu.wisc.library.ocfl.core.model.Inventory;
import edu.wisc.library.ocfl.core.util.DigestUtil;
import edu.wisc.library.ocfl.core.util.FileUtil;
import edu.wisc.library.ocfl.core.util.UncheckedFiles;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.DigestInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOcflObjectUpdater
implements OcflObjectUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOcflObjectUpdater.class);
    private Inventory inventory;
    private InventoryUpdater inventoryUpdater;
    private Path stagingDir;
    private AddFileProcessor addFileProcessor;
    private Map<String, Path> stagedFileMap;

    public DefaultOcflObjectUpdater(Inventory inventory, InventoryUpdater inventoryUpdater, Path stagingDir, AddFileProcessor addFileProcessor) {
        this.inventory = (Inventory)Enforce.notNull((Object)inventory, (String)"inventory cannot be null");
        this.inventoryUpdater = (InventoryUpdater)Enforce.notNull((Object)inventoryUpdater, (String)"inventoryUpdater cannot be null");
        this.stagingDir = (Path)Enforce.notNull((Object)stagingDir, (String)"stagingDir cannot be null");
        this.addFileProcessor = (AddFileProcessor)Enforce.notNull((Object)addFileProcessor, (String)"addFileProcessor cannot be null");
        this.stagedFileMap = new HashMap<String, Path>();
    }

    public OcflObjectUpdater addPath(Path sourcePath, OcflOption ... options) {
        return this.addPath(sourcePath, "", options);
    }

    public OcflObjectUpdater addPath(Path sourcePath, String destinationPath, OcflOption ... options) {
        Enforce.notNull((Object)sourcePath, (String)"sourcePath cannot be null");
        Enforce.notNull((Object)destinationPath, (String)"destinationPath cannot be null");
        LOG.debug("Add <{}> to object <{}> at logical path <{}>", new Object[]{sourcePath, this.inventory.getId(), destinationPath});
        Map<String, Path> newStagedFiles = this.addFileProcessor.processPath(sourcePath, destinationPath, options);
        this.stagedFileMap.putAll(newStagedFiles);
        return this;
    }

    public OcflObjectUpdater writeFile(InputStream input, String destinationPath, OcflOption ... options) {
        String digest;
        InventoryUpdater.AddFileResult result;
        Enforce.notNull((Object)input, (String)"input cannot be null");
        Enforce.notBlank((String)destinationPath, (String)"destinationPath cannot be blank");
        LOG.debug("Write stream to object <{}> at logical path <{}>", (Object)this.inventory.getId(), (Object)destinationPath);
        Path tempPath = this.stagingDir.resolve(UUID.randomUUID().toString());
        DigestInputStream digestInput = this.wrapInDigestInputStream(input);
        LOG.debug("Writing input stream to temp file: {}", (Object)tempPath);
        UncheckedFiles.copy(digestInput, tempPath, new StandardCopyOption[0]);
        if (input instanceof FixityCheckInputStream) {
            ((FixityCheckInputStream)input).checkFixity();
        }
        if (!(result = this.inventoryUpdater.addFile(digest = digestInput instanceof FixityCheckInputStream ? (String)((FixityCheckInputStream)digestInput).getActualDigestValue().get() : Bytes.wrap((byte[])digestInput.getMessageDigest().digest()).encodeHex(), destinationPath, options)).isNew()) {
            LOG.debug("Deleting file <{}> because a file with same digest <{}> is already present in the object", (Object)tempPath, (Object)digest);
            UncheckedFiles.delete(tempPath);
        } else {
            Path stagingFullPath = this.stagingFullPath(result.getPathUnderContentDir());
            LOG.debug("Moving file <{}> to <{}>", (Object)tempPath, (Object)stagingFullPath);
            FileUtil.moveFileMakeParents(tempPath, stagingFullPath, StandardCopyOption.REPLACE_EXISTING);
            this.stagedFileMap.put(destinationPath, stagingFullPath);
        }
        return this;
    }

    public OcflObjectUpdater removeFile(String path) {
        Enforce.notBlank((String)path, (String)"path cannot be blank");
        LOG.debug("Remove <{}> from object <{}>", (Object)path, (Object)this.inventory.getId());
        Set<InventoryUpdater.RemoveFileResult> results = this.inventoryUpdater.removeFile(path);
        this.removeUnneededStagedFiles(results);
        return this;
    }

    public OcflObjectUpdater renameFile(String sourcePath, String destinationPath, OcflOption ... options) {
        Enforce.notBlank((String)sourcePath, (String)"sourcePath cannot be blank");
        Enforce.notBlank((String)destinationPath, (String)"destinationPath cannot be blank");
        LOG.debug("Rename file in object <{}> from <{}> to <{}>", new Object[]{this.inventory.getId(), sourcePath, destinationPath});
        Set<InventoryUpdater.RemoveFileResult> results = this.inventoryUpdater.renameFile(sourcePath, destinationPath, options);
        this.removeUnneededStagedFiles(results);
        return this;
    }

    public OcflObjectUpdater reinstateFile(VersionNum sourceVersionNum, String sourcePath, String destinationPath, OcflOption ... options) {
        Enforce.notNull((Object)sourceVersionNum, (String)"sourceVersionNum cannot be null");
        Enforce.notBlank((String)sourcePath, (String)"sourcePath cannot be blank");
        Enforce.notBlank((String)destinationPath, (String)"destinationPath cannot be blank");
        LOG.debug("Reinstate file at <{}> in object <{}> to <{}>", new Object[]{sourcePath, sourceVersionNum, destinationPath});
        Set<InventoryUpdater.RemoveFileResult> results = this.inventoryUpdater.reinstateFile(sourceVersionNum, sourcePath, destinationPath, options);
        this.removeUnneededStagedFiles(results);
        return this;
    }

    public OcflObjectUpdater clearVersionState() {
        LOG.debug("Clear current version state in object <{}>", (Object)this.inventory.getId());
        this.inventoryUpdater.clearState();
        return this;
    }

    public OcflObjectUpdater addFileFixity(String logicalPath, DigestAlgorithm algorithm, String value) {
        Enforce.notBlank((String)logicalPath, (String)"logicalPath cannot be blank");
        Enforce.notNull((Object)algorithm, (String)"algorithm cannot be null");
        Enforce.notBlank((String)value, (String)"value cannot be null");
        LOG.debug("Add file fixity for file <{}> in object <{}>: Algorithm: {}; Value: {}", new Object[]{logicalPath, this.inventory.getId(), algorithm.getOcflName(), value});
        String digest = this.inventoryUpdater.getFixityDigest(logicalPath, algorithm);
        boolean alreadyExists = true;
        if (digest == null) {
            alreadyExists = false;
            if (!this.stagedFileMap.containsKey(logicalPath)) {
                throw new OcflInputException(String.format("%s was not newly added in this update. Fixity information can only be added on new files.", logicalPath));
            }
            if (!algorithm.hasJavaStandardName()) {
                throw new OcflInputException("The specified digest algorithm is not mapped to a Java name: " + algorithm);
            }
            Path file = this.stagedFileMap.get(logicalPath);
            LOG.debug("Computing {} hash of {}", (Object)algorithm.getJavaStandardName(), (Object)file);
            digest = DigestUtil.computeDigestHex(algorithm, file);
        }
        if (!value.equalsIgnoreCase(digest)) {
            throw new FixityCheckException(String.format("Expected %s digest of %s to be %s, but was %s.", algorithm.getJavaStandardName(), logicalPath, value, digest));
        }
        if (!alreadyExists) {
            this.inventoryUpdater.addFixity(logicalPath, algorithm, digest);
        }
        return this;
    }

    public OcflObjectUpdater clearFixityBlock() {
        LOG.info("Clear fixity block in object <{}>", (Object)this.inventory.getId());
        this.inventoryUpdater.clearFixity();
        return this;
    }

    private void removeUnneededStagedFiles(Set<InventoryUpdater.RemoveFileResult> removeFiles) {
        removeFiles.forEach(remove -> {
            Path stagingPath = this.stagingFullPath(remove.getPathUnderContentDir());
            if (Files.exists(stagingPath, new LinkOption[0])) {
                LOG.debug("Deleting {} because it was added and then removed in the same version.", (Object)stagingPath);
                UncheckedFiles.delete(stagingPath);
            }
        });
    }

    private Path stagingFullPath(String pathUnderContentDir) {
        return Paths.get(FileUtil.pathJoinFailEmpty(this.stagingDir.toString(), pathUnderContentDir), new String[0]);
    }

    private DigestInputStream wrapInDigestInputStream(InputStream input) {
        if (input instanceof DigestInputStream) {
            String digestAlgorithm = ((DigestInputStream)input).getMessageDigest().getAlgorithm();
            if (this.inventory.getDigestAlgorithm().getJavaStandardName().equalsIgnoreCase(digestAlgorithm)) {
                if (input instanceof FixityCheckInputStream) {
                    ((FixityCheckInputStream)input).enableFixityCheck(true);
                }
                return (DigestInputStream)input;
            }
        }
        return new DigestInputStream(input, this.inventory.getDigestAlgorithm().getMessageDigest());
    }
}

