/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.storage;

import edu.wisc.library.ocfl.api.util.Enforce;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class OcflObjectRootDirIterator
implements Iterator<String>,
Closeable {
    protected static final String OCFL_OBJECT_MARKER_PREFIX = "0=ocfl_object";
    private String start;
    private boolean started = false;
    private boolean closed = false;
    private ArrayDeque<Directory> dirStack;
    private String next;

    public OcflObjectRootDirIterator(String start) {
        this.start = (String)Enforce.notNull((Object)start, (String)"start cannot be null");
        this.dirStack = new ArrayDeque();
    }

    protected abstract boolean isObjectRoot(String var1);

    protected abstract Directory createDirectory(String var1);

    @Override
    public void close() {
        if (!this.closed) {
            while (!this.dirStack.isEmpty()) {
                this.popDirectory();
            }
            this.closed = true;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            throw new IllegalStateException("Iterator is closed.");
        }
        this.fetchNextIfNeeded();
        return this.next != null;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more files found.");
        }
        String result = this.next;
        this.next = null;
        return result;
    }

    private void fetchNextIfNeeded() {
        if (this.next == null) {
            String nextDirectory = this.fetchNextDirectory();
            while (nextDirectory != null) {
                if (this.isObjectRoot(nextDirectory)) {
                    this.popDirectory();
                    this.next = nextDirectory;
                    return;
                }
                nextDirectory = this.fetchNextDirectory();
            }
        }
    }

    private String fetchNextDirectory() {
        if (!this.started) {
            this.dirStack.push(this.createDirectory(this.start));
            this.started = true;
        }
        Directory top = this.dirStack.peek();
        while (top != null) {
            String child = top.nextChildDirectory();
            if (child == null) {
                this.popDirectory();
                top = this.dirStack.peek();
                continue;
            }
            this.dirStack.push(this.createDirectory(child));
            return child;
        }
        return null;
    }

    private void popDirectory() {
        if (!this.dirStack.isEmpty()) {
            try {
                this.dirStack.pop().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected static interface Directory
    extends Closeable {
        public String nextChildDirectory();
    }
}

