/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.lock;

import edu.wisc.library.ocfl.api.exception.OcflJavaException;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.db.DbType;
import edu.wisc.library.ocfl.core.db.TableCreator;
import edu.wisc.library.ocfl.core.lock.H2ObjectLock;
import edu.wisc.library.ocfl.core.lock.InMemoryObjectLock;
import edu.wisc.library.ocfl.core.lock.ObjectLock;
import edu.wisc.library.ocfl.core.lock.PostgresObjectLock;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;

public class ObjectLockBuilder {
    private static final String DEFAULT_TABLE_NAME = "ocfl_object_lock";
    private long waitTime = 10L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private DataSource dataSource;
    private String tableName;

    public ObjectLockBuilder waitTime(long waitTime, TimeUnit timeUnit) {
        this.waitTime = (Long)Enforce.expressionTrue((waitTime > 0L ? 1 : 0) != 0, (Object)waitTime, (String)"waitTime must be greater than 0");
        this.timeUnit = (TimeUnit)((Object)Enforce.notNull((Object)((Object)timeUnit), (String)"timeUnit cannot be null"));
        return this;
    }

    public ObjectLockBuilder dataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public ObjectLockBuilder tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public ObjectLock build() {
        if (this.dataSource == null) {
            return this.buildMemLock();
        }
        return this.buildDbLock();
    }

    private ObjectLock buildDbLock() {
        ObjectLock lock;
        Enforce.notNull((Object)this.dataSource, (String)"dataSource cannot be null");
        String resolvedTableName = this.tableName == null ? DEFAULT_TABLE_NAME : this.tableName;
        DbType dbType = DbType.fromDataSource(this.dataSource);
        switch (dbType) {
            case POSTGRES: {
                lock = new PostgresObjectLock(resolvedTableName, this.dataSource, this.waitTime, this.timeUnit);
                break;
            }
            case H2: {
                lock = new H2ObjectLock(resolvedTableName, this.dataSource, this.waitTime, this.timeUnit);
                break;
            }
            default: {
                throw new OcflJavaException(String.format("Database type %s is not mapped to an ObjectLock implementation.", new Object[]{dbType}));
            }
        }
        new TableCreator(dbType, this.dataSource).createObjectLockTable(resolvedTableName);
        return lock;
    }

    private ObjectLock buildMemLock() {
        return new InMemoryObjectLock(this.waitTime, this.timeUnit);
    }
}

