/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.path.constraint;

import edu.wisc.library.ocfl.core.path.constraint.BackslashPathSeparatorConstraint;
import edu.wisc.library.ocfl.core.path.constraint.BeginEndPathConstraint;
import edu.wisc.library.ocfl.core.path.constraint.FileNameConstraint;
import edu.wisc.library.ocfl.core.path.constraint.NonEmptyFileNameConstraint;
import edu.wisc.library.ocfl.core.path.constraint.PathConstraint;
import edu.wisc.library.ocfl.core.path.constraint.PathConstraintProcessor;
import edu.wisc.library.ocfl.core.path.constraint.RegexPathConstraint;
import java.util.regex.Pattern;

public final class LogicalPathConstraints {
    private static final PathConstraint LEADING_SLASH_CONSTRAINT = BeginEndPathConstraint.mustNotBeginWith("/");
    private static final PathConstraint TRAILING_SLASH_CONSTRAINT = BeginEndPathConstraint.mustNotEndWith("/");
    private static final FileNameConstraint NOT_EMPTY_CONSTRAINT = new NonEmptyFileNameConstraint();
    private static final FileNameConstraint NO_DOTS_CONSTRAINT = RegexPathConstraint.mustNotContain(Pattern.compile("^\\.{1,2}$"));
    private static final PathConstraintProcessor CONSTRAINTS_WITHOUT_BACKSLASH_CHECK = PathConstraintProcessor.builder().pathConstraint(LEADING_SLASH_CONSTRAINT).pathConstraint(TRAILING_SLASH_CONSTRAINT).fileNameConstraint(NOT_EMPTY_CONSTRAINT).fileNameConstraint(NO_DOTS_CONSTRAINT).build();
    private static final PathConstraintProcessor CONSTRAINTS_WITH_BACKSLASH_CHECK = PathConstraintProcessor.builder().pathConstraint(LEADING_SLASH_CONSTRAINT).pathConstraint(TRAILING_SLASH_CONSTRAINT).fileNameConstraint(NOT_EMPTY_CONSTRAINT).fileNameConstraint(NO_DOTS_CONSTRAINT).charConstraint(new BackslashPathSeparatorConstraint()).build();

    private LogicalPathConstraints() {
    }

    public static PathConstraintProcessor constraints() {
        return CONSTRAINTS_WITHOUT_BACKSLASH_CHECK;
    }

    public static PathConstraintProcessor constraintsWithBackslashCheck() {
        return CONSTRAINTS_WITH_BACKSLASH_CHECK;
    }
}

