/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.storage;

import edu.wisc.library.ocfl.api.OcflFileRetriever;
import edu.wisc.library.ocfl.api.model.ObjectVersionId;
import edu.wisc.library.ocfl.api.model.OcflVersion;
import edu.wisc.library.ocfl.api.model.VersionNum;
import edu.wisc.library.ocfl.core.extension.ExtensionSupportEvaluator;
import edu.wisc.library.ocfl.core.extension.OcflExtensionConfig;
import edu.wisc.library.ocfl.core.inventory.InventoryMapper;
import edu.wisc.library.ocfl.core.model.Inventory;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Stream;

public interface OcflStorage {
    public void initializeStorage(OcflVersion var1, OcflExtensionConfig var2, InventoryMapper var3, ExtensionSupportEvaluator var4);

    public Inventory loadInventory(String var1);

    public byte[] getInventoryBytes(String var1, VersionNum var2);

    public void storeNewVersion(Inventory var1, Path var2);

    public Map<String, OcflFileRetriever> getObjectStreams(Inventory var1, VersionNum var2);

    public void reconstructObjectVersion(Inventory var1, VersionNum var2, Path var3);

    public void purgeObject(String var1);

    public void commitMutableHead(Inventory var1, Inventory var2, Path var3);

    public void purgeMutableHead(String var1);

    public void rollbackToVersion(Inventory var1, VersionNum var2);

    public boolean containsObject(String var1);

    public String objectRootPath(String var1);

    public Stream<String> listObjectIds();

    public void exportVersion(ObjectVersionId var1, Path var2);

    public void exportObject(String var1, Path var2);

    public void importObject(String var1, Path var2);

    public void close();

    public void invalidateCache(String var1);

    public void invalidateCache();
}

