/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.lock;

import edu.wisc.library.ocfl.api.exception.LockException;
import edu.wisc.library.ocfl.api.exception.OcflDbException;
import edu.wisc.library.ocfl.api.exception.OcflJavaException;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.lock.ObjectLock;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresObjectLock
implements ObjectLock {
    private static final Logger LOG = LoggerFactory.getLogger(PostgresObjectLock.class);
    private static final String OBJECT_LOCK_FAIL = "55P03";
    private final String tableName;
    private final DataSource dataSource;
    private final long waitMillis;
    private final String createRowLockQuery;
    private final String acquireLockQuery;

    public PostgresObjectLock(String tableName, DataSource dataSource, long waitTime, TimeUnit timeUnit) {
        this.tableName = Enforce.notBlank((String)tableName, (String)"tableName cannot be blank");
        this.dataSource = (DataSource)Enforce.notNull((Object)dataSource, (String)"dataSource cannot be null");
        Enforce.expressionTrue((waitTime > -1L ? 1 : 0) != 0, (Object)waitTime, (String)"waitTime cannot be negative");
        Enforce.notNull((Object)((Object)timeUnit), (String)"timeUnit cannot be null");
        this.waitMillis = timeUnit.toMillis(waitTime);
        this.createRowLockQuery = String.format("INSERT INTO %s (object_id) VALUES (?) ON CONFLICT (object_id) DO NOTHING", tableName);
        this.acquireLockQuery = String.format("SELECT object_id FROM %s WHERE object_id = ? FOR UPDATE", tableName);
    }

    @Override
    public void doInWriteLock(String objectId, Runnable doInLock) {
        this.doInWriteLock(objectId, () -> {
            doInLock.run();
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T doInWriteLock(String objectId, Callable<T> doInLock) {
        try (Connection connection = this.dataSource.getConnection();){
            this.createLockRow(objectId, connection);
            connection.setAutoCommit(false);
            this.setLockWaitTimeout(connection);
            try (PreparedStatement statement = this.acquireLock(connection);){
                statement.setString(1, objectId);
                try {
                    block30: {
                        T t;
                        try (ResultSet resultSet = statement.executeQuery();){
                            if (!resultSet.next()) break block30;
                            t = doInLock.call();
                            if (resultSet == null) return t;
                        }
                        return t;
                    }
                    throw this.failedToAcquireLock(objectId);
                }
                catch (SQLException e) {
                    if (!OBJECT_LOCK_FAIL.equals(e.getSQLState())) throw e;
                    throw this.failedToAcquireLock(objectId);
                }
            }
            finally {
                this.safeCleanup(connection);
            }
        }
        catch (SQLException e) {
            throw new OcflDbException((Throwable)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OcflJavaException((Throwable)e);
        }
    }

    private void createLockRow(String objectId, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(this.createRowLockQuery);){
            statement.setString(1, objectId);
            statement.executeUpdate();
        }
    }

    private void setLockWaitTimeout(Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(String.format("SET LOCAL lock_timeout = %s", this.waitMillis));){
            statement.executeUpdate();
        }
    }

    private LockException failedToAcquireLock(String objectId) {
        return new LockException("Failed to acquire lock for object " + objectId);
    }

    private PreparedStatement acquireLock(Connection connection) throws SQLException {
        return connection.prepareStatement(this.acquireLockQuery);
    }

    private void safeCleanup(Connection connection) {
        try {
            connection.commit();
        }
        catch (Exception e) {
            LOG.warn("Failed to commit", (Throwable)e);
        }
        try {
            connection.setAutoCommit(true);
        }
        catch (Exception e) {
            LOG.warn("Failed to enable autocommit", (Throwable)e);
        }
    }
}

