/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.storage.cloud;

import edu.wisc.library.ocfl.api.OcflFileRetriever;
import edu.wisc.library.ocfl.api.exception.CorruptObjectException;
import edu.wisc.library.ocfl.api.exception.FixityCheckException;
import edu.wisc.library.ocfl.api.exception.NotFoundException;
import edu.wisc.library.ocfl.api.exception.ObjectOutOfSyncException;
import edu.wisc.library.ocfl.api.exception.OcflIOException;
import edu.wisc.library.ocfl.api.exception.OcflStateException;
import edu.wisc.library.ocfl.api.io.FixityCheckInputStream;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.model.ObjectVersionId;
import edu.wisc.library.ocfl.api.model.ValidationResults;
import edu.wisc.library.ocfl.api.model.VersionNum;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.ObjectPaths;
import edu.wisc.library.ocfl.core.extension.OcflExtensionConfig;
import edu.wisc.library.ocfl.core.extension.storage.layout.OcflStorageLayoutExtension;
import edu.wisc.library.ocfl.core.inventory.SidecarMapper;
import edu.wisc.library.ocfl.core.model.Inventory;
import edu.wisc.library.ocfl.core.model.RevisionNum;
import edu.wisc.library.ocfl.core.model.Version;
import edu.wisc.library.ocfl.core.path.constraint.LogicalPathConstraints;
import edu.wisc.library.ocfl.core.path.constraint.PathConstraintProcessor;
import edu.wisc.library.ocfl.core.storage.AbstractOcflStorage;
import edu.wisc.library.ocfl.core.storage.cloud.CloudClient;
import edu.wisc.library.ocfl.core.storage.cloud.CloudOcflFileRetriever;
import edu.wisc.library.ocfl.core.storage.cloud.CloudOcflObjectRootDirIterator;
import edu.wisc.library.ocfl.core.storage.cloud.CloudOcflStorageBuilder;
import edu.wisc.library.ocfl.core.storage.cloud.CloudOcflStorageInitializer;
import edu.wisc.library.ocfl.core.storage.cloud.KeyNotFoundException;
import edu.wisc.library.ocfl.core.storage.cloud.ListResult;
import edu.wisc.library.ocfl.core.util.FileUtil;
import edu.wisc.library.ocfl.core.util.NamasteTypeFile;
import edu.wisc.library.ocfl.core.util.UncheckedFiles;
import edu.wisc.library.ocfl.core.validation.Validator;
import edu.wisc.library.ocfl.core.validation.storage.CloudStorage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudOcflStorage
extends AbstractOcflStorage {
    private static final Logger LOG = LoggerFactory.getLogger(CloudOcflStorage.class);
    private static final String MEDIA_TYPE_TEXT = "text/plain; charset=UTF-8";
    private static final String MEDIA_TYPE_JSON = "application/json; charset=UTF-8";
    private final PathConstraintProcessor logicalPathConstraints;
    private final CloudClient cloudClient;
    private final CloudOcflStorageInitializer initializer;
    private OcflStorageLayoutExtension storageLayoutExtension;
    private final CloudOcflFileRetriever.Builder fileRetrieverBuilder;
    private final Validator validator;

    public static CloudOcflStorageBuilder builder() {
        return new CloudOcflStorageBuilder();
    }

    public CloudOcflStorage(CloudClient cloudClient, CloudOcflStorageInitializer initializer) {
        this.cloudClient = (CloudClient)Enforce.notNull((Object)cloudClient, (String)"cloudClient cannot be null");
        this.initializer = (CloudOcflStorageInitializer)Enforce.notNull((Object)initializer, (String)"initializer cannot be null");
        this.logicalPathConstraints = LogicalPathConstraints.constraintsWithBackslashCheck();
        this.fileRetrieverBuilder = CloudOcflFileRetriever.builder().cloudClient(this.cloudClient);
        this.validator = new Validator(new CloudStorage(cloudClient));
    }

    @Override
    public Inventory loadInventory(String objectId) {
        this.ensureOpen();
        LOG.debug("Load inventory for object <{}>", (Object)objectId);
        Inventory inventory = null;
        if (this.containsObject(objectId)) {
            String objectRootPath = this.objectRootPath(objectId);
            this.loadObjectExtensions(objectRootPath);
            if (this.hasMutableHead(objectRootPath)) {
                inventory = this.downloadAndVerifyMutableInventory(objectId, objectRootPath);
                this.ensureRootObjectHasNotChanged(inventory);
            } else {
                inventory = this.downloadAndVerifyInventory(objectId, objectRootPath);
            }
            if (inventory != null && !Objects.equals(objectId, inventory.getId())) {
                throw new CorruptObjectException(String.format("Expected object at %s to have id %s. Found: %s", objectRootPath, objectId, inventory.getId()));
            }
        }
        return inventory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getInventoryBytes(String objectId, VersionNum versionNum) {
        this.ensureOpen();
        Enforce.notBlank((String)objectId, (String)"objectId cannot be blank");
        Enforce.notNull((Object)versionNum, (String)"versionNum cannot be null");
        LOG.debug("Loading inventory bytes for object {} version {}", (Object)objectId, (Object)versionNum);
        String objectRootPath = this.objectRootPath(objectId);
        String versionPath = FileUtil.pathJoinFailEmpty(objectRootPath, versionNum.toString());
        String inventoryPath = ObjectPaths.inventoryPath(versionPath);
        try (InputStream stream = this.cloudClient.downloadStream(inventoryPath);){
            byte[] byArray = stream.readAllBytes();
            return byArray;
        }
        catch (KeyNotFoundException e) {
            String mutableHeadInventoryPath = ObjectPaths.mutableHeadInventoryPath(objectRootPath);
            try (InputStream mutableStream2222 = this.cloudClient.downloadStream(mutableHeadInventoryPath);){
                byte[] bytes = mutableStream2222.readAllBytes();
                Inventory inv = this.inventoryMapper.readMutableHead("root", "bogus", RevisionNum.R1, new ByteArrayInputStream(bytes));
                if (!versionNum.equals((Object)inv.getHead())) throw new NotFoundException(String.format("No inventory could be found for object %s version %s", objectId, versionNum));
                byte[] byArray2 = bytes;
                return byArray2;
            }
            catch (KeyNotFoundException mutableStream2222) {
                throw new NotFoundException(String.format("No inventory could be found for object %s version %s", objectId, versionNum));
            }
            catch (IOException e2) {
                throw new OcflIOException(e2);
            }
        }
        catch (IOException e) {
            throw new OcflIOException(e);
        }
    }

    @Override
    public Stream<String> listObjectIds() {
        LOG.debug("List object ids");
        return this.findOcflObjectRootDirs().map(objectRoot -> {
            Inventory inventory = this.downloadInventory((String)objectRoot);
            return inventory.getId();
        });
    }

    @Override
    public void storeNewVersion(Inventory inventory, Path stagingDir) {
        this.ensureOpen();
        LOG.debug("Store new version of object <{}> version <{}> revision <{}> from staging directory <{}>", new Object[]{inventory.getId(), inventory.getHead(), inventory.getRevisionNum(), stagingDir});
        if (inventory.hasMutableHead()) {
            this.storeNewMutableHeadVersion(inventory, stagingDir);
        } else {
            this.storeNewImmutableVersion(inventory, stagingDir);
        }
    }

    @Override
    public Map<String, OcflFileRetriever> getObjectStreams(Inventory inventory, VersionNum versionNum) {
        this.ensureOpen();
        LOG.debug("Get file streams for object <{}> version <{}>", (Object)inventory.getId(), (Object)versionNum);
        Version version = inventory.ensureVersion(versionNum);
        DigestAlgorithm algorithm = inventory.getDigestAlgorithm();
        HashMap<String, OcflFileRetriever> map = new HashMap<String, OcflFileRetriever>(version.getState().size());
        version.getState().forEach((digest, paths) -> {
            String srcPath = inventory.storagePath((String)digest);
            paths.forEach(path -> map.put((String)path, this.fileRetrieverBuilder.build(srcPath, algorithm, (String)digest)));
        });
        return map;
    }

    @Override
    public void reconstructObjectVersion(Inventory inventory, VersionNum versionNum, Path stagingDir) {
        this.ensureOpen();
        LOG.debug("Reconstruct object <{}> version <{}> in directory <{}>", new Object[]{inventory.getId(), versionNum, stagingDir});
        Version version = inventory.ensureVersion(versionNum);
        DigestAlgorithm digestAlgorithm = inventory.getDigestAlgorithm();
        version.getState().forEach((id, files) -> {
            String srcPath = inventory.storagePath((String)id);
            for (String logicalPath : files) {
                this.logicalPathConstraints.apply(logicalPath);
                Path destination = Paths.get(FileUtil.pathJoinFailEmpty(stagingDir.toString(), logicalPath), new String[0]);
                UncheckedFiles.createDirectories(destination.getParent());
                try (FixityCheckInputStream stream = new FixityCheckInputStream(this.cloudClient.downloadStream(srcPath), digestAlgorithm, id);){
                    Files.copy((InputStream)stream, destination, new CopyOption[0]);
                    stream.checkFixity();
                }
                catch (FixityCheckException e) {
                    throw new FixityCheckException(String.format("File %s in object %s failed its fixity check.", logicalPath, inventory.getId()), (Throwable)e);
                }
                catch (IOException e) {
                    throw new OcflIOException(e);
                }
            }
        });
    }

    @Override
    public void purgeObject(String objectId) {
        this.ensureOpen();
        LOG.info("Purge object <{}>", (Object)objectId);
        this.cloudClient.deletePath(this.objectRootPath(objectId));
    }

    @Override
    public void rollbackToVersion(Inventory inventory, VersionNum versionNum) {
        this.ensureOpen();
        LOG.info("Rollback object <{}> to version {}", (Object)inventory.getId(), (Object)versionNum);
        String versionPath = this.objectVersionPath(inventory, versionNum);
        try {
            this.copyInventoryToRoot(versionPath, inventory);
        }
        catch (Exception e) {
            try {
                String previousVersionPath = this.objectVersionPath(inventory, inventory.getHead());
                this.copyInventoryToRoot(previousVersionPath, inventory);
            }
            catch (RuntimeException e1) {
                LOG.error("Failed to rollback inventory at {}. Object must be fixed manually.", (Object)ObjectPaths.inventoryPath(inventory.getObjectRootPath()), (Object)e1);
            }
        }
        try {
            VersionNum currentVersion = inventory.getHead();
            while (currentVersion.compareTo(versionNum) > 0) {
                LOG.info("Purging object {} version {}", (Object)inventory.getId(), (Object)currentVersion);
                this.cloudClient.deletePath(this.objectVersionPath(inventory, currentVersion));
                currentVersion = currentVersion.previousVersionNum();
            }
            this.purgeMutableHead(inventory.getId());
        }
        catch (Exception e) {
            throw new CorruptObjectException(String.format("Object %s was corrupted while attempting to rollback to version %s. It must be manually remediated.", inventory.getId(), versionNum), (Throwable)e);
        }
    }

    @Override
    public void commitMutableHead(Inventory oldInventory, Inventory newInventory, Path stagingDir) {
        this.ensureOpen();
        LOG.debug("Commit mutable HEAD on object <{}>", (Object)newInventory.getId());
        this.ensureRootObjectHasNotChanged(newInventory);
        if (this.cloudClient.listDirectory(ObjectPaths.mutableHeadVersionPath(newInventory.getObjectRootPath())).getObjects().isEmpty()) {
            throw new ObjectOutOfSyncException(String.format("Cannot commit mutable HEAD of object %s because a mutable HEAD does not exist.", newInventory.getId()));
        }
        String versionPath = this.objectVersionPath(newInventory, newInventory.getHead());
        this.ensureVersionDoesNotExist(newInventory, versionPath);
        List<String> objectKeys = this.copyMutableVersionToImmutableVersion(oldInventory, newInventory);
        try {
            this.storeInventoryInCloudWithRollback(newInventory, stagingDir, versionPath);
            try {
                this.purgeMutableHead(newInventory.getId());
            }
            catch (RuntimeException e) {
                LOG.error("Failed to cleanup mutable HEAD of object {} at {}. It must be deleted manually.", new Object[]{newInventory.getId(), ObjectPaths.mutableHeadExtensionRoot(newInventory.getObjectRootPath()), e});
            }
        }
        catch (RuntimeException e) {
            this.cloudClient.safeDeleteObjects(objectKeys);
            throw e;
        }
    }

    @Override
    public void purgeMutableHead(String objectId) {
        this.ensureOpen();
        LOG.info("Purge mutable HEAD on object <{}>", (Object)objectId);
        this.cloudClient.deletePath(ObjectPaths.mutableHeadExtensionRoot(this.objectRootPath(objectId)));
    }

    @Override
    public boolean containsObject(String objectId) {
        this.ensureOpen();
        boolean exists = false;
        try {
            this.cloudClient.head(ObjectPaths.objectNamastePath(this.objectRootPath(objectId)));
            exists = true;
        }
        catch (KeyNotFoundException keyNotFoundException) {
            // empty catch block
        }
        LOG.debug("OCFL repository contains object <{}>: {}", (Object)objectId, (Object)exists);
        return exists;
    }

    @Override
    public String objectRootPath(String objectId) {
        this.ensureOpen();
        String objectRootPath = this.storageLayoutExtension.mapObjectId(objectId);
        LOG.debug("Object root path for object <{}>: {}", (Object)objectId, (Object)objectRootPath);
        return objectRootPath;
    }

    @Override
    public void exportVersion(ObjectVersionId objectVersionId, Path outputPath) {
        this.ensureOpen();
        Enforce.notNull((Object)objectVersionId.getVersionNum(), (String)"versionNum cannot be null");
        String versionRootPath = FileUtil.pathJoinFailEmpty(this.objectRootPath(objectVersionId.getObjectId()), objectVersionId.getVersionNum().toString()) + "/";
        List<ListResult.ObjectListing> objects = this.cloudClient.list(versionRootPath).getObjects();
        if (objects.isEmpty()) {
            throw new NotFoundException(String.format("Object %s version %s was not found.", objectVersionId.getObjectId(), objectVersionId.getVersionNum()));
        }
        LOG.debug("Copying <{}> to <{}>", (Object)versionRootPath, (Object)outputPath);
        this.copyObjects(objects, outputPath);
    }

    @Override
    public void exportObject(String objectId, Path outputPath) {
        this.ensureOpen();
        String objectRootPath = this.objectRootPath(objectId) + "/";
        List<ListResult.ObjectListing> objects = this.cloudClient.list(objectRootPath).getObjects();
        if (objects.isEmpty()) {
            throw new NotFoundException(String.format("Object %s was not found.", objectId));
        }
        LOG.debug("Copying <{}> to <{}>", (Object)objectRootPath, (Object)outputPath);
        this.copyObjects(objects, outputPath);
    }

    @Override
    public void importObject(String objectId, Path objectPath) {
        String objectRootPath = this.objectRootPath(objectId);
        if (!this.cloudClient.listDirectory(objectRootPath).getObjects().isEmpty()) {
            throw new ObjectOutOfSyncException(String.format("Cannot import object %s because the object already exists.", objectId));
        }
        LOG.debug("Importing <{}> to <{}>", (Object)objectId, (Object)objectRootPath);
        this.storeFilesInCloud(objectPath, objectRootPath);
    }

    @Override
    public ValidationResults validateObject(String objectId, boolean contentFixityCheck) {
        this.ensureOpen();
        if (!this.containsObject(objectId)) {
            throw new NotFoundException(String.format("Object %s was not found.", objectId));
        }
        String objectRoot = this.objectRootPath(objectId);
        LOG.debug("Validating object <{}> at <{}>", (Object)objectId, (Object)objectRoot);
        return this.validator.validateObject(objectRoot, contentFixityCheck);
    }

    @Override
    protected void doInitialize(OcflExtensionConfig layoutConfig) {
        this.storageLayoutExtension = this.initializer.initializeStorage(this.ocflVersion, layoutConfig, this.supportEvaluator);
    }

    @Override
    public void close() {
        LOG.debug("Closing " + this.getClass().getName());
    }

    private void storeNewImmutableVersion(Inventory inventory, Path stagingDir) {
        String objectRootPath = inventory.getObjectRootPath();
        this.ensureNoMutableHead(inventory.getId(), objectRootPath);
        String versionPath = this.objectVersionPath(inventory, inventory.getHead());
        this.ensureVersionDoesNotExist(inventory, versionPath);
        String namasteFile = null;
        try {
            if (this.isFirstVersion(inventory)) {
                namasteFile = this.writeObjectNamasteFile(objectRootPath);
            }
            List<String> objectKeys = this.storeContentInCloud(inventory, stagingDir);
            try {
                this.verifyPriorInventory(inventory, ObjectPaths.inventorySidecarPath(objectRootPath, inventory));
                this.storeInventoryInCloudWithRollback(inventory, stagingDir, versionPath);
            }
            catch (RuntimeException e) {
                this.cloudClient.safeDeleteObjects(objectKeys);
                throw e;
            }
        }
        catch (RuntimeException e) {
            if (namasteFile != null) {
                this.cloudClient.safeDeleteObjects(namasteFile);
            }
            throw e;
        }
    }

    private void storeNewMutableHeadVersion(Inventory inventory, Path stagingDir) {
        this.ensureRevisionDoesNotExist(inventory);
        ArrayList<String> cleanupKeys = new ArrayList<String>(2);
        boolean isNewMutableHead = false;
        if (!this.cloudClient.listDirectory(ObjectPaths.mutableHeadExtensionRoot(inventory.getObjectRootPath())).getObjects().isEmpty()) {
            this.ensureRootObjectHasNotChanged(inventory);
        } else {
            cleanupKeys.add(this.copyRootInventorySidecarToMutableHead(inventory));
            isNewMutableHead = true;
        }
        try {
            cleanupKeys.add(this.createRevisionMarker(inventory));
            List<String> objectKeys = this.storeContentInCloud(inventory, stagingDir);
            try {
                this.verifyPriorInventoryMutable(inventory, isNewMutableHead);
                this.storeMutableHeadInventoryInCloud(inventory, stagingDir);
            }
            catch (RuntimeException e) {
                this.cloudClient.safeDeleteObjects(objectKeys);
                throw e;
            }
        }
        catch (RuntimeException e) {
            this.cloudClient.safeDeleteObjects(cleanupKeys);
            throw e;
        }
        this.deleteMutableHeadFilesNotInManifest(inventory);
    }

    private List<String> storeContentInCloud(Inventory inventory, Path sourcePath) {
        String contentPrefix = this.contentPrefix(inventory);
        Set<String> fileIds = inventory.getFileIdsForMatchingFiles(contentPrefix);
        List<String> objectKeys = Collections.synchronizedList(new ArrayList());
        try {
            fileIds.forEach(fileId -> {
                String contentPath = inventory.ensureContentPath((String)fileId);
                String contentPathNoVersion = contentPath.substring(contentPath.indexOf(inventory.resolveContentDirectory()));
                Path file = sourcePath.resolve(contentPathNoVersion);
                if (Files.notExists(file, new LinkOption[0])) {
                    throw new OcflStateException(String.format("Staged file %s does not exist", file));
                }
                String key = inventory.storagePath((String)fileId);
                objectKeys.add(key);
                this.cloudClient.uploadFile(file, key);
            });
        }
        catch (RuntimeException e) {
            this.cloudClient.safeDeleteObjects(objectKeys);
            throw e;
        }
        return objectKeys;
    }

    private List<String> storeFilesInCloud(Path source, String destination) {
        List<String> objectKeys = Collections.synchronizedList(new ArrayList());
        try (Stream<Path> paths = Files.walk(source, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                String relative = FileUtil.pathToStringStandardSeparator(source.relativize((Path)file));
                String key = FileUtil.pathJoinFailEmpty(destination, relative);
                objectKeys.add(key);
                this.cloudClient.uploadFile((Path)file, key);
            });
        }
        catch (IOException | RuntimeException e) {
            this.cloudClient.safeDeleteObjects(objectKeys);
            if (e instanceof IOException) {
                throw new OcflIOException((IOException)e);
            }
            throw (RuntimeException)e;
        }
        return objectKeys;
    }

    private List<String> copyMutableVersionToImmutableVersion(Inventory oldInventory, Inventory newInventory) {
        String contentPrefix = this.contentPrefix(newInventory);
        Set<String> fileIds = newInventory.getFileIdsForMatchingFiles(contentPrefix);
        List<String> objectKeys = Collections.synchronizedList(new ArrayList());
        try {
            fileIds.forEach(fileId -> {
                String srcPath = oldInventory.storagePath((String)fileId);
                String dstPath = newInventory.storagePath((String)fileId);
                objectKeys.add(dstPath);
                this.cloudClient.copyObject(srcPath, dstPath);
            });
        }
        catch (RuntimeException e) {
            this.cloudClient.safeDeleteObjects(objectKeys);
            throw e;
        }
        return objectKeys;
    }

    private void storeMutableHeadInventoryInCloud(Inventory inventory, Path sourcePath) {
        this.cloudClient.uploadFile(ObjectPaths.inventoryPath(sourcePath), ObjectPaths.mutableHeadInventoryPath(inventory.getObjectRootPath()), MEDIA_TYPE_JSON);
        this.cloudClient.uploadFile(ObjectPaths.inventorySidecarPath(sourcePath, inventory), ObjectPaths.mutableHeadInventorySidecarPath(inventory.getObjectRootPath(), inventory), MEDIA_TYPE_TEXT);
    }

    private void storeInventoryInCloudWithRollback(Inventory inventory, Path sourcePath, String versionPath) {
        Path srcInventoryPath = ObjectPaths.inventoryPath(sourcePath);
        Path srcSidecarPath = ObjectPaths.inventorySidecarPath(sourcePath, inventory);
        String versionedInventoryPath = ObjectPaths.inventoryPath(versionPath);
        String versionedSidecarPath = ObjectPaths.inventorySidecarPath(versionPath, inventory);
        this.cloudClient.uploadFile(srcInventoryPath, versionedInventoryPath, MEDIA_TYPE_JSON);
        this.cloudClient.uploadFile(srcSidecarPath, versionedSidecarPath, MEDIA_TYPE_TEXT);
        try {
            this.copyInventoryToRoot(versionPath, inventory);
        }
        catch (RuntimeException e) {
            this.rollbackInventory(inventory);
            this.cloudClient.safeDeleteObjects(versionedInventoryPath, versionedSidecarPath);
            throw e;
        }
    }

    private void rollbackInventory(Inventory inventory) {
        if (!this.isFirstVersion(inventory)) {
            try {
                String previousVersionPath = this.objectVersionPath(inventory, inventory.getHead().previousVersionNum());
                this.copyInventoryToRoot(previousVersionPath, inventory);
            }
            catch (RuntimeException e) {
                LOG.error("Failed to rollback inventory at {}. Object must be fixed manually.", (Object)ObjectPaths.inventoryPath(inventory.getObjectRootPath()), (Object)e);
            }
        }
    }

    private void copyInventoryToRoot(String versionPath, Inventory inventory) {
        this.cloudClient.copyObject(ObjectPaths.inventoryPath(versionPath), ObjectPaths.inventoryPath(inventory.getObjectRootPath()));
        this.cloudClient.copyObject(ObjectPaths.inventorySidecarPath(versionPath, inventory), ObjectPaths.inventorySidecarPath(inventory.getObjectRootPath(), inventory));
    }

    private String copyRootInventorySidecarToMutableHead(Inventory inventory) {
        String rootSidecarPath = ObjectPaths.inventorySidecarPath(inventory.getObjectRootPath(), inventory);
        String sidecarName = rootSidecarPath.substring(rootSidecarPath.lastIndexOf(47) + 1);
        return this.cloudClient.copyObject(rootSidecarPath, FileUtil.pathJoinFailEmpty(ObjectPaths.mutableHeadExtensionRoot(inventory.getObjectRootPath()), "root-" + sidecarName)).getPath();
    }

    private void verifyPriorInventoryMutable(Inventory inventory, boolean isNewMutableHead) {
        String sidecarPath = isNewMutableHead ? ObjectPaths.inventorySidecarPath(inventory.getObjectRootPath(), inventory) : ObjectPaths.mutableHeadInventorySidecarPath(inventory.getObjectRootPath(), inventory);
        this.verifyPriorInventory(inventory, sidecarPath);
    }

    private void verifyPriorInventory(Inventory inventory, String sidecarPath) {
        if (inventory.getPreviousDigest() != null) {
            String actualDigest = this.getDigestFromSidecar(sidecarPath);
            if (!actualDigest.equalsIgnoreCase(inventory.getPreviousDigest())) {
                throw new ObjectOutOfSyncException(String.format("Cannot update object %s because the update is out of sync with the current object state. The digest of the current inventory is %s, but the digest %s was expected.", inventory.getId(), actualDigest, inventory.getPreviousDigest()));
            }
        } else if (!inventory.getHead().equals((Object)VersionNum.V1)) {
            LOG.debug("Cannot verify prior inventory for object {} because its digest is unknown.", (Object)inventory.getId());
        }
    }

    private Inventory downloadAndVerifyInventory(String objectId, String objectRootPath) {
        Inventory inventory;
        Map.Entry<DigestAlgorithm, String> expectedDigest = this.findAndGetDigestFromSidecar(objectRootPath);
        String remotePath = ObjectPaths.inventoryPath(objectRootPath);
        FixityCheckInputStream stream = new FixityCheckInputStream(this.cloudClient.downloadStream(remotePath), expectedDigest.getKey(), expectedDigest.getValue());
        try {
            Inventory inventory2 = this.inventoryMapper.read(objectRootPath, expectedDigest.getValue(), (InputStream)stream);
            try {
                stream.checkFixity();
            }
            catch (FixityCheckException e) {
                throw new CorruptObjectException(String.format("Invalid root inventory in object %s", objectId), (Throwable)e);
            }
            inventory = inventory2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (KeyNotFoundException e) {
                throw new CorruptObjectException(String.format("Object %s is missing its root inventory", objectId), (Throwable)e);
            }
            catch (IOException e) {
                throw new OcflIOException(e);
            }
        }
        stream.close();
        return inventory;
    }

    private Inventory downloadAndVerifyMutableInventory(String objectId, String objectRootPath) {
        Inventory inventory;
        Map.Entry<DigestAlgorithm, String> expectedDigest = this.findAndGetDigestFromSidecar(ObjectPaths.mutableHeadVersionPath(objectRootPath));
        String remotePath = ObjectPaths.mutableHeadInventoryPath(objectRootPath);
        FixityCheckInputStream stream = new FixityCheckInputStream(this.cloudClient.downloadStream(remotePath), expectedDigest.getKey(), expectedDigest.getValue());
        try {
            RevisionNum revisionNum = this.identifyLatestRevision(objectRootPath);
            Inventory inventory2 = this.inventoryMapper.readMutableHead(objectRootPath, expectedDigest.getValue(), revisionNum, (InputStream)stream);
            try {
                stream.checkFixity();
            }
            catch (FixityCheckException e) {
                throw new CorruptObjectException(String.format("Invalid mutable HEAD inventory in object %s", objectId), (Throwable)e);
            }
            inventory = inventory2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (KeyNotFoundException e) {
                throw new CorruptObjectException(String.format("Object %s is missing its mutable HEAD inventory", objectId), (Throwable)e);
            }
            catch (IOException e) {
                throw new OcflIOException(e);
            }
        }
        stream.close();
        return inventory;
    }

    private Inventory downloadInventory(String objectRootPath) {
        Inventory inventory;
        block8: {
            String inventoryPath = ObjectPaths.inventoryPath(objectRootPath);
            InputStream stream = this.cloudClient.downloadStream(inventoryPath);
            try {
                inventory = this.inventoryMapper.read(objectRootPath, "digest", stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OcflIOException(e);
                }
            }
            stream.close();
        }
        return inventory;
    }

    private String createRevisionMarker(Inventory inventory) {
        String revision = inventory.getRevisionNum().toString();
        String revisionPath = FileUtil.pathJoinFailEmpty(ObjectPaths.mutableHeadRevisionsPath(inventory.getObjectRootPath()), revision);
        return this.cloudClient.uploadBytes(revisionPath, revision.getBytes(StandardCharsets.UTF_8), MEDIA_TYPE_TEXT).getPath();
    }

    private RevisionNum identifyLatestRevision(String objectRootPath) {
        String revisionsPath = ObjectPaths.mutableHeadRevisionsPath(objectRootPath);
        ListResult revisions = this.cloudClient.listDirectory(revisionsPath);
        RevisionNum revisionNum = null;
        for (ListResult.ObjectListing revisionStr : revisions.getObjects()) {
            RevisionNum id = RevisionNum.fromString(revisionStr.getKeySuffix());
            if (revisionNum == null) {
                revisionNum = id;
                continue;
            }
            if (revisionNum.compareTo(id) >= 1) continue;
            revisionNum = id;
        }
        return revisionNum;
    }

    private void deleteMutableHeadFilesNotInManifest(Inventory inventory) {
        ListResult keys = this.cloudClient.list(FileUtil.pathJoinFailEmpty(ObjectPaths.mutableHeadVersionPath(inventory.getObjectRootPath()), inventory.resolveContentDirectory()));
        ArrayList<String> deleteKeys = new ArrayList<String>();
        keys.getObjects().forEach(o -> {
            String key = o.getKey().getPath();
            String contentPath = key.substring(inventory.getObjectRootPath().length() + 1);
            if (inventory.getFileId(contentPath) == null) {
                deleteKeys.add(key);
            }
        });
        this.cloudClient.safeDeleteObjects(deleteKeys);
    }

    private String contentPrefix(Inventory inventory) {
        if (inventory.hasMutableHead()) {
            return FileUtil.pathJoinFailEmpty("extensions/0005-mutable-head/head", inventory.resolveContentDirectory(), inventory.getRevisionNum().toString());
        }
        return inventory.getHead().toString();
    }

    private Stream<String> findOcflObjectRootDirs() {
        CloudOcflObjectRootDirIterator iterator = new CloudOcflObjectRootDirIterator("", this.cloudClient);
        try {
            Spliterator<String> spliterator = Spliterators.spliteratorUnknownSize(iterator, 1041);
            return (Stream)StreamSupport.stream(spliterator, false).onClose(iterator::close);
        }
        catch (RuntimeException e) {
            iterator.close();
            throw e;
        }
    }

    private void ensureNoMutableHead(String objectId, String objectRootPath) {
        if (this.hasMutableHead(objectRootPath)) {
            throw new OcflStateException(String.format("Cannot create a new version of object %s because it has an active mutable HEAD.", objectId));
        }
    }

    private boolean hasMutableHead(String objectRootPath) {
        return !this.cloudClient.listDirectory(ObjectPaths.mutableHeadVersionPath(objectRootPath)).getObjects().isEmpty();
    }

    private void ensureVersionDoesNotExist(Inventory inventory, String versionPath) {
        if (!this.cloudClient.listDirectory(versionPath).getObjects().isEmpty()) {
            throw new ObjectOutOfSyncException(String.format("Failed to create a new version of object %s. Changes are out of sync with the current object state.", inventory.getId()));
        }
    }

    private void ensureRevisionDoesNotExist(Inventory inventory) {
        RevisionNum latestRevision = this.identifyLatestRevision(inventory.getObjectRootPath());
        if (latestRevision != null && latestRevision.compareTo(inventory.getRevisionNum()) >= 0) {
            throw new ObjectOutOfSyncException(String.format("Failed to update mutable HEAD of object %s. Changes are out of sync with the current object state.", inventory.getId()));
        }
    }

    private void ensureRootObjectHasNotChanged(Inventory inventory) {
        String rootDigest;
        String savedDigest = this.getDigestFromSidecar(FileUtil.pathJoinFailEmpty(ObjectPaths.mutableHeadExtensionRoot(inventory.getObjectRootPath()), "root-inventory.json." + inventory.getDigestAlgorithm().getOcflName()));
        if (!savedDigest.equalsIgnoreCase(rootDigest = this.getDigestFromSidecar(ObjectPaths.inventorySidecarPath(inventory.getObjectRootPath(), inventory)))) {
            throw new ObjectOutOfSyncException(String.format("The mutable HEAD of object %s is out of sync with the root object state.", inventory.getId()));
        }
    }

    private Map.Entry<DigestAlgorithm, String> findAndGetDigestFromSidecar(String path) {
        for (ListResult.ObjectListing listing : this.cloudClient.listDirectory(path).getObjects()) {
            if (!listing.getKeySuffix().startsWith("inventory.json.")) continue;
            String sidecarPath = listing.getKey().getPath();
            DigestAlgorithm algorithm = SidecarMapper.getDigestAlgorithmFromSidecar(sidecarPath);
            String digest = this.getDigestFromSidecar(sidecarPath);
            return Map.entry(algorithm, digest);
        }
        throw new CorruptObjectException("Missing inventory sidecar in " + path);
    }

    private String getDigestFromSidecar(String sidecarPath) {
        try {
            String sidecarContents = this.cloudClient.downloadString(sidecarPath);
            String[] parts = sidecarContents.split("\\s");
            if (parts.length == 0) {
                throw new CorruptObjectException("Invalid inventory sidecar file: " + sidecarPath);
            }
            return parts[0];
        }
        catch (KeyNotFoundException e) {
            throw new CorruptObjectException("Missing inventory sidecar: " + sidecarPath, (Throwable)e);
        }
    }

    private String objectVersionPath(Inventory inventory, VersionNum versionNum) {
        return FileUtil.pathJoinFailEmpty(inventory.getObjectRootPath(), versionNum.toString());
    }

    private boolean isFirstVersion(Inventory inventory) {
        return inventory.getVersions().size() == 1;
    }

    private String writeObjectNamasteFile(String objectRootPath) {
        NamasteTypeFile namasteFile = new NamasteTypeFile(this.ocflVersion.getOcflObjectVersion());
        String key = FileUtil.pathJoinFailEmpty(objectRootPath, namasteFile.fileName());
        return this.cloudClient.uploadBytes(key, namasteFile.fileContent().getBytes(StandardCharsets.UTF_8), MEDIA_TYPE_TEXT).getPath();
    }

    private void copyObjects(List<ListResult.ObjectListing> objects, Path outputPath) {
        objects.forEach(object -> {
            Path destination = outputPath.resolve(object.getKeySuffix());
            UncheckedFiles.createDirectories(destination.getParent());
            try (InputStream stream = this.cloudClient.downloadStream(object.getKey().getPath());){
                Files.copy(stream, destination, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new OcflIOException(e);
            }
        });
    }

    private void loadObjectExtensions(String objectRoot) {
        ListResult listResults = this.cloudClient.listDirectory(ObjectPaths.extensionsPath(objectRoot));
        listResults.getDirectories().forEach(dir -> this.supportEvaluator.checkSupport(dir.getName()));
    }
}

