/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.storage.cloud;

import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.storage.cloud.CloudObjectKey;
import java.util.Collections;
import java.util.List;

public class ListResult {
    private List<ObjectListing> objects = Collections.emptyList();
    private List<DirectoryListing> directories = Collections.emptyList();

    public List<ObjectListing> getObjects() {
        return this.objects;
    }

    public ListResult setObjects(List<ObjectListing> objects) {
        this.objects = (List)Enforce.notNull(objects, (String)"objects cannot be null");
        return this;
    }

    public List<DirectoryListing> getDirectories() {
        return this.directories;
    }

    public ListResult setDirectories(List<DirectoryListing> directories) {
        this.directories = (List)Enforce.notNull(directories, (String)"directories cannot be null");
        return this;
    }

    public String toString() {
        return "ListResult{objects=" + this.objects + ", directories=" + this.directories + "}";
    }

    public static class DirectoryListing {
        private String path;

        public String getPath() {
            return this.path;
        }

        public DirectoryListing setPath(String path) {
            this.path = path;
            return this;
        }

        public String getName() {
            String name = this.path;
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            return name.substring(Math.max(0, name.lastIndexOf("/") + 1));
        }

        public String toString() {
            return "DirectoryListing{path='" + this.path + "'}";
        }
    }

    public static class ObjectListing {
        private CloudObjectKey key;
        private String keySuffix;

        public CloudObjectKey getKey() {
            return this.key;
        }

        public ObjectListing setKey(CloudObjectKey key) {
            this.key = key;
            return this;
        }

        public String getKeySuffix() {
            return this.keySuffix;
        }

        public ObjectListing setKeySuffix(String keySuffix) {
            this.keySuffix = keySuffix;
            return this;
        }

        public String toString() {
            return "ObjectListing{key='" + this.key + "', keySuffix='" + this.keySuffix + "'}";
        }
    }
}

