/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.storage.cloud;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.wisc.library.ocfl.api.exception.CorruptObjectException;
import edu.wisc.library.ocfl.api.exception.InvalidInventoryException;
import edu.wisc.library.ocfl.api.exception.OcflIOException;
import edu.wisc.library.ocfl.api.exception.RepositoryConfigurationException;
import edu.wisc.library.ocfl.api.model.OcflVersion;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.ObjectPaths;
import edu.wisc.library.ocfl.core.extension.ExtensionSupportEvaluator;
import edu.wisc.library.ocfl.core.extension.OcflExtensionConfig;
import edu.wisc.library.ocfl.core.extension.OcflExtensionRegistry;
import edu.wisc.library.ocfl.core.extension.storage.layout.OcflLayout;
import edu.wisc.library.ocfl.core.extension.storage.layout.OcflStorageLayoutExtension;
import edu.wisc.library.ocfl.core.storage.cloud.CloudClient;
import edu.wisc.library.ocfl.core.storage.cloud.CloudObjectKey;
import edu.wisc.library.ocfl.core.storage.cloud.KeyNotFoundException;
import edu.wisc.library.ocfl.core.storage.cloud.ListResult;
import edu.wisc.library.ocfl.core.util.FileUtil;
import edu.wisc.library.ocfl.core.util.NamasteTypeFile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudOcflStorageInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(CloudOcflStorageInitializer.class);
    private static final String SPECS_DIR = "specs/";
    private static final String EXT_SPEC = "ocfl_extensions_1.0.md";
    private static final String MEDIA_TYPE_TEXT = "text/plain; charset=UTF-8";
    private static final String MEDIA_TYPE_JSON = "application/json; charset=UTF-8";
    private final CloudClient cloudClient;
    private final ObjectMapper objectMapper;

    public CloudOcflStorageInitializer(CloudClient cloudClient, ObjectMapper objectMapper) {
        this.cloudClient = (CloudClient)Enforce.notNull((Object)cloudClient, (String)"cloudClient cannot be null");
        this.objectMapper = (ObjectMapper)Enforce.notNull((Object)objectMapper, (String)"objectMapper cannot be null");
    }

    public OcflStorageLayoutExtension initializeStorage(OcflVersion ocflVersion, OcflExtensionConfig layoutConfig, ExtensionSupportEvaluator supportEvaluator) {
        OcflStorageLayoutExtension layoutExtension;
        Enforce.notNull((Object)ocflVersion, (String)"ocflVersion cannot be null");
        this.ensureBucketExists();
        if (this.listRootObjects().isEmpty()) {
            layoutExtension = this.initNewRepo(ocflVersion, layoutConfig);
        } else {
            layoutExtension = this.loadAndValidateExistingRepo(ocflVersion, layoutConfig);
            this.loadRepositoryExtensions(supportEvaluator);
        }
        LOG.info("OCFL repository is configured to use OCFL storage layout extension {} implemented by {}", (Object)layoutExtension.getExtensionName(), layoutExtension.getClass());
        return layoutExtension;
    }

    private OcflStorageLayoutExtension loadAndValidateExistingRepo(OcflVersion ocflVersion, OcflExtensionConfig layoutConfig) {
        this.validateOcflVersion(ocflVersion);
        OcflLayout ocflLayout = this.readOcflLayout();
        if (ocflLayout == null) {
            LOG.debug("OCFL layout extension not specified");
            return this.validateLayoutByInspection(layoutConfig);
        }
        LOG.debug("Found specified OCFL layout extension: {}", (Object)ocflLayout.getExtension());
        return this.loadLayoutByConfig(ocflLayout);
    }

    private void validateOcflVersion(OcflVersion ocflVersion) {
        OcflVersion existingOcflVersion = null;
        for (CloudObjectKey file : this.listRootObjects()) {
            String path = file.getPath();
            if (!path.startsWith("0=")) continue;
            existingOcflVersion = OcflVersion.fromOcflVersionString((String)path.substring(2));
            break;
        }
        if (existingOcflVersion == null) {
            throw new RepositoryConfigurationException("OCFL root is missing its namaste file, eg. 0=ocfl_1.0.");
        }
        if (existingOcflVersion != ocflVersion) {
            throw new RepositoryConfigurationException(String.format("OCFL version mismatch. Expected: %s; Found: %s", ocflVersion, existingOcflVersion));
        }
    }

    private OcflStorageLayoutExtension loadLayoutByConfig(OcflLayout ocflLayout) {
        OcflStorageLayoutExtension layoutExtension = this.loadLayoutExtension(ocflLayout.getExtension());
        OcflExtensionConfig expectedConfig = this.readLayoutConfig(ocflLayout, layoutExtension.getExtensionConfigClass());
        layoutExtension.init(expectedConfig);
        return layoutExtension;
    }

    private OcflStorageLayoutExtension validateLayoutByInspection(OcflExtensionConfig layoutConfig) {
        String objectId;
        String expectedPath;
        if (layoutConfig == null) {
            throw new RepositoryConfigurationException(String.format("No storage layout configuration is defined in the OCFL repository in bucket %s. Layout must be configured programmatically.", this.cloudClient.bucket()));
        }
        OcflStorageLayoutExtension layoutExtension = this.loadAndInitLayoutExtension(layoutConfig);
        String objectRoot = this.identifyRandomObjectRoot("");
        if (objectRoot != null && !(expectedPath = layoutExtension.mapObjectId(objectId = this.extractObjectId(ObjectPaths.inventoryPath(objectRoot)))).equals(objectRoot)) {
            throw new RepositoryConfigurationException(String.format("The OCFL client was configured to use the following layout: %s. This layout does not match the layout of existing objects in the repository. Found object %s stored at %s, but was expecting it to be stored at %s.", layoutConfig, objectId, objectRoot, expectedPath));
        }
        return layoutExtension;
    }

    private String identifyRandomObjectRoot(String prefix) {
        ListResult response = this.cloudClient.listDirectory(prefix);
        for (ListResult.ObjectListing object : response.getObjects()) {
            if (!object.getKeySuffix().startsWith("0=ocfl_object")) continue;
            String path = object.getKey().getPath();
            return (String)path.subSequence(0, path.lastIndexOf(47));
        }
        for (ListResult.DirectoryListing dir : response.getDirectories()) {
            String root = this.identifyRandomObjectRoot(dir.getPath());
            if (root == null) continue;
            return root;
        }
        return null;
    }

    private String extractObjectId(String inventoryPath) {
        String string;
        block10: {
            InputStream stream = this.cloudClient.downloadStream(inventoryPath);
            try {
                Map map = this.read(stream, Map.class);
                Object id = map.get("id");
                if (id == null) {
                    throw new InvalidInventoryException(String.format("Inventory file at %s does not contain an id.", inventoryPath));
                }
                string = (String)id;
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OcflIOException(e);
                }
                catch (KeyNotFoundException e) {
                    throw new CorruptObjectException(String.format("Missing inventory at %s in bucket %s", inventoryPath, this.cloudClient.bucket()));
                }
            }
            stream.close();
        }
        return string;
    }

    private OcflStorageLayoutExtension initNewRepo(OcflVersion ocflVersion, OcflExtensionConfig layoutConfig) {
        Enforce.notNull((Object)layoutConfig, (String)"layoutConfig cannot be null when initializing a new repo");
        LOG.info("Initializing new OCFL repository in the bucket <{}> prefix <{}>", (Object)this.cloudClient.bucket(), (Object)this.cloudClient.prefix());
        OcflStorageLayoutExtension layoutExtension = this.loadAndInitLayoutExtension(layoutConfig);
        ArrayList<String> keys = new ArrayList<String>();
        try {
            keys.add(this.writeNamasteFile(ocflVersion));
            keys.add(this.writeOcflSpec(ocflVersion));
            keys.addAll(this.writeOcflLayout(layoutConfig, layoutExtension.getDescription()));
            keys.add(this.writeOcflLayoutSpec(layoutConfig));
            keys.add(this.writeSpecFile(EXT_SPEC));
            return layoutExtension;
        }
        catch (RuntimeException e) {
            LOG.error("Failed to initialize OCFL repository", (Throwable)e);
            this.cloudClient.safeDeleteObjects(keys);
            throw e;
        }
    }

    private void loadRepositoryExtensions(ExtensionSupportEvaluator supportEvaluator) {
        ListResult listResults = this.cloudClient.listDirectory("extensions");
        listResults.getDirectories().forEach(dir -> supportEvaluator.checkSupport(dir.getName()));
    }

    private String writeOcflSpec(OcflVersion ocflVersion) {
        return this.writeSpecFile(ocflVersion.getOcflVersion() + ".txt");
    }

    private String writeOcflLayoutSpec(OcflExtensionConfig layoutConfig) {
        try {
            return this.writeSpecFile(layoutConfig.getExtensionName() + ".md");
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to write spec file for layout extension {}", (Object)layoutConfig.getExtensionName(), (Object)e);
            return null;
        }
    }

    private String writeSpecFile(String fileName) {
        String string;
        block8: {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(SPECS_DIR + fileName);
            try {
                string = this.uploadStream(fileName, stream).getPath();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OcflIOException(e);
                }
            }
            stream.close();
        }
        return string;
    }

    private String writeNamasteFile(OcflVersion ocflVersion) {
        NamasteTypeFile namasteFile = new NamasteTypeFile(ocflVersion.getOcflVersion());
        return this.cloudClient.uploadBytes(namasteFile.fileName(), namasteFile.fileContent().getBytes(StandardCharsets.UTF_8), MEDIA_TYPE_TEXT).getPath();
    }

    private List<String> writeOcflLayout(OcflExtensionConfig layoutConfig, String description) {
        ArrayList<String> keys = new ArrayList<String>();
        OcflLayout spec = new OcflLayout().setExtension(layoutConfig.getExtensionName()).setDescription(description);
        try {
            keys.add(this.cloudClient.uploadBytes("ocfl_layout.json", this.objectMapper.writeValueAsBytes((Object)spec), MEDIA_TYPE_JSON).getPath());
            if (layoutConfig.hasParameters()) {
                keys.add(this.cloudClient.uploadBytes(this.layoutConfigFile(layoutConfig.getExtensionName()), this.objectMapper.writeValueAsBytes((Object)layoutConfig), MEDIA_TYPE_JSON).getPath());
            }
            return keys;
        }
        catch (IOException e) {
            throw new OcflIOException(e);
        }
    }

    private OcflStorageLayoutExtension loadAndInitLayoutExtension(OcflExtensionConfig layoutConfig) {
        OcflStorageLayoutExtension layoutExtension = this.loadLayoutExtension(layoutConfig.getExtensionName());
        layoutExtension.init(layoutConfig);
        return layoutExtension;
    }

    private OcflStorageLayoutExtension loadLayoutExtension(String extensionName) {
        return (OcflStorageLayoutExtension)OcflExtensionRegistry.lookup(extensionName).orElseThrow(() -> new IllegalStateException(String.format("Failed to find an implementation for storage layout extension %s", extensionName)));
    }

    private OcflLayout readOcflLayout() {
        OcflLayout ocflLayout;
        block9: {
            InputStream stream = this.cloudClient.downloadStream("ocfl_layout.json");
            try {
                ocflLayout = this.read(stream, OcflLayout.class);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (KeyNotFoundException e) {
                    return null;
                }
                catch (IOException e) {
                    throw new OcflIOException(e);
                }
            }
            stream.close();
        }
        return ocflLayout;
    }

    private OcflExtensionConfig readLayoutConfig(OcflLayout ocflLayout, Class<? extends OcflExtensionConfig> clazz) {
        OcflExtensionConfig ocflExtensionConfig;
        block9: {
            InputStream stream = this.cloudClient.downloadStream(this.layoutConfigFile(ocflLayout.getExtension()));
            try {
                ocflExtensionConfig = this.read(stream, clazz);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (KeyNotFoundException e) {
                    return this.initClass(clazz);
                }
                catch (IOException e) {
                    throw new OcflIOException(e);
                }
            }
            stream.close();
        }
        return ocflExtensionConfig;
    }

    private <T> T initClass(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RepositoryConfigurationException(String.format("Failed to init OCFL storage layout extension configuration class %s", clazz), (Throwable)e);
        }
    }

    private String layoutConfigFile(String extensionName) {
        return FileUtil.pathJoinFailEmpty("extensions", extensionName, "config.json");
    }

    private <T> T read(InputStream stream, Class<T> clazz) {
        try {
            return (T)this.objectMapper.readValue(stream, clazz);
        }
        catch (IOException e) {
            throw new OcflIOException(e);
        }
    }

    private void ensureBucketExists() {
        if (!this.cloudClient.bucketExists()) {
            throw new RepositoryConfigurationException(String.format("Bucket %s does not exist or is not accessible.", this.cloudClient.bucket()));
        }
    }

    private CloudObjectKey uploadStream(String remotePath, InputStream stream) {
        try {
            return this.cloudClient.uploadBytes(remotePath, stream.readAllBytes(), MEDIA_TYPE_TEXT);
        }
        catch (IOException e) {
            throw new OcflIOException(e);
        }
    }

    private List<CloudObjectKey> listRootObjects() {
        return this.cloudClient.listDirectory("").getObjects().stream().map(ListResult.ObjectListing::getKey).collect(Collectors.toList());
    }
}

