/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.validation.storage;

import edu.wisc.library.ocfl.api.exception.NotFoundException;
import edu.wisc.library.ocfl.api.exception.OcflIOException;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.util.FileUtil;
import edu.wisc.library.ocfl.core.validation.storage.Listing;
import edu.wisc.library.ocfl.core.validation.storage.Storage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileSystemStorage
implements Storage {
    private final Path storageRoot;

    public FileSystemStorage(Path storageRoot) {
        this.storageRoot = (Path)Enforce.notNull((Object)storageRoot, (String)"storageRoot cannot be null");
    }

    @Override
    public List<Listing> listDirectory(String directoryPath, boolean recursive) {
        Path fullPath = this.storageRoot.resolve(directoryPath);
        if (Files.notExists(fullPath, new LinkOption[0])) {
            return new ArrayList<Listing>();
        }
        if (recursive) {
            return this.listLeaves(fullPath);
        }
        return this.listChildren(fullPath);
    }

    @Override
    public boolean fileExists(String filePath) {
        return Files.exists(this.storageRoot.resolve(filePath), new LinkOption[0]);
    }

    @Override
    public InputStream readFile(String filePath) {
        try {
            return Files.newInputStream(this.storageRoot.resolve(filePath), new OpenOption[0]);
        }
        catch (NoSuchFileException e) {
            throw new NotFoundException(String.format("%s was not found", filePath), (Throwable)e);
        }
        catch (IOException e) {
            throw new OcflIOException(e);
        }
    }

    private List<Listing> listChildren(Path root) {
        List<Listing> list;
        block8: {
            Stream<Path> children = Files.list(root);
            try {
                list = children.map(child -> {
                    String name = child.getFileName().toString();
                    if (Files.isRegularFile(child, new LinkOption[0])) {
                        return Listing.file(name);
                    }
                    return Listing.directory(name);
                }).collect(Collectors.toList());
                if (children == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (children != null) {
                        try {
                            children.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OcflIOException(e);
                }
            }
            children.close();
        }
        return list;
    }

    private List<Listing> listLeaves(final Path root) {
        final ArrayList<Listing> listings = new ArrayList<Listing>();
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    listings.add(this.createListing(Listing.Type.File, file));
                    return super.visitFile(file, attrs);
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (FileUtil.isDirEmpty(dir)) {
                        listings.add(this.createListing(Listing.Type.Directory, dir));
                    }
                    return super.postVisitDirectory(dir, exc);
                }

                private Listing createListing(Listing.Type type, Path file) {
                    String relative = FileUtil.pathToStringStandardSeparator(root.relativize(file));
                    return new Listing(type, relative);
                }
            });
        }
        catch (IOException e) {
            throw new OcflIOException(e);
        }
        return listings;
    }
}

