/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.extension.storage.layout;

import edu.wisc.library.ocfl.api.exception.OcflExtensionException;
import edu.wisc.library.ocfl.core.extension.OcflExtensionConfig;
import edu.wisc.library.ocfl.core.extension.storage.layout.OcflStorageLayoutExtension;
import edu.wisc.library.ocfl.core.extension.storage.layout.config.FlatOmitPrefixLayoutConfig;

public class FlatOmitPrefixLayoutExtension
implements OcflStorageLayoutExtension {
    public static final String EXTENSION_NAME = "0006-flat-omit-prefix-storage-layout";
    private String delim;

    @Override
    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    @Override
    public String getDescription() {
        return "The OCFL object identifiers are expected to contain prefixes which are removed in the mapping to directory names. The OCFL object identifier prefix is defined as all characters before and including a configurable delimiter.";
    }

    @Override
    public synchronized void init(OcflExtensionConfig config) {
        if (this.delim == null) {
            if (config == null) {
                throw new IllegalArgumentException("Arg config must not be null!");
            }
            if (!(config instanceof FlatOmitPrefixLayoutConfig)) {
                throw new OcflExtensionException(String.format("This extension only supports %s configuration. Received: %s", this.getExtensionConfigClass(), config));
            }
            FlatOmitPrefixLayoutConfig castConfig = (FlatOmitPrefixLayoutConfig)config;
            FlatOmitPrefixLayoutExtension.validateConfig(castConfig);
            this.delim = castConfig.getDelimiter().toLowerCase();
        }
    }

    private static void validateConfig(FlatOmitPrefixLayoutConfig config) {
        String delimiter;
        if (config != null && ((delimiter = config.getDelimiter()) == null || delimiter.isEmpty())) {
            throw new OcflExtensionException("Digest configuration must not be empty!");
        }
    }

    @Override
    public Class<? extends OcflExtensionConfig> getExtensionConfigClass() {
        return FlatOmitPrefixLayoutConfig.class;
    }

    @Override
    public String mapObjectId(String objectId) {
        if (this.delim == null) {
            throw new OcflExtensionException("This extension must be initialized before it can be used.");
        }
        String id = objectId.toLowerCase();
        int index = id.lastIndexOf(this.delim);
        String dir = objectId.substring(index + this.delim.length());
        if ("extensions".equals(dir) || dir.isEmpty()) {
            throw new OcflExtensionException(String.format("The object id <%s> is incompatible with layout extension %s because it is empty or conflicts with the extensions directory.", objectId, EXTENSION_NAME));
        }
        return dir;
    }
}

