/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.storage;

import edu.wisc.library.ocfl.api.exception.OcflStateException;
import edu.wisc.library.ocfl.api.model.OcflVersion;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.extension.ExtensionSupportEvaluator;
import edu.wisc.library.ocfl.core.extension.OcflExtensionConfig;
import edu.wisc.library.ocfl.core.inventory.InventoryMapper;
import edu.wisc.library.ocfl.core.storage.OcflStorage;

public abstract class AbstractOcflStorage
implements OcflStorage {
    protected InventoryMapper inventoryMapper;
    protected OcflVersion ocflVersion;
    protected ExtensionSupportEvaluator supportEvaluator;
    private boolean closed = false;
    private boolean initialized = false;

    @Override
    public synchronized void initializeStorage(OcflVersion ocflVersion, OcflExtensionConfig layoutConfig, InventoryMapper inventoryMapper, ExtensionSupportEvaluator supportEvaluator) {
        if (this.initialized) {
            return;
        }
        this.inventoryMapper = (InventoryMapper)Enforce.notNull((Object)inventoryMapper, (String)"inventoryMapper cannot be null");
        this.ocflVersion = (OcflVersion)Enforce.notNull((Object)ocflVersion, (String)"ocflVersion cannot be null");
        this.supportEvaluator = (ExtensionSupportEvaluator)Enforce.notNull((Object)supportEvaluator, (String)"supportEvaluator cannot be null");
        this.doInitialize(layoutConfig);
        this.initialized = true;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void invalidateCache(String objectId) {
    }

    @Override
    public void invalidateCache() {
    }

    protected abstract void doInitialize(OcflExtensionConfig var1);

    protected void ensureOpen() {
        if (this.closed) {
            throw new OcflStateException(this.getClass().getName() + " is closed.");
        }
        if (!this.initialized) {
            throw new OcflStateException(this.getClass().getName() + " must be initialized before it can be used.");
        }
    }
}

