/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.validation.model;

import edu.wisc.library.ocfl.core.validation.model.SimpleVersion;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SimpleInventory {
    public static final String ID_KEY = "id";
    public static final String TYPE_KEY = "type";
    public static final String DIGEST_ALGO_KEY = "digestAlgorithm";
    public static final String HEAD_KEY = "head";
    public static final String CONTENT_DIR_KEY = "contentDirectory";
    public static final String FIXITY_KEY = "fixity";
    public static final String MANIFEST_KEY = "manifest";
    public static final String VERSIONS_KEY = "versions";
    private String id;
    private String type;
    private String digestAlgorithm;
    private String head;
    private String contentDirectory;
    private Map<String, Map<String, List<String>>> fixity;
    private Map<String, List<String>> manifest;
    private Map<String, SimpleVersion> versions;
    private Map<String, String> invertedManifest;

    public SimpleInventory() {
    }

    public SimpleInventory(String id, String type, String digestAlgorithm, String head, String contentDirectory, Map<String, Map<String, List<String>>> fixity, Map<String, List<String>> manifest, Map<String, SimpleVersion> versions) {
        this.id = id;
        this.type = type;
        this.digestAlgorithm = digestAlgorithm;
        this.head = head;
        this.contentDirectory = contentDirectory;
        this.fixity = fixity;
        this.manifest = manifest;
        this.versions = versions;
    }

    public String getId() {
        return this.id;
    }

    public SimpleInventory setId(String id) {
        this.id = id;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public SimpleInventory setType(String type) {
        this.type = type;
        return this;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public SimpleInventory setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
        return this;
    }

    public String getHead() {
        return this.head;
    }

    public SimpleInventory setHead(String head) {
        this.head = head;
        return this;
    }

    public String getContentDirectory() {
        return this.contentDirectory;
    }

    public SimpleInventory setContentDirectory(String contentDirectory) {
        this.contentDirectory = contentDirectory;
        return this;
    }

    public Map<String, Map<String, List<String>>> getFixity() {
        return this.fixity;
    }

    public SimpleInventory setFixity(Map<String, Map<String, List<String>>> fixity) {
        this.fixity = fixity;
        return this;
    }

    public Map<String, List<String>> getManifest() {
        return this.manifest;
    }

    public SimpleInventory setManifest(Map<String, List<String>> manifest) {
        this.manifest = manifest;
        return this;
    }

    public Map<String, SimpleVersion> getVersions() {
        return this.versions;
    }

    public SimpleInventory setVersions(Map<String, SimpleVersion> versions) {
        this.versions = versions;
        return this;
    }

    public Map<String, String> getInvertedManifest() {
        if (this.invertedManifest == null && this.manifest != null) {
            this.invertedManifest = this.invertMap(this.manifest);
        }
        return this.invertedManifest;
    }

    public Map<String, String> getInvertedManifestCopy() {
        if (this.invertedManifest == null && this.manifest != null) {
            return this.invertMap(this.manifest);
        }
        if (this.invertedManifest != null) {
            return new HashMap<String, String>(this.invertedManifest);
        }
        return null;
    }

    private Map<String, String> invertMap(Map<String, List<String>> original) {
        HashMap<String, String> inverted = new HashMap<String, String>(original.size());
        original.forEach((key, values) -> values.forEach(value -> inverted.put((String)value, (String)key)));
        return inverted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleInventory that = (SimpleInventory)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.type, that.type) && Objects.equals(this.digestAlgorithm, that.digestAlgorithm) && Objects.equals(this.head, that.head) && Objects.equals(this.contentDirectory, that.contentDirectory) && Objects.equals(this.fixity, that.fixity) && Objects.equals(this.manifest, that.manifest) && Objects.equals(this.versions, that.versions);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.digestAlgorithm, this.head, this.contentDirectory, this.fixity, this.manifest, this.versions);
    }

    public String toString() {
        return "SimpleInventory{id='" + this.id + "', type='" + this.type + "', digestAlgorithm='" + this.digestAlgorithm + "', head='" + this.head + "', contentDirectory='" + this.contentDirectory + "', fixity=" + this.fixity + ", manifest=" + this.manifest + ", versions=" + this.versions + "}";
    }
}

