/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.inventory;

import at.favre.lib.bytes.Bytes;
import edu.wisc.library.ocfl.api.OcflOption;
import edu.wisc.library.ocfl.api.exception.OcflIOException;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.inventory.InventoryUpdater;
import edu.wisc.library.ocfl.core.util.DigestUtil;
import edu.wisc.library.ocfl.core.util.FileUtil;
import edu.wisc.library.ocfl.core.util.UncheckedFiles;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddFileProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AddFileProcessor.class);
    private final InventoryUpdater inventoryUpdater;
    private final Path stagingDir;
    private final DigestAlgorithm digestAlgorithm;
    private final MessageDigest messageDigest;

    public static Builder builder() {
        return new Builder();
    }

    public AddFileProcessor(InventoryUpdater inventoryUpdater, Path stagingDir, DigestAlgorithm digestAlgorithm) {
        this.inventoryUpdater = (InventoryUpdater)Enforce.notNull((Object)inventoryUpdater, (String)"inventoryUpdater cannot be null");
        this.stagingDir = (Path)Enforce.notNull((Object)stagingDir, (String)"stagingDir cannot be null");
        this.digestAlgorithm = (DigestAlgorithm)Enforce.notNull((Object)digestAlgorithm, (String)"digestAlgorithm cannot be null");
        this.messageDigest = digestAlgorithm.getMessageDigest();
    }

    public Map<String, Path> processPath(Path sourcePath, OcflOption ... ocflOptions) {
        return this.processPath(sourcePath, "", ocflOptions);
    }

    public Map<String, Path> processPath(Path sourcePath, String destinationPath, OcflOption ... options) {
        Enforce.notNull((Object)sourcePath, (String)"sourcePath cannot be null");
        Enforce.notNull((Object)destinationPath, (String)"destinationPath cannot be null");
        HashMap<String, Path> results = new HashMap<String, Path>();
        Set optionsSet = OcflOption.toSet((OcflOption[])options);
        String destination = this.destinationPath(destinationPath, sourcePath);
        try (Stream<Path> paths = Files.walk(sourcePath, FileVisitOption.FOLLOW_LINKS);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                this.messageDigest.reset();
                String logicalPath = this.logicalPath(sourcePath, (Path)file, destination);
                if (optionsSet.contains(OcflOption.MOVE_SOURCE)) {
                    String digest = DigestUtil.computeDigestHex(this.messageDigest, file);
                    InventoryUpdater.AddFileResult result = this.inventoryUpdater.addFile(digest, logicalPath, options);
                    if (result.isNew()) {
                        Path stagingFullPath = this.stagingFullPath(result.getPathUnderContentDir());
                        results.put(logicalPath, stagingFullPath);
                        LOG.debug("Moving file <{}> to <{}>", file, (Object)stagingFullPath);
                        FileUtil.moveFileMakeParents(file, stagingFullPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                } else {
                    Path stagingFullPath = this.stagingFullPath(this.inventoryUpdater.innerContentPath(logicalPath));
                    if (Files.notExists(stagingFullPath.getParent(), new LinkOption[0])) {
                        UncheckedFiles.createDirectories(stagingFullPath.getParent());
                    }
                    try (DigestOutputStream stream = new DigestOutputStream(new BufferedOutputStream(Files.newOutputStream(stagingFullPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING)), this.messageDigest);){
                        LOG.debug("Copying file <{}> to <{}>", file, (Object)stagingFullPath);
                        Files.copy(file, stream);
                        String digest = Bytes.wrap((byte[])stream.getMessageDigest().digest()).encodeHex();
                        InventoryUpdater.AddFileResult result = this.inventoryUpdater.addFile(digest, logicalPath, options);
                        if (result.isNew()) {
                            results.put(logicalPath, stagingFullPath);
                        } else {
                            LOG.debug("Deleting file <{}> because a file with same digest <{}> is already present in the object", (Object)stagingFullPath, (Object)digest);
                            Files.delete(stagingFullPath);
                        }
                    }
                    catch (IOException e) {
                        throw new OcflIOException(e);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new OcflIOException(e);
        }
        if (optionsSet.contains(OcflOption.MOVE_SOURCE)) {
            FileUtil.safeDeleteDirectory(sourcePath);
        }
        return results;
    }

    public Map<String, Path> processFileWithDigest(String digest, Path sourcePath, String destinationPath, OcflOption ... options) {
        Enforce.notBlank((String)digest, (String)"digest cannot be blank");
        Enforce.notNull((Object)sourcePath, (String)"sourcePath cannot be null");
        Enforce.notNull((Object)destinationPath, (String)"destinationPath cannot be null");
        if (!Files.isRegularFile(sourcePath, new LinkOption[0])) {
            throw new IllegalStateException(String.format("%s must be a regular file", sourcePath));
        }
        HashMap<String, Path> results = new HashMap<String, Path>();
        Set optionsSet = OcflOption.toSet((OcflOption[])options);
        String destination = this.destinationPath(destinationPath, sourcePath);
        String logicalPath = this.logicalPath(sourcePath, sourcePath, destination);
        InventoryUpdater.AddFileResult result = this.inventoryUpdater.addFile(digest, logicalPath, options);
        if (result.isNew()) {
            Path stagingFullPath = this.stagingFullPath(result.getPathUnderContentDir());
            results.put(logicalPath, stagingFullPath);
            if (optionsSet.contains(OcflOption.MOVE_SOURCE)) {
                LOG.debug("Moving file <{}> to <{}>", (Object)sourcePath, (Object)stagingFullPath);
                FileUtil.moveFileMakeParents(sourcePath, stagingFullPath, StandardCopyOption.REPLACE_EXISTING);
            } else {
                LOG.debug("Copying file <{}> to <{}>", (Object)sourcePath, (Object)stagingFullPath);
                FileUtil.copyFileMakeParents(sourcePath, stagingFullPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        return results;
    }

    private String destinationPath(String path, Path sourcePath) {
        if (path.isBlank() && Files.isRegularFile(sourcePath, new LinkOption[0])) {
            return sourcePath.getFileName().toString();
        }
        return path;
    }

    private String logicalPath(Path sourcePath, Path sourceFile, String destinationPath) {
        String sourceRelative = FileUtil.pathToStringStandardSeparator(sourcePath.relativize(sourceFile));
        return FileUtil.pathJoinIgnoreEmpty(destinationPath, sourceRelative);
    }

    private Path stagingFullPath(String pathUnderContentDir) {
        return Paths.get(FileUtil.pathJoinFailEmpty(this.stagingDir.toString(), pathUnderContentDir), new String[0]);
    }

    public static class Builder {
        public AddFileProcessor build(InventoryUpdater inventoryUpdater, Path stagingDir, DigestAlgorithm digestAlgorithm) {
            return new AddFileProcessor(inventoryUpdater, stagingDir, digestAlgorithm);
        }
    }
}

