/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.inventory;

import edu.wisc.library.ocfl.api.DigestAlgorithmRegistry;
import edu.wisc.library.ocfl.api.OcflConstants;
import edu.wisc.library.ocfl.api.exception.CorruptObjectException;
import edu.wisc.library.ocfl.api.exception.OcflIOException;
import edu.wisc.library.ocfl.api.exception.OcflNoSuchFileException;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.core.ObjectPaths;
import edu.wisc.library.ocfl.core.model.Inventory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class SidecarMapper {
    private SidecarMapper() {
    }

    public static void writeSidecar(Inventory inventory, String digest, Path dstDirectory) {
        try {
            Path sidecarPath = ObjectPaths.inventorySidecarPath(dstDirectory, inventory);
            Files.writeString(sidecarPath, (CharSequence)(digest + "\tinventory.json"), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new OcflIOException(e);
        }
    }

    public static String readDigestRequired(Path sidecarPath) {
        try {
            return SidecarMapper.readDigestOptional(sidecarPath);
        }
        catch (OcflNoSuchFileException e) {
            throw new CorruptObjectException("Inventory sidecar does not exist at " + sidecarPath);
        }
    }

    public static String readDigestOptional(Path sidecarPath) {
        try {
            String[] parts = Files.readString(sidecarPath).split("\\s+");
            if (parts.length != 2) {
                throw new CorruptObjectException("Invalid inventory sidecar file: " + sidecarPath);
            }
            return parts[0];
        }
        catch (NoSuchFileException e) {
            throw new OcflNoSuchFileException((IOException)e);
        }
        catch (IOException e) {
            throw new OcflIOException(e);
        }
    }

    public static DigestAlgorithm getDigestAlgorithmFromSidecar(String inventorySidecarPath) {
        return SidecarMapper.getDigestAlgorithmFromSidecar(Paths.get(inventorySidecarPath, new String[0]));
    }

    public static DigestAlgorithm getDigestAlgorithmFromSidecar(Path inventorySidecarPath) {
        String value = inventorySidecarPath.getFileName().toString().substring("inventory.json.".length());
        DigestAlgorithm algorithm = DigestAlgorithmRegistry.getAlgorithm((String)value);
        if (!OcflConstants.ALLOWED_DIGEST_ALGORITHMS.contains(algorithm)) {
            throw new CorruptObjectException(String.format("Inventory sidecar at <%s> specifies digest algorithm %s. Allowed algorithms are: %s", inventorySidecarPath, value, OcflConstants.ALLOWED_DIGEST_ALGORITHMS));
        }
        return algorithm;
    }
}

