/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.lock;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import edu.wisc.library.ocfl.api.exception.LockException;
import edu.wisc.library.ocfl.api.exception.OcflJavaException;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.lock.ObjectLock;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class InMemoryObjectLock
implements ObjectLock {
    private final Cache<String, ReentrantLock> locks;
    private final long waitTime;
    private final TimeUnit timeUnit;

    public InMemoryObjectLock(long waitTime, TimeUnit timeUnit) {
        this((Cache<String, ReentrantLock>)Caffeine.newBuilder().weakValues().build(), waitTime, timeUnit);
    }

    InMemoryObjectLock(Cache<String, ReentrantLock> locks, long waitTime, TimeUnit timeUnit) {
        this.locks = (Cache)Enforce.notNull(locks, (String)"lock cache cannot be null");
        this.waitTime = (Long)Enforce.expressionTrue((waitTime >= 0L ? 1 : 0) != 0, (Object)waitTime, (String)"waitTime must be at least 0");
        this.timeUnit = (TimeUnit)((Object)Enforce.notNull((Object)((Object)timeUnit), (String)"timeUnit cannot be null"));
    }

    @Override
    public void doInWriteLock(String objectId, Runnable doInLock) {
        this.doInWriteLock(objectId, () -> {
            doInLock.run();
            return null;
        });
    }

    @Override
    public <T> T doInWriteLock(String objectId, Callable<T> doInLock) {
        ReentrantLock lock = (ReentrantLock)this.locks.get((Object)objectId, k -> new ReentrantLock());
        return this.doInLock(objectId, lock, doInLock);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T doInLock(String objectId, Lock lock, Callable<T> doInLock) {
        try {
            if (!lock.tryLock(this.waitTime, this.timeUnit)) throw new LockException("Failed to acquire lock for object " + objectId);
            try {
                T t = doInLock.call();
                return t;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new OcflJavaException((Throwable)e);
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new LockException((Throwable)e);
        }
    }
}

