/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.lock;

import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.db.DbType;
import edu.wisc.library.ocfl.core.db.TableCreator;
import edu.wisc.library.ocfl.core.lock.DbObjectLock;
import edu.wisc.library.ocfl.core.lock.InMemoryObjectLock;
import edu.wisc.library.ocfl.core.lock.ObjectLock;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;

public class ObjectLockBuilder {
    private static final String DEFAULT_TABLE_NAME = "ocfl_object_lock";
    private long waitTime = 10L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private DataSource dataSource;
    private String tableName;
    private Duration maxLockDuration = Duration.ofHours(1L);

    public ObjectLockBuilder waitTime(long waitTime, TimeUnit timeUnit) {
        this.waitTime = (Long)Enforce.expressionTrue((waitTime > 0L ? 1 : 0) != 0, (Object)waitTime, (String)"waitTime must be greater than 0");
        this.timeUnit = (TimeUnit)((Object)Enforce.notNull((Object)((Object)timeUnit), (String)"timeUnit cannot be null"));
        return this;
    }

    public ObjectLockBuilder dataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public ObjectLockBuilder tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public ObjectLockBuilder maxLockDuration(Duration maxLockDuration) {
        this.maxLockDuration = maxLockDuration;
        return this;
    }

    public ObjectLock build() {
        if (this.dataSource == null) {
            return this.buildMemLock();
        }
        return this.buildDbLock();
    }

    private ObjectLock buildDbLock() {
        Enforce.notNull((Object)this.dataSource, (String)"dataSource cannot be null");
        String resolvedTableName = this.tableName == null ? DEFAULT_TABLE_NAME : this.tableName;
        DbType dbType = DbType.fromDataSource(this.dataSource);
        DbObjectLock lock = new DbObjectLock(dbType, resolvedTableName, this.dataSource, this.maxLockDuration);
        new TableCreator(dbType, this.dataSource).createObjectLockTable(resolvedTableName);
        return lock;
    }

    private ObjectLock buildMemLock() {
        return new InMemoryObjectLock(this.waitTime, this.timeUnit);
    }
}

