/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.validation;

import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.validation.model.SimpleInventory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

class Manifests {
    private final Map<String, Map<String, String>> manifests;

    public Manifests(SimpleInventory inventory) {
        Enforce.notBlank((String)inventory.getDigestAlgorithm(), (String)"digestAlgorithm cannot be blank");
        Enforce.notNull(inventory.getManifest(), (String)"manifest cannot be null");
        this.manifests = new HashMap<String, Map<String, String>>();
        this.manifests.put(inventory.getDigestAlgorithm(), inventory.getInvertedManifest());
    }

    public void addManifest(SimpleInventory inventory) {
        Enforce.notBlank((String)inventory.getDigestAlgorithm(), (String)"digestAlgorithm cannot be blank");
        Enforce.notNull(inventory.getManifest(), (String)"manifest cannot be null");
        if (!this.manifests.containsKey(inventory.getDigestAlgorithm())) {
            this.manifests.put(inventory.getDigestAlgorithm(), inventory.getInvertedManifest());
        }
    }

    public String getDigest(String digestAlgorithm, String contentPath) {
        return (String)this.manifests.getOrDefault(digestAlgorithm, Collections.emptyMap()).get(contentPath);
    }

    public Map<String, String> getDigests(String contentPath) {
        return this.manifests.entrySet().stream().map(entry -> {
            String digest = (String)((Map)entry.getValue()).get(contentPath);
            if (digest != null) {
                return Map.entry((String)entry.getKey(), digest);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public boolean containsAlgorithm(String digestAlgorithm) {
        return this.manifests.containsKey(digestAlgorithm);
    }

    public boolean hasMultipleAlgorithms() {
        return this.manifests.size() > 1;
    }
}

