/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.db;

import edu.wisc.library.ocfl.api.exception.OcflDbException;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.db.DbType;
import edu.wisc.library.ocfl.core.util.FileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableCreator {
    private static final Logger LOG = LoggerFactory.getLogger(TableCreator.class);
    private static final String LOCK_TABLE_FILE = "ocfl_object_lock.ddl.tmpl";
    private static final String OBJECT_DETAILS_TABLE_FILE = "ocfl_object_details.ddl.tmpl";
    private final Map<DbType, String> dbScriptDir = Map.of(DbType.POSTGRES, "db/postgresql", DbType.MARIADB, "db/mariadb", DbType.H2, "db/h2");
    private final DbType dbType;
    private final DataSource dataSource;

    public TableCreator(DbType dbType, DataSource dataSource) {
        this.dbType = (DbType)((Object)Enforce.notNull((Object)((Object)dbType), (String)"dbType cannot be null"));
        this.dataSource = (DataSource)Enforce.notNull((Object)dataSource, (String)"dataSource cannot be null");
    }

    public void createObjectLockTable(String tableName) {
        this.createTable(tableName, LOCK_TABLE_FILE);
    }

    public void createObjectDetailsTable(String tableName) {
        this.createTable(tableName, OBJECT_DETAILS_TABLE_FILE);
    }

    private void createTable(String tableName, String fileName) {
        block20: {
            Enforce.notBlank((String)tableName, (String)"tableName cannot be blank");
            try (Connection connection = this.dataSource.getConnection();){
                String filePath = this.getSqlFilePath(fileName);
                LOG.debug("Loading {}", (Object)filePath);
                if (filePath == null) break block20;
                try (InputStream stream = this.getClass().getResourceAsStream("/" + filePath);){
                    String ddlTemplate = this.streamToString(stream);
                    String ddl = String.format(ddlTemplate, tableName);
                    try (PreparedStatement statement = connection.prepareStatement(ddl);){
                        statement.executeUpdate();
                    }
                }
            }
            catch (IOException | SQLException e) {
                throw new OcflDbException((Throwable)e);
            }
        }
    }

    private String getSqlFilePath(String fileName) {
        String scriptDir = this.dbScriptDir.get((Object)this.dbType);
        if (scriptDir == null) {
            LOG.warn("There are no scripts configured for {}", (Object)this.dbType);
            return null;
        }
        return FileUtil.pathJoinFailEmpty(scriptDir, fileName);
    }

    private String streamToString(InputStream stream) throws IOException {
        return new String(stream.readAllBytes(), StandardCharsets.UTF_8);
    }
}

