/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.storage.cloud;

import edu.wisc.library.ocfl.api.OcflFileRetriever;
import edu.wisc.library.ocfl.api.io.FixityCheckInputStream;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.storage.cloud.CloudClient;
import java.io.BufferedInputStream;
import java.io.InputStream;

public class CloudOcflFileRetriever
implements OcflFileRetriever {
    private final CloudClient cloudClient;
    private final String key;
    private final DigestAlgorithm digestAlgorithm;
    private final String digestValue;

    public static Builder builder() {
        return new Builder();
    }

    public CloudOcflFileRetriever(CloudClient cloudClient, String key, DigestAlgorithm digestAlgorithm, String digestValue) {
        this.cloudClient = (CloudClient)Enforce.notNull((Object)cloudClient, (String)"cloudClient cannot be null");
        this.key = Enforce.notBlank((String)key, (String)"key cannot be blank");
        this.digestAlgorithm = (DigestAlgorithm)Enforce.notNull((Object)digestAlgorithm, (String)"digestAlgorithm cannot be null");
        this.digestValue = Enforce.notBlank((String)digestValue, (String)"digestValue cannot be null");
    }

    public FixityCheckInputStream retrieveFile() {
        return new FixityCheckInputStream((InputStream)new BufferedInputStream(this.cloudClient.downloadStream(this.key)), this.digestAlgorithm, this.digestValue);
    }

    public static class Builder {
        private CloudClient cloudClient;

        public Builder cloudClient(CloudClient cloudClient) {
            this.cloudClient = cloudClient;
            return this;
        }

        public CloudOcflFileRetriever build(String key, DigestAlgorithm digestAlgorithm, String digestValue) {
            return new CloudOcflFileRetriever(this.cloudClient, key, digestAlgorithm, digestValue);
        }
    }
}

