/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.storage.cloud;

import edu.wisc.library.ocfl.api.OcflFileRetriever;
import edu.wisc.library.ocfl.api.exception.OcflFileAlreadyExistsException;
import edu.wisc.library.ocfl.api.exception.OcflIOException;
import edu.wisc.library.ocfl.api.exception.OcflNoSuchFileException;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.storage.cloud.CloudClient;
import edu.wisc.library.ocfl.core.storage.cloud.CloudOcflFileRetriever;
import edu.wisc.library.ocfl.core.storage.cloud.CloudOcflObjectRootDirIterator;
import edu.wisc.library.ocfl.core.storage.cloud.KeyNotFoundException;
import edu.wisc.library.ocfl.core.storage.cloud.ListResult;
import edu.wisc.library.ocfl.core.storage.common.Listing;
import edu.wisc.library.ocfl.core.storage.common.OcflObjectRootDirIterator;
import edu.wisc.library.ocfl.core.storage.common.Storage;
import edu.wisc.library.ocfl.core.util.FileUtil;
import edu.wisc.library.ocfl.core.util.UncheckedFiles;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudStorage
implements Storage {
    private static final Logger LOG = LoggerFactory.getLogger(CloudStorage.class);
    private final CloudClient client;
    private final CloudOcflFileRetriever.Builder fileRetrieverBuilder;

    public CloudStorage(CloudClient client) {
        this.client = (CloudClient)Enforce.notNull((Object)client, (String)"client cannot be null");
        this.fileRetrieverBuilder = CloudOcflFileRetriever.builder().cloudClient(client);
    }

    @Override
    public List<Listing> listDirectory(String directoryPath) {
        ArrayList<Listing> listings = new ArrayList<Listing>();
        ListResult result = this.client.listDirectory(directoryPath);
        result.getObjects().forEach(object -> listings.add(Listing.file(object.getKeySuffix())));
        result.getDirectories().forEach(dir -> listings.add(Listing.directory(dir.getName())));
        if (listings.isEmpty()) {
            throw new OcflNoSuchFileException(String.format("Directory %s does not exist", directoryPath));
        }
        return listings;
    }

    @Override
    public List<Listing> listRecursive(String directoryPath) {
        ArrayList<Listing> listings = new ArrayList<Listing>();
        ListResult result = this.client.list(this.withTrailingSlash(directoryPath));
        result.getObjects().forEach(object -> listings.add(Listing.file(object.getKeySuffix())));
        result.getDirectories().forEach(dir -> listings.add(Listing.directory(dir.getName())));
        if (listings.isEmpty()) {
            throw new OcflNoSuchFileException(String.format("Directory %s does not exist", directoryPath));
        }
        return listings;
    }

    @Override
    public OcflObjectRootDirIterator iterateObjects() {
        return new CloudOcflObjectRootDirIterator(this.client);
    }

    @Override
    public boolean fileExists(String filePath) {
        try {
            this.client.head(filePath);
            return true;
        }
        catch (KeyNotFoundException e) {
            return false;
        }
    }

    @Override
    public InputStream read(String filePath) {
        try {
            return new BufferedInputStream(this.client.downloadStream(filePath));
        }
        catch (KeyNotFoundException e) {
            throw new OcflNoSuchFileException(String.format("%s was not found", filePath), (Exception)e);
        }
    }

    @Override
    public String readToString(String filePath) {
        String string;
        block8: {
            InputStream stream = this.read(filePath);
            try {
                string = new String(stream.readAllBytes());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw OcflIOException.from((IOException)e);
                }
            }
            stream.close();
        }
        return string;
    }

    @Override
    public OcflFileRetriever readLazy(String filePath, DigestAlgorithm algorithm, String digest) {
        return this.fileRetrieverBuilder.build(filePath, algorithm, digest);
    }

    @Override
    public void write(String filePath, byte[] content, String mediaType) {
        this.failOnExistingFile(filePath);
        this.client.uploadBytes(filePath, content, mediaType);
    }

    @Override
    public void createDirectories(String path) {
    }

    @Override
    public void copyDirectoryOutOf(String source, Path outputPath) {
        List<ListResult.ObjectListing> objects = this.client.list(this.withTrailingSlash(source)).getObjects();
        if (objects.isEmpty()) {
            throw new OcflNoSuchFileException(String.format("Directory %s does not exist", source));
        }
        objects.forEach(object -> {
            Path destination = outputPath.resolve(object.getKeySuffix());
            UncheckedFiles.createDirectories(destination.getParent());
            try (InputStream stream = this.client.downloadStream(object.getKey().getPath());){
                Files.copy(stream, destination, new CopyOption[0]);
            }
            catch (IOException e) {
                throw OcflIOException.from((IOException)e);
            }
        });
    }

    @Override
    public void copyFileInto(Path source, String destination, String mediaType) {
        this.client.uploadFile(source, destination, mediaType);
    }

    @Override
    public void copyFileInternal(String sourceFile, String destinationFile) {
        try {
            this.client.copyObject(sourceFile, destinationFile);
        }
        catch (KeyNotFoundException e) {
            throw new OcflNoSuchFileException(String.format("%s was not found", sourceFile), (Exception)e);
        }
    }

    @Override
    public void moveDirectoryInto(Path source, String destination) {
        this.failOnExistingDir(destination);
        List<String> objectKeys = Collections.synchronizedList(new ArrayList());
        try (Stream<Path> paths = Files.walk(source, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                String relative = FileUtil.pathToStringStandardSeparator(source.relativize((Path)file));
                String key = FileUtil.pathJoinFailEmpty(destination, relative);
                this.client.uploadFile((Path)file, key);
                objectKeys.add(key);
            });
        }
        catch (IOException | RuntimeException e) {
            this.client.safeDeleteObjects(objectKeys);
            if (e instanceof IOException) {
                throw OcflIOException.from((IOException)((IOException)e));
            }
            throw (RuntimeException)e;
        }
    }

    @Override
    public void moveDirectoryInternal(String source, String destination) {
        this.failOnExistingDir(destination);
        List<Listing> files = this.listRecursive(source);
        ArrayList<String> srcKeys = new ArrayList<String>();
        ArrayList<String> dstKeys = new ArrayList<String>();
        try {
            for (Listing file : files) {
                if (!file.isFile()) continue;
                String srcFile = FileUtil.pathJoinIgnoreEmpty(source, file.getRelativePath());
                String dstFile = FileUtil.pathJoinIgnoreEmpty(destination, file.getRelativePath());
                this.client.copyObject(srcFile, dstFile);
                srcKeys.add(srcFile);
                dstKeys.add(dstFile);
            }
        }
        catch (RuntimeException e) {
            this.client.safeDeleteObjects(dstKeys);
            throw e;
        }
        this.client.safeDeleteObjects(srcKeys);
    }

    @Override
    public void deleteDirectory(String path) {
        this.client.deletePath(path);
    }

    @Override
    public void deleteFile(String path) {
        this.client.deleteObjects(List.of(path));
    }

    @Override
    public void deleteFiles(Collection<String> paths) {
        this.client.deleteObjects(paths);
    }

    @Override
    public void deleteEmptyDirsDown(String path) {
    }

    @Override
    public void deleteEmptyDirsUp(String path) {
    }

    private void failOnExistingFile(String path) {
        if (this.fileExists(path)) {
            throw new OcflFileAlreadyExistsException(String.format("File %s already exists", path));
        }
    }

    private void failOnExistingDir(String path) {
        try {
            this.listDirectory(path);
            throw new OcflFileAlreadyExistsException(String.format("Directory %s already exists", path));
        }
        catch (OcflNoSuchFileException ocflNoSuchFileException) {
            return;
        }
    }

    private String withTrailingSlash(String value) {
        if (value.endsWith("/")) {
            return value;
        }
        return value + "/";
    }
}

