/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.util;

import edu.wisc.library.ocfl.api.exception.OcflIOException;
import edu.wisc.library.ocfl.api.util.Enforce;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class NamasteTypeFile {
    private static final String NAMASTE_PREFIX = "0=";
    private final String tagValue;

    public NamasteTypeFile(String tagValue) {
        this.tagValue = Enforce.notBlank((String)tagValue, (String)"tagValue cannot be blank");
    }

    public String fileName() {
        return NAMASTE_PREFIX + this.tagValue;
    }

    public String fileContent() {
        return this.tagValue + "\n";
    }

    public void writeFile(Path directory) {
        try {
            Files.writeString(directory.resolve(this.fileName()), (CharSequence)this.fileContent(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw OcflIOException.from((IOException)e);
        }
    }
}

