/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.validation;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.wisc.library.ocfl.api.exception.OcflIOException;
import edu.wisc.library.ocfl.api.model.ValidationCode;
import edu.wisc.library.ocfl.api.model.ValidationResults;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.validation.ValidationResultsBuilder;
import edu.wisc.library.ocfl.core.validation.model.SimpleInventory;
import edu.wisc.library.ocfl.core.validation.model.SimpleUser;
import edu.wisc.library.ocfl.core.validation.model.SimpleVersion;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

public class SimpleInventoryParser {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public ParseSimpleInventoryResult parse(InputStream inventoryStream, String inventoryPath) {
        Enforce.notNull((Object)inventoryStream, (String)"jsonTree cannot be null");
        Enforce.notNull((Object)inventoryPath, (String)"inventoryPath cannot be null");
        SimpleInventory inventory = null;
        ValidationResultsBuilder results = new ValidationResultsBuilder();
        JsonNode jsonTree = this.parseStream(inventoryStream, inventoryPath, results);
        if (jsonTree != null) {
            inventory = this.convertToSimpleInventory(jsonTree, inventoryPath, results);
        }
        return new ParseSimpleInventoryResult(inventory, results.build());
    }

    private JsonNode parseStream(InputStream inventoryStream, String inventoryPath, ValidationResultsBuilder results) {
        try {
            return this.objectMapper.readTree(inventoryStream);
        }
        catch (JsonParseException e) {
            results.addIssue(ValidationCode.E033, "Inventory at %s is an invalid JSON document", inventoryPath);
            return null;
        }
        catch (IOException e) {
            throw new OcflIOException((Exception)e);
        }
    }

    private SimpleInventory convertToSimpleInventory(JsonNode jsonTree, String inventoryPath, ValidationResultsBuilder results) {
        SimpleInventory inventory = new SimpleInventory();
        jsonTree.fields().forEachRemaining(entry -> {
            String fieldName = (String)entry.getKey();
            JsonNode field = (JsonNode)entry.getValue();
            switch (fieldName) {
                case "id": {
                    inventory.setId(this.parseString(field, () -> results.addIssue(ValidationCode.E037, "Inventory id must be a string in %s", inventoryPath)));
                    break;
                }
                case "type": {
                    inventory.setType(this.parseString(field, () -> results.addIssue(ValidationCode.E038, "Inventory type must be a string in %s", inventoryPath)));
                    break;
                }
                case "digestAlgorithm": {
                    inventory.setDigestAlgorithm(this.parseString(field, () -> results.addIssue(ValidationCode.E033, "Inventory digest algorithm must be a string in %s", inventoryPath)));
                    break;
                }
                case "head": {
                    inventory.setHead(this.parseString(field, () -> results.addIssue(ValidationCode.E040, "Inventory head must be a string in %s", inventoryPath)));
                    break;
                }
                case "contentDirectory": {
                    inventory.setContentDirectory(this.parseString(field, () -> results.addIssue(ValidationCode.E033, "Inventory content directory must be a string in %s", inventoryPath)));
                    break;
                }
                case "fixity": {
                    inventory.setFixity(this.parseFixity(field, inventoryPath, results));
                    break;
                }
                case "manifest": {
                    inventory.setManifest(this.parseManifest(field, inventoryPath, results));
                    break;
                }
                case "versions": {
                    inventory.setVersions(this.parseVersions(field, inventoryPath, results));
                    break;
                }
                default: {
                    results.addIssue(ValidationCode.E102, "Inventory cannot contain unknown property %s in %s", fieldName, inventoryPath);
                }
            }
        });
        return inventory;
    }

    private SimpleVersion parseVersion(JsonNode versionNode, String versionNum, String inventoryPath, ValidationResultsBuilder results) {
        SimpleVersion version = new SimpleVersion();
        versionNode.fields().forEachRemaining(entry -> {
            String fieldName = (String)entry.getKey();
            JsonNode field = (JsonNode)entry.getValue();
            switch (fieldName) {
                case "created": {
                    version.setCreated(this.parseString(field, () -> results.addIssue(ValidationCode.E049, "Inventory version %s created timestamp must be a string in %s", versionNum, inventoryPath)));
                    break;
                }
                case "message": {
                    version.setMessage(this.parseString(field, () -> results.addIssue(ValidationCode.E094, "Inventory version %s message must be a string in %s", versionNum, inventoryPath)));
                    break;
                }
                case "user": {
                    version.setUser(this.parseUser(field, versionNum, inventoryPath, results));
                    break;
                }
                case "state": {
                    version.setState(this.parseState(field, versionNum, inventoryPath, results));
                    break;
                }
                default: {
                    results.addIssue(ValidationCode.E102, "Inventory version %s cannot contain unknown property %s in %s", versionNum, fieldName, inventoryPath);
                }
            }
        });
        return version;
    }

    private SimpleUser parseUser(JsonNode userNode, String versionNum, String inventoryPath, ValidationResultsBuilder results) {
        SimpleUser user = new SimpleUser();
        if (!userNode.isNull()) {
            if (userNode.isObject()) {
                userNode.fields().forEachRemaining(entry -> {
                    String fieldName = (String)entry.getKey();
                    JsonNode field = (JsonNode)entry.getValue();
                    switch (fieldName) {
                        case "name": {
                            user.setName(this.parseString(field, () -> results.addIssue(ValidationCode.E054, "Inventory version %s user name must be a string in %s", versionNum, inventoryPath)));
                            break;
                        }
                        case "address": {
                            user.setAddress(this.parseString(field, () -> results.addIssue(ValidationCode.E033, "Inventory version %s user address must be a string in %s", versionNum, inventoryPath)));
                            break;
                        }
                        default: {
                            results.addIssue(ValidationCode.E102, "Inventory version %s user cannot contain unknown property %s in %s", versionNum, fieldName, inventoryPath);
                        }
                    }
                });
            } else {
                results.addIssue(ValidationCode.E054, "Inventory version %s user must be an object in %s", versionNum, inventoryPath);
            }
        }
        return user;
    }

    private Map<String, List<String>> parseManifest(JsonNode field, String inventoryPath, ValidationResultsBuilder results) {
        Map<String, List<String>> manifest = null;
        if (!field.isNull()) {
            if (field.isObject()) {
                manifest = this.parseDigestPathsMap(field, () -> results.addIssue(ValidationCode.E096, "Inventory manifest cannot contain null digests in %s", inventoryPath), digest -> results.addIssue(ValidationCode.E092, "Inventory manifest cannot contain null content paths for %s in %s", digest, inventoryPath), digest -> results.addIssue(ValidationCode.E092, "Inventory manifest digest %s must reference a list value in %s", digest, inventoryPath), digest -> results.addIssue(ValidationCode.E092, "Inventory manifest digest %s cannot contain null paths in %s", digest, inventoryPath), digest -> results.addIssue(ValidationCode.E092, "Inventory manifest digest %s content paths must be strings in %s", digest, inventoryPath));
            } else {
                results.addIssue(ValidationCode.E033, "Inventory manifest must be an object in %s", inventoryPath);
            }
        }
        return manifest;
    }

    private Map<String, SimpleVersion> parseVersions(JsonNode field, String inventoryPath, ValidationResultsBuilder results) {
        HashMap<String, SimpleVersion> versions = null;
        if (!field.isNull()) {
            if (field.isObject()) {
                versions = new HashMap<String, SimpleVersion>();
                Iterator it = field.fields();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    String num = (String)entry.getKey();
                    JsonNode versionNode = (JsonNode)entry.getValue();
                    if (num == null) {
                        results.addIssue(ValidationCode.E046, "Inventory version numbers cannot be null in %s", inventoryPath);
                        continue;
                    }
                    if (versionNode.isNull()) {
                        results.addIssue(ValidationCode.E047, "Inventory version objects cannot be null in %s", inventoryPath);
                        continue;
                    }
                    if (versionNode.isObject()) {
                        SimpleVersion version = this.parseVersion(versionNode, num, inventoryPath, results);
                        versions.put(num, version);
                        continue;
                    }
                    results.addIssue(ValidationCode.E047, "Inventory versions must be objects in %s", inventoryPath);
                }
            } else {
                results.addIssue(ValidationCode.E044, "Inventory versions must be an object in %s", inventoryPath);
            }
        }
        return versions;
    }

    private Map<String, List<String>> parseState(JsonNode stateNode, String versionNum, String inventoryPath, ValidationResultsBuilder results) {
        Map<String, List<String>> state = null;
        if (!stateNode.isNull()) {
            if (stateNode.isObject()) {
                state = this.parseDigestPathsMap(stateNode, () -> results.addIssue(ValidationCode.E050, "Inventory version %s cannot contain null digests in %s", versionNum, inventoryPath), digest -> results.addIssue(ValidationCode.E050, "Inventory version %s cannot contain null logical paths for %s in %s", versionNum, digest, inventoryPath), digest -> results.addIssue(ValidationCode.E050, "Inventory version %s digest %s must reference a list value in %s", versionNum, digest, inventoryPath), digest -> results.addIssue(ValidationCode.E051, "Inventory version %s digest %s cannot contain null paths in %s", versionNum, digest, inventoryPath), digest -> results.addIssue(ValidationCode.E051, "Inventory version %s digest %s logical paths must be strings in %s", versionNum, digest, inventoryPath));
            } else {
                results.addIssue(ValidationCode.E050, "Inventory version %s state must be an object in %s", versionNum, inventoryPath);
            }
        }
        return state;
    }

    private Map<String, Map<String, List<String>>> parseFixity(JsonNode field, String inventoryPath, ValidationResultsBuilder results) {
        HashMap<String, Map<String, List<String>>> fixity = null;
        if (!field.isNull()) {
            if (field.isObject()) {
                fixity = new HashMap<String, Map<String, List<String>>>();
                Iterator it = field.fields();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    String algorithm = (String)entry.getKey();
                    JsonNode digestsNode = (JsonNode)entry.getValue();
                    if (algorithm == null) {
                        results.addIssue(ValidationCode.E056, "Inventory fixity cannot contain null digest algorithms in %s", inventoryPath);
                        continue;
                    }
                    if (digestsNode.isNull()) {
                        results.addIssue(ValidationCode.E057, "Inventory fixity for %s cannot be null in %s", algorithm, inventoryPath);
                        continue;
                    }
                    if (digestsNode.isObject()) {
                        Map<String, List<String>> fixitySection = this.parseDigestPathsMap(digestsNode, () -> results.addIssue(ValidationCode.E057, "Inventory fixity algorithm %s cannot contain null digests in %s", algorithm, inventoryPath), digest -> results.addIssue(ValidationCode.E057, "Inventory fixity algorithm %s digest %s cannot contain null content paths in %s", algorithm, digest, inventoryPath), digest -> results.addIssue(ValidationCode.E057, "Inventory fixity algorithm %s digest %s must reference a list value in %s", algorithm, digest, inventoryPath), digest -> results.addIssue(ValidationCode.E057, "Inventory fixity algorithm %s digest %s cannot contain null paths in %s", algorithm, digest, inventoryPath), digest -> results.addIssue(ValidationCode.E057, "Inventory fixity algorithm %s digest %s content paths must be strings in %s", algorithm, digest, inventoryPath));
                        fixity.put(algorithm, fixitySection);
                        continue;
                    }
                    results.addIssue(ValidationCode.E057, "Inventory fixity for %s must be an object in %s", algorithm, inventoryPath);
                }
            } else {
                results.addIssue(ValidationCode.E056, "Inventory fixity must be an object in %s", inventoryPath);
            }
        }
        return fixity;
    }

    private Map<String, List<String>> parseDigestPathsMap(JsonNode field, Runnable keyIsNull, Consumer<String> pathsIsNull, Consumer<String> pathsIsWrongType, Consumer<String> pathIsNull, Consumer<String> pathIsWrongType) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        field.fields().forEachRemaining(entry -> {
            String digest = (String)entry.getKey();
            JsonNode pathsNode = (JsonNode)entry.getValue();
            if (digest == null) {
                keyIsNull.run();
            } else if (pathsNode.isNull()) {
                pathsIsNull.accept(digest);
            } else if (!pathsNode.isArray()) {
                pathsIsWrongType.accept(digest);
            } else {
                ArrayList paths = new ArrayList();
                map.put(digest, paths);
                pathsNode.elements().forEachRemaining(pathNode -> {
                    if (pathNode.isNull()) {
                        pathIsNull.accept(digest);
                    } else if (!pathNode.isTextual()) {
                        pathIsWrongType.accept(digest);
                    } else {
                        paths.add(pathNode.textValue());
                    }
                });
            }
        });
        return map;
    }

    private String parseString(JsonNode field, Runnable isWrongType) {
        String value = null;
        if (!field.isNull()) {
            if (field.isTextual()) {
                value = field.textValue();
            } else {
                isWrongType.run();
            }
        }
        return value;
    }

    public static class ParseSimpleInventoryResult {
        private final Optional<SimpleInventory> inventory;
        private final ValidationResults validationResults;

        public ParseSimpleInventoryResult(SimpleInventory inventory, ValidationResults validationResults) {
            this.inventory = Optional.ofNullable(inventory);
            this.validationResults = (ValidationResults)Enforce.notNull((Object)validationResults, (String)"validationResults cannot be null");
        }

        public Optional<SimpleInventory> getInventory() {
            return this.inventory;
        }

        public ValidationResults getValidationResults() {
            return this.validationResults;
        }
    }
}

