/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.db;

import edu.wisc.library.ocfl.api.exception.LockException;
import edu.wisc.library.ocfl.api.exception.ObjectOutOfSyncException;
import edu.wisc.library.ocfl.api.exception.OcflDbException;
import edu.wisc.library.ocfl.api.exception.OcflIOException;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.model.VersionNum;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.db.ObjectDetailsDatabase;
import edu.wisc.library.ocfl.core.db.OcflObjectDetails;
import edu.wisc.library.ocfl.core.model.Inventory;
import edu.wisc.library.ocfl.core.model.RevisionNum;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseObjectDetailsDatabase
implements ObjectDetailsDatabase {
    private static final Logger LOG = LoggerFactory.getLogger(BaseObjectDetailsDatabase.class);
    private final String tableName;
    private final DataSource dataSource;
    private final boolean storeInventory;
    private final long waitMillis;
    private final String lockFailCode;
    private final String selectDetailsQuery;
    private final String deleteDetailsQuery;
    private final String rowLockQuery;
    private final String updateDetailsQuery;
    private final String insertDetailsQuery;
    private final String selectDigestQuery;
    private final String deleteAllQuery;

    public BaseObjectDetailsDatabase(String tableName, DataSource dataSource, boolean storeInventory, long waitTime, TimeUnit timeUnit, String lockFailCode) {
        this.tableName = Enforce.notBlank((String)tableName, (String)"tableName cannot be blank");
        this.dataSource = (DataSource)Enforce.notNull((Object)dataSource, (String)"dataSource cannot be null");
        this.storeInventory = storeInventory;
        this.lockFailCode = Enforce.notBlank((String)lockFailCode, (String)"lockFailCode cannot be blank");
        this.waitMillis = timeUnit.toMillis(waitTime);
        this.selectDetailsQuery = this.selectDetailsQuery(tableName);
        this.deleteDetailsQuery = this.deleteDetailsQuery(tableName);
        this.rowLockQuery = this.rowLockQuery(tableName);
        this.updateDetailsQuery = this.updateDetailsQuery(tableName);
        this.insertDetailsQuery = this.insertDetailsQuery(tableName);
        this.selectDigestQuery = this.selectDigestQuery(tableName);
        this.deleteAllQuery = this.deleteAllQuery(tableName);
    }

    protected abstract void setLockWaitTimeout(Connection var1, long var2) throws SQLException;

    protected abstract boolean isConcurrentWriteException(SQLException var1);

    protected String selectDetailsQuery(String tableName) {
        return String.format("SELECT object_id, version_id, object_root_path, revision_id, inventory_digest, digest_algorithm, inventory, update_timestamp FROM %s WHERE object_id = ?", tableName);
    }

    protected String deleteDetailsQuery(String tableName) {
        return String.format("DELETE FROM %s WHERE object_id = ?", tableName);
    }

    protected String rowLockQuery(String tableName) {
        return String.format("SELECT version_id, revision_id FROM %s WHERE object_id = ? FOR UPDATE", tableName);
    }

    protected String updateDetailsQuery(String tableName) {
        return String.format("UPDATE %s SET (version_id, object_root_path, revision_id, inventory_digest, digest_algorithm, inventory, update_timestamp) = (?, ?, ?, ?, ?, ?, ?) WHERE object_id = ?", tableName);
    }

    protected String insertDetailsQuery(String tableName) {
        return String.format("INSERT INTO %s (object_id, version_id, object_root_path, revision_id, inventory_digest, digest_algorithm, inventory, update_timestamp) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", tableName);
    }

    protected String selectDigestQuery(String tableName) {
        return String.format("SELECT inventory_digest FROM %s WHERE object_id = ?", tableName);
    }

    protected String deleteAllQuery(String tableName) {
        return String.format("DELETE FROM %s", tableName);
    }

    @Override
    public OcflObjectDetails retrieveObjectDetails(String objectId) {
        Enforce.notBlank((String)objectId, (String)"objectId cannot be blank");
        OcflObjectDetails details = null;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.selectDetailsQuery);){
            statement.setString(1, objectId);
            try (ResultSet rs = statement.executeQuery();){
                if (rs.next()) {
                    details = new OcflObjectDetails().setObjectId(rs.getString(1)).setVersionNum(VersionNum.fromString((String)rs.getString(2))).setObjectRootPath(rs.getString(3)).setRevisionNum(this.revisionNumFromString(rs.getString(4))).setInventoryDigest(rs.getString(5)).setDigestAlgorithm(DigestAlgorithm.fromOcflName((String)rs.getString(6))).setInventory(rs.getBytes(7)).setUpdateTimestamp(rs.getTimestamp(8).toLocalDateTime());
                }
            }
        }
        catch (SQLException e) {
            throw new OcflDbException((Throwable)e);
        }
        return details;
    }

    @Override
    public void addObjectDetails(Inventory inventory, String inventoryDigest, byte[] inventoryBytes) {
        Enforce.notNull((Object)inventory, (String)"inventory cannot be null");
        Enforce.notBlank((String)inventoryDigest, (String)"inventoryDigest cannot be blank");
        Enforce.notNull((Object)inventoryBytes, (String)"inventoryBytes cannot be null");
        try {
            this.updateObjectDetailsInternal(inventory, inventoryDigest, new ByteArrayInputStream(inventoryBytes), () -> {});
        }
        catch (ObjectOutOfSyncException e) {
            String digest = this.retrieveDigest(inventory.getId());
            if (inventoryDigest.equalsIgnoreCase(digest)) {
                return;
            }
            throw e;
        }
    }

    @Override
    public void updateObjectDetails(Inventory inventory, String inventoryDigest, Path inventoryFile, Runnable runnable) {
        Enforce.notNull((Object)inventory, (String)"inventory cannot be null");
        Enforce.notBlank((String)inventoryDigest, (String)"inventoryDigest cannot be blank");
        Enforce.notNull((Object)inventoryFile, (String)"inventoryFile cannot be null");
        Enforce.notNull((Object)runnable, (String)"runnable cannot be null");
        try (BufferedInputStream inventoryStream = new BufferedInputStream(Files.newInputStream(inventoryFile, new OpenOption[0]));){
            this.updateObjectDetailsInternal(inventory, inventoryDigest, inventoryStream, runnable);
        }
        catch (IOException e) {
            throw new OcflIOException((Exception)e);
        }
    }

    @Override
    public void deleteObjectDetails(String objectId) {
        Enforce.notBlank((String)objectId, (String)"objectId cannot be blank");
        try (Connection connection = this.dataSource.getConnection();){
            connection.setAutoCommit(false);
            this.setLockWaitTimeout(connection, this.waitMillis);
            try (PreparedStatement statement = connection.prepareStatement(this.deleteDetailsQuery);){
                statement.setString(1, objectId);
                statement.executeUpdate();
                connection.commit();
            }
            catch (Exception e) {
                connection.rollback();
                throw e;
            }
            finally {
                this.safeEnableAutoCommit(connection);
            }
        }
        catch (SQLException e) {
            this.throwLockException(e, objectId);
            throw new OcflDbException((Throwable)e);
        }
    }

    @Override
    public void deleteAllDetails() {
        LOG.debug("Clearing all entries in the {} table", (Object)this.tableName);
        try (Connection connection = this.dataSource.getConnection();){
            this.setLockWaitTimeout(connection, this.waitMillis);
            try (PreparedStatement statement = connection.prepareStatement(this.deleteAllQuery);){
                statement.executeUpdate();
            }
        }
        catch (SQLException e) {
            this.throwLockException(e);
            throw new OcflDbException((Throwable)e);
        }
    }

    private void updateObjectDetailsInternal(Inventory inventory, String inventoryDigest, InputStream inventoryStream, Runnable runnable) {
        try (Connection connection = this.dataSource.getConnection();){
            connection.setAutoCommit(false);
            this.setLockWaitTimeout(connection, this.waitMillis);
            try {
                this.insertInventory(connection, inventory, inventoryDigest, inventoryStream);
                runnable.run();
                connection.commit();
            }
            catch (Exception e) {
                connection.rollback();
                throw e;
            }
            finally {
                this.safeEnableAutoCommit(connection);
            }
        }
        catch (SQLException e) {
            throw new OcflDbException((Throwable)e);
        }
    }

    private void insertInventory(Connection connection, Inventory inventory, String inventoryDigest, InputStream inventoryStream) throws SQLException {
        try (PreparedStatement lockStatement = connection.prepareStatement(this.rowLockQuery);){
            lockStatement.setString(1, inventory.getId());
            try (ResultSet lockResult = lockStatement.executeQuery();){
                if (lockResult.next()) {
                    VersionNum existingVersionNum = VersionNum.fromString((String)lockResult.getString(1));
                    RevisionNum existingRevisionNum = this.revisionNumFromString(lockResult.getString(2));
                    this.verifyObjectDetailsState(existingVersionNum, existingRevisionNum, inventory);
                    this.executeUpdateDetails(connection, inventory, inventoryDigest, inventoryStream);
                } else {
                    this.executeInsertDetails(connection, inventory, inventoryDigest, inventoryStream);
                }
            }
        }
        catch (SQLException e) {
            this.throwLockException(e, inventory.getId());
            throw e;
        }
    }

    private void executeUpdateDetails(Connection connection, Inventory inventory, String inventoryDigest, InputStream inventoryStream) throws SQLException {
        try (PreparedStatement insertStatement = connection.prepareStatement(this.updateDetailsQuery);){
            insertStatement.setString(1, inventory.getHead().toString());
            insertStatement.setString(2, inventory.getObjectRootPath());
            insertStatement.setString(3, this.revisionNumStr(inventory.getRevisionNum()));
            insertStatement.setString(4, inventoryDigest);
            insertStatement.setString(5, inventory.getDigestAlgorithm().getOcflName());
            if (this.storeInventory) {
                insertStatement.setBinaryStream(6, inventoryStream);
            } else {
                insertStatement.setNull(6, -2);
            }
            insertStatement.setTimestamp(7, Timestamp.valueOf(LocalDateTime.now()));
            insertStatement.setString(8, inventory.getId());
            insertStatement.executeUpdate();
        }
    }

    private void executeInsertDetails(Connection connection, Inventory inventory, String inventoryDigest, InputStream inventoryStream) throws SQLException {
        try (PreparedStatement insertStatement = connection.prepareStatement(this.insertDetailsQuery);){
            insertStatement.setString(1, inventory.getId());
            insertStatement.setString(2, inventory.getHead().toString());
            insertStatement.setString(3, inventory.getObjectRootPath());
            insertStatement.setString(4, this.revisionNumStr(inventory.getRevisionNum()));
            insertStatement.setString(5, inventoryDigest);
            insertStatement.setString(6, inventory.getDigestAlgorithm().getOcflName());
            if (this.storeInventory) {
                insertStatement.setBinaryStream(7, inventoryStream);
            } else {
                insertStatement.setNull(7, -2);
            }
            insertStatement.setTimestamp(8, Timestamp.valueOf(LocalDateTime.now()));
            insertStatement.executeUpdate();
        }
        catch (SQLException e) {
            if (this.isConcurrentWriteException(e)) {
                throw this.outOfSyncException(inventory.getId());
            }
            throw e;
        }
    }

    /*
     * Exception decompiling
     */
    private String retrieveDigest(String objectId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String revisionNumStr(RevisionNum revisionNum) {
        return revisionNum == null ? null : revisionNum.toString();
    }

    private RevisionNum revisionNumFromString(String revisionNum) {
        if (revisionNum == null) {
            return null;
        }
        return RevisionNum.fromString(revisionNum);
    }

    private void verifyObjectDetailsState(VersionNum existingVersionNum, RevisionNum existingRevisionNum, Inventory inventory) {
        if (existingRevisionNum != null) {
            if (!Objects.equals(existingVersionNum, inventory.getHead())) {
                throw this.outOfSyncException(inventory.getId());
            }
            if (inventory.getRevisionNum() != null && !Objects.equals(existingRevisionNum.nextRevisionNum(), inventory.getRevisionNum())) {
                throw this.outOfSyncException(inventory.getId());
            }
        } else {
            if (!Objects.equals(existingVersionNum.nextVersionNum(), inventory.getHead())) {
                throw this.outOfSyncException(inventory.getId());
            }
            if (inventory.getRevisionNum() != null && !Objects.equals(RevisionNum.R1, inventory.getRevisionNum())) {
                throw this.outOfSyncException(inventory.getId());
            }
        }
    }

    private ObjectOutOfSyncException outOfSyncException(String objectId) {
        throw new ObjectOutOfSyncException(String.format("Cannot update object %s because its state is out of sync with the current state in the database.", objectId));
    }

    private void throwLockException(SQLException e, String objectId) {
        if (this.lockFailCode.equals(e.getSQLState())) {
            throw new LockException("Failed to acquire lock for object " + objectId);
        }
    }

    private void throwLockException(SQLException e) {
        if (this.lockFailCode.equals(e.getSQLState())) {
            throw new LockException("Failed to acquire lock: " + e.getMessage());
        }
    }

    private void safeEnableAutoCommit(Connection connection) {
        try {
            connection.setAutoCommit(true);
        }
        catch (Exception e) {
            LOG.warn("Failed to enable autocommit", (Throwable)e);
        }
    }
}

