/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.db;

import edu.wisc.library.ocfl.api.exception.OcflDbException;
import edu.wisc.library.ocfl.api.exception.OcflJavaException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import javax.sql.DataSource;

public enum DbType {
    POSTGRES("PostgreSQL"),
    MARIADB("MariaDB"),
    H2("H2");

    private String productName;

    private DbType(String productName) {
        this.productName = productName;
    }

    public static DbType fromDataSource(DataSource dataSource) {
        DbType dbType;
        block8: {
            Connection connection = dataSource.getConnection();
            try {
                String productName = connection.getMetaData().getDatabaseProductName();
                dbType = Arrays.stream(DbType.values()).filter(v -> Objects.equals(v.productName, productName)).findFirst().orElseThrow(() -> new OcflJavaException(String.format("%s is not mapped to a DbType.", productName)));
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new OcflDbException((Throwable)e);
                }
            }
            connection.close();
        }
        return dbType;
    }
}

