/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.path.constraint;

import edu.wisc.library.ocfl.api.exception.PathConstraintException;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.path.constraint.PathCharConstraint;
import java.util.BitSet;

public class BitSetPathCharConstraint
implements PathCharConstraint {
    private final BitSet charSet;
    private final boolean blockList;

    public static BitSetPathCharConstraint blockList(char ... chars) {
        return BitSetPathCharConstraint.build(true, chars);
    }

    public static BitSetPathCharConstraint blockListRange(char start, char end) {
        return BitSetPathCharConstraint.build(true, start, end);
    }

    public static BitSetPathCharConstraint acceptList(char ... chars) {
        return BitSetPathCharConstraint.build(false, chars);
    }

    public static BitSetPathCharConstraint acceptListRange(char start, char end) {
        return BitSetPathCharConstraint.build(false, start, end);
    }

    private static BitSetPathCharConstraint build(boolean blockList, char ... chars) {
        BitSet charSet = new BitSet(256);
        for (char c : chars) {
            charSet.set(c);
        }
        return new BitSetPathCharConstraint(blockList, charSet);
    }

    private static BitSetPathCharConstraint build(boolean blockList, char start, char end) {
        Enforce.expressionTrue((start < end ? 1 : 0) != 0, (Object)Character.valueOf(start), (String)"The start char must come before the end char.");
        BitSet charSet = new BitSet(256);
        for (char c = start; c <= end; c = (char)(c + '\u0001')) {
            charSet.set(c);
        }
        return new BitSetPathCharConstraint(blockList, charSet);
    }

    public BitSetPathCharConstraint(boolean blockList, BitSet charSet) {
        this.blockList = blockList;
        this.charSet = (BitSet)Enforce.notNull((Object)charSet, (String)"charSet cannot be null");
    }

    @Override
    public void apply(char c, String path) {
        if (this.charSet.get(c)) {
            if (this.blockList) {
                this.throwException(c, path);
            }
        } else if (!this.blockList) {
            this.throwException(c, path);
        }
    }

    private void throwException(char c, String path) {
        throw new PathConstraintException(String.format("The path contains the illegal character '%s'. Path: %s", Character.valueOf(c), path));
    }
}

