/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.storage.cloud;

import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.util.FileUtil;
import java.util.Objects;

public class CloudObjectKey {
    private final String prefix;
    private final String path;
    private final String key;

    public static Builder builder() {
        return new Builder();
    }

    private CloudObjectKey(String prefix, String path) {
        this.prefix = (String)Enforce.notNull((Object)prefix, (String)"prefix cannot be null");
        this.path = (String)Enforce.notNull((Object)path, (String)"path cannot be null");
        this.key = prefix.isBlank() ? this.path : FileUtil.pathJoinIgnoreEmpty(prefix, path);
    }

    private CloudObjectKey(String prefix, String path, String key) {
        this.prefix = (String)Enforce.notNull((Object)prefix, (String)"prefix cannot be null");
        this.path = (String)Enforce.notNull((Object)path, (String)"path cannot be null");
        this.key = Enforce.notBlank((String)key, (String)"key cannot be blank");
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPath() {
        return this.path;
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudObjectKey that = (CloudObjectKey)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public static class Builder {
        private String prefix = "";

        public Builder prefix(String prefix) {
            this.prefix = prefix == null ? "" : (prefix.endsWith("/") ? prefix.substring(0, this.indexLastNonSlash(prefix)) : prefix);
            return this;
        }

        private int indexLastNonSlash(String string) {
            for (int i = string.length(); i > 0; --i) {
                if (string.charAt(i - 1) == '/') continue;
                return i;
            }
            return 0;
        }

        public CloudObjectKey buildFromPath(String path) {
            return new CloudObjectKey(this.prefix, path);
        }

        public CloudObjectKey buildFromKey(String key) {
            Enforce.notBlank((String)key, (String)"key cannot be blank");
            if (this.prefix.isBlank()) {
                return new CloudObjectKey(this.prefix, key, key);
            }
            return new CloudObjectKey(this.prefix, key.substring(this.prefix.length() + 1), key);
        }
    }
}

