/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.storage.cloud;

import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.storage.cloud.CloudClient;
import edu.wisc.library.ocfl.core.storage.cloud.ListResult;
import edu.wisc.library.ocfl.core.storage.common.OcflObjectRootDirIterator;
import edu.wisc.library.ocfl.core.util.FileUtil;
import java.util.Iterator;

public class CloudOcflObjectRootDirIterator
extends OcflObjectRootDirIterator {
    private final CloudClient cloudClient;

    public CloudOcflObjectRootDirIterator(CloudClient cloudClient) {
        this.cloudClient = (CloudClient)Enforce.notNull((Object)cloudClient, (String)"cloudClient cannot be null");
    }

    @Override
    protected boolean isObjectRoot(String path) {
        ListResult listResult = this.cloudClient.list(FileUtil.pathJoinFailEmpty(path, "0=ocfl_object_"));
        return !listResult.getObjects().isEmpty();
    }

    @Override
    protected OcflObjectRootDirIterator.Directory createDirectory(String path) {
        return new CloudDirectory(path);
    }

    private class CloudDirectory
    implements OcflObjectRootDirIterator.Directory {
        private final Iterator<ListResult.DirectoryListing> childDirectories;

        CloudDirectory(String path) {
            ListResult listResult = CloudOcflObjectRootDirIterator.this.cloudClient.listDirectory(path);
            this.childDirectories = listResult.getDirectories().iterator();
        }

        @Override
        public String nextChildDirectory() {
            if (this.childDirectories.hasNext()) {
                String path = this.childDirectories.next().getPath();
                return path.substring(0, path.length() - 1);
            }
            return null;
        }

        @Override
        public void close() {
        }
    }
}

