/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.util;

import at.favre.lib.bytes.Bytes;
import edu.wisc.library.ocfl.api.exception.OcflIOException;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;

public final class DigestUtil {
    private static final int BUFFER_SIZE = 8192;

    private DigestUtil() {
    }

    public static String computeDigestHex(DigestAlgorithm algorithm, Path path) {
        return DigestUtil.computeDigestHex(algorithm.getMessageDigest(), path);
    }

    public static String computeDigestHex(MessageDigest digest, Path path) {
        return DigestUtil.computeDigestHex(digest, path, false);
    }

    public static String computeDigestHex(DigestAlgorithm algorithm, Path path, boolean upperCase) {
        return DigestUtil.computeDigestHex(algorithm.getMessageDigest(), path, upperCase);
    }

    public static String computeDigestHex(MessageDigest digest, Path path, boolean upperCase) {
        return Bytes.wrap((byte[])DigestUtil.computeDigest(digest, path)).encodeHex(upperCase);
    }

    public static byte[] computeDigest(DigestAlgorithm algorithm, Path path) {
        return DigestUtil.computeDigest(algorithm.getMessageDigest(), path);
    }

    public static byte[] computeDigest(MessageDigest digest, Path path) {
        byte[] byArray;
        block9: {
            FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);
            try {
                ByteBuffer buffer = ByteBuffer.allocateDirect(8192);
                while (channel.read(buffer) > -1) {
                    buffer.flip();
                    digest.update(buffer);
                    buffer.clear();
                }
                byArray = digest.digest();
                if (channel == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OcflIOException((Exception)e);
                }
            }
            channel.close();
        }
        return byArray;
    }

    public static byte[] computeDigest(DigestAlgorithm algorithm, ByteBuffer buffer) {
        MessageDigest digest = algorithm.getMessageDigest();
        digest.update(buffer);
        buffer.flip();
        return digest.digest();
    }

    public static String computeDigestHex(DigestAlgorithm algorithm, String value) {
        return DigestUtil.computeDigestHex(algorithm, value, false);
    }

    public static String computeDigestHex(DigestAlgorithm algorithm, String value, boolean upperCase) {
        return Bytes.from((CharSequence)value).hash(algorithm.getJavaStandardName()).encodeHex(upperCase);
    }

    public static String computeDigestHex(DigestAlgorithm algorithm, byte[] value) {
        return DigestUtil.computeDigestHex(algorithm, value, false);
    }

    public static String computeDigestHex(DigestAlgorithm algorithm, byte[] value, boolean upperCase) {
        return Bytes.wrap((byte[])value).hash(algorithm.getJavaStandardName()).encodeHex(upperCase);
    }
}

