/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.db;

import edu.wisc.library.ocfl.api.exception.OcflDbException;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.db.DbType;
import edu.wisc.library.ocfl.core.util.FileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableCreator {
    private static final Logger LOG = LoggerFactory.getLogger(TableCreator.class);
    private static final int MYSQL_ACCESS_DENIED_ERROR = 1142;
    private static final int MYSQL_NO_TABLE_ERROR = 1146;
    private static final String TABLE_TEST_QUERY = "SELECT 1 FROM %s LIMIT 1";
    private static final String LOCK_TABLE_FILE = "ocfl_object_lock.ddl.tmpl";
    private static final String OBJECT_DETAILS_TABLE_FILE = "ocfl_object_details.ddl.tmpl";
    private final Map<DbType, String> dbScriptDir = Map.of(DbType.POSTGRES, "db/postgresql", DbType.MARIADB, "db/mariadb", DbType.H2, "db/h2");
    private final DbType dbType;
    private final DataSource dataSource;

    public TableCreator(DbType dbType, DataSource dataSource) {
        this.dbType = (DbType)((Object)Enforce.notNull((Object)((Object)dbType), (String)"dbType cannot be null"));
        this.dataSource = (DataSource)Enforce.notNull((Object)dataSource, (String)"dataSource cannot be null");
    }

    public void createObjectLockTable(String tableName) {
        this.createTable(tableName, LOCK_TABLE_FILE);
    }

    public void createObjectDetailsTable(String tableName) {
        this.createTable(tableName, OBJECT_DETAILS_TABLE_FILE);
    }

    private void createTable(String tableName, String fileName) {
        block23: {
            Enforce.notBlank((String)tableName, (String)"tableName cannot be blank");
            try (Connection connection = this.dataSource.getConnection();){
                try {
                    String filePath = this.getSqlFilePath(fileName);
                    LOG.debug("Loading {}", (Object)filePath);
                    if (filePath == null) break block23;
                    try (InputStream stream = this.getClass().getResourceAsStream("/" + filePath);){
                        String ddlTemplate = this.streamToString(stream);
                        String ddl = String.format(ddlTemplate, tableName);
                        try (PreparedStatement statement = connection.prepareStatement(ddl);){
                            statement.executeUpdate();
                        }
                    }
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 1142) {
                        this.testTableExistence(connection, tableName);
                        break block23;
                    }
                    throw new OcflDbException((Throwable)e);
                }
            }
            catch (IOException | SQLException e) {
                throw new OcflDbException((Throwable)e);
            }
        }
    }

    private void testTableExistence(Connection connection, String tableName) {
        try (PreparedStatement statement = connection.prepareStatement(String.format(TABLE_TEST_QUERY, tableName));){
            statement.execute();
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 1146) {
                throw new OcflDbException(String.format("Table %s does not exist and user does not have permission to create it.", tableName));
            }
            throw new OcflDbException((Throwable)e);
        }
    }

    private String getSqlFilePath(String fileName) {
        String scriptDir = this.dbScriptDir.get((Object)this.dbType);
        if (scriptDir == null) {
            LOG.warn("There are no scripts configured for {}", (Object)this.dbType);
            return null;
        }
        return FileUtil.pathJoinFailEmpty(scriptDir, fileName);
    }

    private String streamToString(InputStream stream) throws IOException {
        return new String(stream.readAllBytes(), StandardCharsets.UTF_8);
    }
}

