/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.extension.storage.layout.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.extension.OcflExtensionConfig;
import java.util.Objects;

public class NTupleOmitPrefixStorageLayoutConfig
implements OcflExtensionConfig {
    private String delimiter;
    private int tupleSize = 3;
    private int numberOfTuples = 3;
    private ZeroPadding zeroPadding = ZeroPadding.LEFT;
    private boolean reverseObjectRoot = false;

    @Override
    public String getExtensionName() {
        return "0007-n-tuple-omit-prefix-storage-layout";
    }

    @Override
    @JsonIgnore
    public boolean hasParameters() {
        return true;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public int getTupleSize() {
        return this.tupleSize;
    }

    public int getNumberOfTuples() {
        return this.numberOfTuples;
    }

    public ZeroPadding getZeroPadding() {
        return this.zeroPadding;
    }

    public boolean isReverseObjectRoot() {
        return this.reverseObjectRoot;
    }

    public NTupleOmitPrefixStorageLayoutConfig setDelimiter(String delimiter) {
        this.delimiter = (String)Enforce.expressionTrue((delimiter != null && !delimiter.isEmpty() ? 1 : 0) != 0, (Object)delimiter, (String)"delimiter must not be empty");
        return this;
    }

    public NTupleOmitPrefixStorageLayoutConfig setTupleSize(int tupleSize) {
        this.tupleSize = (Integer)Enforce.expressionTrue((tupleSize >= 1 && tupleSize <= 32 ? 1 : 0) != 0, (Object)tupleSize, (String)"tupleSize must be between 1 and 32 inclusive");
        return this;
    }

    public NTupleOmitPrefixStorageLayoutConfig setNumberOfTuples(int numberOfTuples) {
        this.numberOfTuples = (Integer)Enforce.expressionTrue((numberOfTuples >= 1 && numberOfTuples <= 32 ? 1 : 0) != 0, (Object)numberOfTuples, (String)"numberOfTuples must be between 1 and 32 inclusive");
        return this;
    }

    public NTupleOmitPrefixStorageLayoutConfig setZeroPadding(ZeroPadding zeroPadding) {
        Enforce.notNull((Object)((Object)zeroPadding), (String)"Zero padding cannot be null");
        this.zeroPadding = zeroPadding;
        return this;
    }

    public NTupleOmitPrefixStorageLayoutConfig setReverseObjectRoot(boolean reverseObjectRoot) {
        this.reverseObjectRoot = reverseObjectRoot;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NTupleOmitPrefixStorageLayoutConfig that = (NTupleOmitPrefixStorageLayoutConfig)o;
        return this.delimiter.equals(that.delimiter) && this.tupleSize == that.tupleSize && this.numberOfTuples == that.numberOfTuples && this.zeroPadding == that.zeroPadding && this.reverseObjectRoot == that.reverseObjectRoot;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.delimiter, this.tupleSize, this.numberOfTuples, this.reverseObjectRoot, this.zeroPadding});
    }

    public String toString() {
        return "NTupleOmitPrefixStorageLayoutConfig{ delimiter='" + this.delimiter + "', tupleSize='" + this.tupleSize + "', numberOfTuples='" + this.numberOfTuples + "', zeroPadding='" + this.zeroPadding + "', reverseObjectRoot='" + this.reverseObjectRoot + "' }";
    }

    public static enum ZeroPadding {
        LEFT,
        RIGHT;


        @JsonValue
        public String toJson() {
            return this.name().toLowerCase();
        }
    }
}

