/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.storage;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.storage.DefaultOcflStorage;
import edu.wisc.library.ocfl.core.storage.DefaultOcflStorageInitializer;
import edu.wisc.library.ocfl.core.storage.OcflStorage;
import edu.wisc.library.ocfl.core.storage.OcflStorageInitializer;
import edu.wisc.library.ocfl.core.storage.cloud.CloudClient;
import edu.wisc.library.ocfl.core.storage.cloud.CloudStorage;
import edu.wisc.library.ocfl.core.storage.common.Storage;
import edu.wisc.library.ocfl.core.storage.filesystem.FileSystemStorage;
import edu.wisc.library.ocfl.core.util.ObjectMappers;
import java.nio.file.Path;

public class OcflStorageBuilder {
    private ObjectMapper objectMapper = ObjectMappers.prettyPrintMapper();
    private Storage storage;
    private OcflStorageInitializer initializer;
    private boolean verifyInventoryDigest = true;

    public static OcflStorageBuilder builder() {
        return new OcflStorageBuilder();
    }

    public OcflStorageBuilder storage(Storage storage) {
        this.storage = (Storage)Enforce.notNull((Object)storage, (String)"storage cannot be null");
        return this;
    }

    public OcflStorageBuilder fileSystem(Path storageRoot) {
        this.storage = new FileSystemStorage(storageRoot);
        return this;
    }

    public OcflStorageBuilder cloud(CloudClient cloudClient) {
        this.storage = new CloudStorage(cloudClient);
        return this;
    }

    public OcflStorageBuilder objectMapper(ObjectMapper objectMapper) {
        this.objectMapper = (ObjectMapper)Enforce.notNull((Object)objectMapper, (String)"objectMapper cannot be null");
        return this;
    }

    public OcflStorageBuilder initializer(OcflStorageInitializer initializer) {
        this.initializer = initializer;
        return this;
    }

    public OcflStorageBuilder verifyInventoryDigest(boolean verifyInventoryDigest) {
        this.verifyInventoryDigest = verifyInventoryDigest;
        return this;
    }

    public OcflStorage build() {
        Enforce.notNull((Object)this.storage, (String)"storage cannot be null");
        OcflStorageInitializer init = this.initializer;
        if (init == null) {
            init = new DefaultOcflStorageInitializer(this.storage, this.objectMapper);
        }
        return new DefaultOcflStorage(this.storage, this.verifyInventoryDigest, init);
    }
}

